/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class RemoveClusterLinkRecord
implements ApiMessage {
    Uuid clusterLinkId;
    String clusterLinkName;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("cluster_link_id", (Type)Type.UUID, "The ID of the cluster link to remove. All associated mirror topic metadata will be removed as well."), new Field("cluster_link_name", (Type)Type.COMPACT_STRING, "The name of the cluster link to remove."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public RemoveClusterLinkRecord(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public RemoveClusterLinkRecord(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public RemoveClusterLinkRecord() {
        this.clusterLinkId = Uuid.ZERO_UUID;
        this.clusterLinkName = "";
    }

    public short apiKey() {
        return 10003;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public final void read(Readable _readable, short _version, MessageContext _context) {
        this.clusterLinkId = _readable.readUuid();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field clusterLinkName was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field clusterLinkName had invalid length " + length);
        }
        this.clusterLinkName = _readable.readString(length);
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeUuid(this.clusterLinkId);
        byte[] _stringBytes = _cache.getSerializedValue((Object)this.clusterLinkName);
        _writable.writeUnsignedVarint(_stringBytes.length + 1);
        _writable.writeByteArray(_stringBytes);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(16);
        byte[] _stringBytes = this.clusterLinkName.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'clusterLinkName' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.clusterLinkName, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RemoveClusterLinkRecord)) {
            return false;
        }
        RemoveClusterLinkRecord other = (RemoveClusterLinkRecord)obj;
        if (!this.clusterLinkId.equals((Object)other.clusterLinkId)) {
            return false;
        }
        if (this.clusterLinkName == null ? other.clusterLinkName != null : !this.clusterLinkName.equals(other.clusterLinkName)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.clusterLinkId.hashCode();
        hashCode = 31 * hashCode + (this.clusterLinkName == null ? 0 : this.clusterLinkName.hashCode());
        return hashCode;
    }

    public RemoveClusterLinkRecord duplicate() {
        RemoveClusterLinkRecord _duplicate = new RemoveClusterLinkRecord();
        _duplicate.clusterLinkId = this.clusterLinkId;
        _duplicate.clusterLinkName = this.clusterLinkName;
        return _duplicate;
    }

    public String toString() {
        return "RemoveClusterLinkRecord(clusterLinkId=" + this.clusterLinkId.toString() + ", clusterLinkName=" + (String)(this.clusterLinkName == null ? "null" : "'" + this.clusterLinkName.toString() + "'") + ")";
    }

    public Uuid clusterLinkId() {
        return this.clusterLinkId;
    }

    public String clusterLinkName() {
        return this.clusterLinkName;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public RemoveClusterLinkRecord setClusterLinkId(Uuid v) {
        this.clusterLinkId = v;
        return this;
    }

    public RemoveClusterLinkRecord setClusterLinkName(String v) {
        this.clusterLinkName = v;
        return this;
    }
}

