/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.placement;

import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Unstable
public class UsableBroker {
    private final int id;
    private final Optional<String> rack;
    private final boolean fenced;
    private final int cell;

    public UsableBroker(int id, Optional<String> rack, boolean fenced) {
        this.id = id;
        this.rack = rack;
        this.fenced = fenced;
        this.cell = -1;
    }

    public UsableBroker(int id, Optional<String> rack, boolean fenced, int cell) {
        this.id = id;
        this.rack = rack;
        this.fenced = fenced;
        this.cell = cell;
    }

    public int id() {
        return this.id;
    }

    public Optional<String> rack() {
        return this.rack;
    }

    public boolean fenced() {
        return this.fenced;
    }

    public int cell() {
        return this.cell;
    }

    public boolean equals(Object o) {
        if (!(o instanceof UsableBroker)) {
            return false;
        }
        UsableBroker other = (UsableBroker)o;
        return other.id == this.id && other.rack.equals(this.rack) && other.fenced == this.fenced;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.rack, this.fenced, this.cell);
    }

    public String toString() {
        return "UsableBroker(id=" + this.id + ", rack=" + String.valueOf(this.rack) + ", fenced=" + this.fenced + ", cell=" + this.cell + ")";
    }
}

