/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.flink.apiserver.client;

import com.google.gson.reflect.TypeToken;
import io.confluent.flink.apiserver.client.ApiCallback;
import io.confluent.flink.apiserver.client.ApiClient;
import io.confluent.flink.apiserver.client.ApiException;
import io.confluent.flink.apiserver.client.ApiResponse;
import io.confluent.flink.apiserver.client.Configuration;
import io.confluent.flink.apiserver.client.Pair;
import io.confluent.flink.apiserver.client.model.SecretsV1alphaSecret;
import io.confluent.flink.apiserver.client.model.SecretsV1alphaSecretDestination;
import io.confluent.flink.apiserver.client.model.SecretsV1alphaSecretDestinationList;
import io.confluent.flink.apiserver.client.model.SecretsV1alphaSecretList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class SecretsV1alphaApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SecretsV1alphaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SecretsV1alphaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createSecretsV1alphaSecretCall(String environment, String org, SecretsV1alphaSecret secretsV1alphaSecret, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SecretsV1alphaSecret localVarPostBody = secretsV1alphaSecret;
        String localVarPath = "/apis/secrets/v1alpha/orgs/{org}/environments/{environment}/secrets".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSecretsV1alphaSecretValidateBeforeCall(String environment, String org, SecretsV1alphaSecret secretsV1alphaSecret, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createSecretsV1alphaSecret(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createSecretsV1alphaSecret(Async)");
        }
        if (secretsV1alphaSecret == null) {
            throw new ApiException("Missing the required parameter 'secretsV1alphaSecret' when calling createSecretsV1alphaSecret(Async)");
        }
        return this.createSecretsV1alphaSecretCall(environment, org, secretsV1alphaSecret, _callback);
    }

    public SecretsV1alphaSecret createSecretsV1alphaSecret(String environment, String org, SecretsV1alphaSecret secretsV1alphaSecret) throws ApiException {
        ApiResponse<SecretsV1alphaSecret> localVarResp = this.createSecretsV1alphaSecretWithHttpInfo(environment, org, secretsV1alphaSecret);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1alphaSecret> createSecretsV1alphaSecretWithHttpInfo(String environment, String org, SecretsV1alphaSecret secretsV1alphaSecret) throws ApiException {
        Call localVarCall = this.createSecretsV1alphaSecretValidateBeforeCall(environment, org, secretsV1alphaSecret, null);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecret>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSecretsV1alphaSecretAsync(String environment, String org, SecretsV1alphaSecret secretsV1alphaSecret, ApiCallback<SecretsV1alphaSecret> _callback) throws ApiException {
        Call localVarCall = this.createSecretsV1alphaSecretValidateBeforeCall(environment, org, secretsV1alphaSecret, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecret>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createSecretsV1alphaSecretDestinationCall(String environment, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SecretsV1alphaSecretDestination localVarPostBody = secretsV1alphaSecretDestination;
        String localVarPath = "/apis/secrets/v1alpha/orgs/{org}/environments/{environment}/secretdestinations".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSecretsV1alphaSecretDestinationValidateBeforeCall(String environment, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createSecretsV1alphaSecretDestination(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createSecretsV1alphaSecretDestination(Async)");
        }
        if (secretsV1alphaSecretDestination == null) {
            throw new ApiException("Missing the required parameter 'secretsV1alphaSecretDestination' when calling createSecretsV1alphaSecretDestination(Async)");
        }
        return this.createSecretsV1alphaSecretDestinationCall(environment, org, secretsV1alphaSecretDestination, _callback);
    }

    public SecretsV1alphaSecretDestination createSecretsV1alphaSecretDestination(String environment, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination) throws ApiException {
        ApiResponse<SecretsV1alphaSecretDestination> localVarResp = this.createSecretsV1alphaSecretDestinationWithHttpInfo(environment, org, secretsV1alphaSecretDestination);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1alphaSecretDestination> createSecretsV1alphaSecretDestinationWithHttpInfo(String environment, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination) throws ApiException {
        Call localVarCall = this.createSecretsV1alphaSecretDestinationValidateBeforeCall(environment, org, secretsV1alphaSecretDestination, null);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSecretsV1alphaSecretDestinationAsync(String environment, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination, ApiCallback<SecretsV1alphaSecretDestination> _callback) throws ApiException {
        Call localVarCall = this.createSecretsV1alphaSecretDestinationValidateBeforeCall(environment, org, secretsV1alphaSecretDestination, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSecretsV1alphaSecretCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/secrets/v1alpha/orgs/{org}/environments/{environment}/secrets/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSecretsV1alphaSecretValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteSecretsV1alphaSecret(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSecretsV1alphaSecret(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteSecretsV1alphaSecret(Async)");
        }
        return this.deleteSecretsV1alphaSecretCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public SecretsV1alphaSecret deleteSecretsV1alphaSecret(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<SecretsV1alphaSecret> localVarResp = this.deleteSecretsV1alphaSecretWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1alphaSecret> deleteSecretsV1alphaSecretWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteSecretsV1alphaSecretValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecret>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteSecretsV1alphaSecretAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<SecretsV1alphaSecret> _callback) throws ApiException {
        Call localVarCall = this.deleteSecretsV1alphaSecretValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecret>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSecretsV1alphaSecretDestinationCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/secrets/v1alpha/orgs/{org}/environments/{environment}/secretdestinations/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSecretsV1alphaSecretDestinationValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteSecretsV1alphaSecretDestination(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSecretsV1alphaSecretDestination(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteSecretsV1alphaSecretDestination(Async)");
        }
        return this.deleteSecretsV1alphaSecretDestinationCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public SecretsV1alphaSecretDestination deleteSecretsV1alphaSecretDestination(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<SecretsV1alphaSecretDestination> localVarResp = this.deleteSecretsV1alphaSecretDestinationWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1alphaSecretDestination> deleteSecretsV1alphaSecretDestinationWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteSecretsV1alphaSecretDestinationValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteSecretsV1alphaSecretDestinationAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<SecretsV1alphaSecretDestination> _callback) throws ApiException {
        Call localVarCall = this.deleteSecretsV1alphaSecretDestinationValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSecretsV1alphaSecretDestinationsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/secrets/v1alpha/orgs/{org}/environments/{environment}/secretdestinations".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSecretsV1alphaSecretDestinationsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listSecretsV1alphaSecretDestinations(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSecretsV1alphaSecretDestinations(Async)");
        }
        return this.listSecretsV1alphaSecretDestinationsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SecretsV1alphaSecretDestinationList listSecretsV1alphaSecretDestinations(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SecretsV1alphaSecretDestinationList> localVarResp = this.listSecretsV1alphaSecretDestinationsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1alphaSecretDestinationList> listSecretsV1alphaSecretDestinationsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSecretsV1alphaSecretDestinationsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretDestinationList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSecretsV1alphaSecretDestinationsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SecretsV1alphaSecretDestinationList> _callback) throws ApiException {
        Call localVarCall = this.listSecretsV1alphaSecretDestinationsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretDestinationList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSecretsV1alphaSecretDestinationsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/secrets/v1alpha/orgs/{org}/secretdestinations".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSecretsV1alphaSecretDestinationsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSecretsV1alphaSecretDestinationsForAllEnvironments(Async)");
        }
        return this.listSecretsV1alphaSecretDestinationsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SecretsV1alphaSecretDestinationList listSecretsV1alphaSecretDestinationsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SecretsV1alphaSecretDestinationList> localVarResp = this.listSecretsV1alphaSecretDestinationsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1alphaSecretDestinationList> listSecretsV1alphaSecretDestinationsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSecretsV1alphaSecretDestinationsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretDestinationList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSecretsV1alphaSecretDestinationsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SecretsV1alphaSecretDestinationList> _callback) throws ApiException {
        Call localVarCall = this.listSecretsV1alphaSecretDestinationsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretDestinationList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSecretsV1alphaSecretsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/secrets/v1alpha/orgs/{org}/environments/{environment}/secrets".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSecretsV1alphaSecretsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listSecretsV1alphaSecrets(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSecretsV1alphaSecrets(Async)");
        }
        return this.listSecretsV1alphaSecretsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SecretsV1alphaSecretList listSecretsV1alphaSecrets(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SecretsV1alphaSecretList> localVarResp = this.listSecretsV1alphaSecretsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1alphaSecretList> listSecretsV1alphaSecretsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSecretsV1alphaSecretsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSecretsV1alphaSecretsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SecretsV1alphaSecretList> _callback) throws ApiException {
        Call localVarCall = this.listSecretsV1alphaSecretsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSecretsV1alphaSecretsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/secrets/v1alpha/orgs/{org}/secrets".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSecretsV1alphaSecretsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSecretsV1alphaSecretsForAllEnvironments(Async)");
        }
        return this.listSecretsV1alphaSecretsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SecretsV1alphaSecretList listSecretsV1alphaSecretsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SecretsV1alphaSecretList> localVarResp = this.listSecretsV1alphaSecretsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1alphaSecretList> listSecretsV1alphaSecretsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSecretsV1alphaSecretsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSecretsV1alphaSecretsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SecretsV1alphaSecretList> _callback) throws ApiException {
        Call localVarCall = this.listSecretsV1alphaSecretsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSecretsV1alphaSecretCall(String environment, String name, String org, SecretsV1alphaSecret secretsV1alphaSecret, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SecretsV1alphaSecret localVarPostBody = secretsV1alphaSecret;
        String localVarPath = "/apis/secrets/v1alpha/orgs/{org}/environments/{environment}/secrets/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSecretsV1alphaSecretValidateBeforeCall(String environment, String name, String org, SecretsV1alphaSecret secretsV1alphaSecret, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSecretsV1alphaSecret(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSecretsV1alphaSecret(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSecretsV1alphaSecret(Async)");
        }
        if (secretsV1alphaSecret == null) {
            throw new ApiException("Missing the required parameter 'secretsV1alphaSecret' when calling patchSecretsV1alphaSecret(Async)");
        }
        return this.patchSecretsV1alphaSecretCall(environment, name, org, secretsV1alphaSecret, _callback);
    }

    public SecretsV1alphaSecret patchSecretsV1alphaSecret(String environment, String name, String org, SecretsV1alphaSecret secretsV1alphaSecret) throws ApiException {
        ApiResponse<SecretsV1alphaSecret> localVarResp = this.patchSecretsV1alphaSecretWithHttpInfo(environment, name, org, secretsV1alphaSecret);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1alphaSecret> patchSecretsV1alphaSecretWithHttpInfo(String environment, String name, String org, SecretsV1alphaSecret secretsV1alphaSecret) throws ApiException {
        Call localVarCall = this.patchSecretsV1alphaSecretValidateBeforeCall(environment, name, org, secretsV1alphaSecret, null);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecret>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSecretsV1alphaSecretAsync(String environment, String name, String org, SecretsV1alphaSecret secretsV1alphaSecret, ApiCallback<SecretsV1alphaSecret> _callback) throws ApiException {
        Call localVarCall = this.patchSecretsV1alphaSecretValidateBeforeCall(environment, name, org, secretsV1alphaSecret, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecret>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSecretsV1alphaSecretDestinationCall(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SecretsV1alphaSecretDestination localVarPostBody = secretsV1alphaSecretDestination;
        String localVarPath = "/apis/secrets/v1alpha/orgs/{org}/environments/{environment}/secretdestinations/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSecretsV1alphaSecretDestinationValidateBeforeCall(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSecretsV1alphaSecretDestination(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSecretsV1alphaSecretDestination(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSecretsV1alphaSecretDestination(Async)");
        }
        if (secretsV1alphaSecretDestination == null) {
            throw new ApiException("Missing the required parameter 'secretsV1alphaSecretDestination' when calling patchSecretsV1alphaSecretDestination(Async)");
        }
        return this.patchSecretsV1alphaSecretDestinationCall(environment, name, org, secretsV1alphaSecretDestination, _callback);
    }

    public SecretsV1alphaSecretDestination patchSecretsV1alphaSecretDestination(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination) throws ApiException {
        ApiResponse<SecretsV1alphaSecretDestination> localVarResp = this.patchSecretsV1alphaSecretDestinationWithHttpInfo(environment, name, org, secretsV1alphaSecretDestination);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1alphaSecretDestination> patchSecretsV1alphaSecretDestinationWithHttpInfo(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination) throws ApiException {
        Call localVarCall = this.patchSecretsV1alphaSecretDestinationValidateBeforeCall(environment, name, org, secretsV1alphaSecretDestination, null);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSecretsV1alphaSecretDestinationAsync(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination, ApiCallback<SecretsV1alphaSecretDestination> _callback) throws ApiException {
        Call localVarCall = this.patchSecretsV1alphaSecretDestinationValidateBeforeCall(environment, name, org, secretsV1alphaSecretDestination, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSecretsV1alphaSecretDestinationFinalizersCall(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SecretsV1alphaSecretDestination localVarPostBody = secretsV1alphaSecretDestination;
        String localVarPath = "/apis/secrets/v1alpha/orgs/{org}/environments/{environment}/secretdestinations/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSecretsV1alphaSecretDestinationFinalizersValidateBeforeCall(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSecretsV1alphaSecretDestinationFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSecretsV1alphaSecretDestinationFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSecretsV1alphaSecretDestinationFinalizers(Async)");
        }
        if (secretsV1alphaSecretDestination == null) {
            throw new ApiException("Missing the required parameter 'secretsV1alphaSecretDestination' when calling patchSecretsV1alphaSecretDestinationFinalizers(Async)");
        }
        return this.patchSecretsV1alphaSecretDestinationFinalizersCall(environment, name, org, secretsV1alphaSecretDestination, _callback);
    }

    public SecretsV1alphaSecretDestination patchSecretsV1alphaSecretDestinationFinalizers(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination) throws ApiException {
        ApiResponse<SecretsV1alphaSecretDestination> localVarResp = this.patchSecretsV1alphaSecretDestinationFinalizersWithHttpInfo(environment, name, org, secretsV1alphaSecretDestination);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1alphaSecretDestination> patchSecretsV1alphaSecretDestinationFinalizersWithHttpInfo(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination) throws ApiException {
        Call localVarCall = this.patchSecretsV1alphaSecretDestinationFinalizersValidateBeforeCall(environment, name, org, secretsV1alphaSecretDestination, null);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSecretsV1alphaSecretDestinationFinalizersAsync(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination, ApiCallback<SecretsV1alphaSecretDestination> _callback) throws ApiException {
        Call localVarCall = this.patchSecretsV1alphaSecretDestinationFinalizersValidateBeforeCall(environment, name, org, secretsV1alphaSecretDestination, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSecretsV1alphaSecretDestinationStatusCall(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SecretsV1alphaSecretDestination localVarPostBody = secretsV1alphaSecretDestination;
        String localVarPath = "/apis/secrets/v1alpha/orgs/{org}/environments/{environment}/secretdestinations/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSecretsV1alphaSecretDestinationStatusValidateBeforeCall(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSecretsV1alphaSecretDestinationStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSecretsV1alphaSecretDestinationStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSecretsV1alphaSecretDestinationStatus(Async)");
        }
        if (secretsV1alphaSecretDestination == null) {
            throw new ApiException("Missing the required parameter 'secretsV1alphaSecretDestination' when calling patchSecretsV1alphaSecretDestinationStatus(Async)");
        }
        return this.patchSecretsV1alphaSecretDestinationStatusCall(environment, name, org, secretsV1alphaSecretDestination, _callback);
    }

    public SecretsV1alphaSecretDestination patchSecretsV1alphaSecretDestinationStatus(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination) throws ApiException {
        ApiResponse<SecretsV1alphaSecretDestination> localVarResp = this.patchSecretsV1alphaSecretDestinationStatusWithHttpInfo(environment, name, org, secretsV1alphaSecretDestination);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1alphaSecretDestination> patchSecretsV1alphaSecretDestinationStatusWithHttpInfo(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination) throws ApiException {
        Call localVarCall = this.patchSecretsV1alphaSecretDestinationStatusValidateBeforeCall(environment, name, org, secretsV1alphaSecretDestination, null);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSecretsV1alphaSecretDestinationStatusAsync(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination, ApiCallback<SecretsV1alphaSecretDestination> _callback) throws ApiException {
        Call localVarCall = this.patchSecretsV1alphaSecretDestinationStatusValidateBeforeCall(environment, name, org, secretsV1alphaSecretDestination, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSecretsV1alphaSecretFinalizersCall(String environment, String name, String org, SecretsV1alphaSecret secretsV1alphaSecret, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SecretsV1alphaSecret localVarPostBody = secretsV1alphaSecret;
        String localVarPath = "/apis/secrets/v1alpha/orgs/{org}/environments/{environment}/secrets/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSecretsV1alphaSecretFinalizersValidateBeforeCall(String environment, String name, String org, SecretsV1alphaSecret secretsV1alphaSecret, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSecretsV1alphaSecretFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSecretsV1alphaSecretFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSecretsV1alphaSecretFinalizers(Async)");
        }
        if (secretsV1alphaSecret == null) {
            throw new ApiException("Missing the required parameter 'secretsV1alphaSecret' when calling patchSecretsV1alphaSecretFinalizers(Async)");
        }
        return this.patchSecretsV1alphaSecretFinalizersCall(environment, name, org, secretsV1alphaSecret, _callback);
    }

    public SecretsV1alphaSecret patchSecretsV1alphaSecretFinalizers(String environment, String name, String org, SecretsV1alphaSecret secretsV1alphaSecret) throws ApiException {
        ApiResponse<SecretsV1alphaSecret> localVarResp = this.patchSecretsV1alphaSecretFinalizersWithHttpInfo(environment, name, org, secretsV1alphaSecret);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1alphaSecret> patchSecretsV1alphaSecretFinalizersWithHttpInfo(String environment, String name, String org, SecretsV1alphaSecret secretsV1alphaSecret) throws ApiException {
        Call localVarCall = this.patchSecretsV1alphaSecretFinalizersValidateBeforeCall(environment, name, org, secretsV1alphaSecret, null);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecret>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSecretsV1alphaSecretFinalizersAsync(String environment, String name, String org, SecretsV1alphaSecret secretsV1alphaSecret, ApiCallback<SecretsV1alphaSecret> _callback) throws ApiException {
        Call localVarCall = this.patchSecretsV1alphaSecretFinalizersValidateBeforeCall(environment, name, org, secretsV1alphaSecret, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecret>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSecretsV1alphaSecretCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/secrets/v1alpha/orgs/{org}/environments/{environment}/secrets/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSecretsV1alphaSecretValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSecretsV1alphaSecret(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSecretsV1alphaSecret(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSecretsV1alphaSecret(Async)");
        }
        return this.readSecretsV1alphaSecretCall(environment, name, org, resourceVersion, _callback);
    }

    public SecretsV1alphaSecret readSecretsV1alphaSecret(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SecretsV1alphaSecret> localVarResp = this.readSecretsV1alphaSecretWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1alphaSecret> readSecretsV1alphaSecretWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSecretsV1alphaSecretValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecret>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSecretsV1alphaSecretAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SecretsV1alphaSecret> _callback) throws ApiException {
        Call localVarCall = this.readSecretsV1alphaSecretValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecret>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSecretsV1alphaSecretDestinationCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/secrets/v1alpha/orgs/{org}/environments/{environment}/secretdestinations/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSecretsV1alphaSecretDestinationValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSecretsV1alphaSecretDestination(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSecretsV1alphaSecretDestination(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSecretsV1alphaSecretDestination(Async)");
        }
        return this.readSecretsV1alphaSecretDestinationCall(environment, name, org, resourceVersion, _callback);
    }

    public SecretsV1alphaSecretDestination readSecretsV1alphaSecretDestination(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SecretsV1alphaSecretDestination> localVarResp = this.readSecretsV1alphaSecretDestinationWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1alphaSecretDestination> readSecretsV1alphaSecretDestinationWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSecretsV1alphaSecretDestinationValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSecretsV1alphaSecretDestinationAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SecretsV1alphaSecretDestination> _callback) throws ApiException {
        Call localVarCall = this.readSecretsV1alphaSecretDestinationValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSecretsV1alphaSecretDestinationFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/secrets/v1alpha/orgs/{org}/environments/{environment}/secretdestinations/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSecretsV1alphaSecretDestinationFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSecretsV1alphaSecretDestinationFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSecretsV1alphaSecretDestinationFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSecretsV1alphaSecretDestinationFinalizers(Async)");
        }
        return this.readSecretsV1alphaSecretDestinationFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public SecretsV1alphaSecretDestination readSecretsV1alphaSecretDestinationFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SecretsV1alphaSecretDestination> localVarResp = this.readSecretsV1alphaSecretDestinationFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1alphaSecretDestination> readSecretsV1alphaSecretDestinationFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSecretsV1alphaSecretDestinationFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSecretsV1alphaSecretDestinationFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SecretsV1alphaSecretDestination> _callback) throws ApiException {
        Call localVarCall = this.readSecretsV1alphaSecretDestinationFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSecretsV1alphaSecretDestinationStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/secrets/v1alpha/orgs/{org}/environments/{environment}/secretdestinations/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSecretsV1alphaSecretDestinationStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSecretsV1alphaSecretDestinationStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSecretsV1alphaSecretDestinationStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSecretsV1alphaSecretDestinationStatus(Async)");
        }
        return this.readSecretsV1alphaSecretDestinationStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public SecretsV1alphaSecretDestination readSecretsV1alphaSecretDestinationStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SecretsV1alphaSecretDestination> localVarResp = this.readSecretsV1alphaSecretDestinationStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1alphaSecretDestination> readSecretsV1alphaSecretDestinationStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSecretsV1alphaSecretDestinationStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSecretsV1alphaSecretDestinationStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SecretsV1alphaSecretDestination> _callback) throws ApiException {
        Call localVarCall = this.readSecretsV1alphaSecretDestinationStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSecretsV1alphaSecretFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/secrets/v1alpha/orgs/{org}/environments/{environment}/secrets/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSecretsV1alphaSecretFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSecretsV1alphaSecretFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSecretsV1alphaSecretFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSecretsV1alphaSecretFinalizers(Async)");
        }
        return this.readSecretsV1alphaSecretFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public SecretsV1alphaSecret readSecretsV1alphaSecretFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SecretsV1alphaSecret> localVarResp = this.readSecretsV1alphaSecretFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1alphaSecret> readSecretsV1alphaSecretFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSecretsV1alphaSecretFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecret>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSecretsV1alphaSecretFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SecretsV1alphaSecret> _callback) throws ApiException {
        Call localVarCall = this.readSecretsV1alphaSecretFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecret>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSecretsV1alphaSecretCall(String environment, String name, String org, SecretsV1alphaSecret secretsV1alphaSecret, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SecretsV1alphaSecret localVarPostBody = secretsV1alphaSecret;
        String localVarPath = "/apis/secrets/v1alpha/orgs/{org}/environments/{environment}/secrets/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSecretsV1alphaSecretValidateBeforeCall(String environment, String name, String org, SecretsV1alphaSecret secretsV1alphaSecret, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSecretsV1alphaSecret(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSecretsV1alphaSecret(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSecretsV1alphaSecret(Async)");
        }
        if (secretsV1alphaSecret == null) {
            throw new ApiException("Missing the required parameter 'secretsV1alphaSecret' when calling updateSecretsV1alphaSecret(Async)");
        }
        return this.updateSecretsV1alphaSecretCall(environment, name, org, secretsV1alphaSecret, _callback);
    }

    public SecretsV1alphaSecret updateSecretsV1alphaSecret(String environment, String name, String org, SecretsV1alphaSecret secretsV1alphaSecret) throws ApiException {
        ApiResponse<SecretsV1alphaSecret> localVarResp = this.updateSecretsV1alphaSecretWithHttpInfo(environment, name, org, secretsV1alphaSecret);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1alphaSecret> updateSecretsV1alphaSecretWithHttpInfo(String environment, String name, String org, SecretsV1alphaSecret secretsV1alphaSecret) throws ApiException {
        Call localVarCall = this.updateSecretsV1alphaSecretValidateBeforeCall(environment, name, org, secretsV1alphaSecret, null);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecret>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSecretsV1alphaSecretAsync(String environment, String name, String org, SecretsV1alphaSecret secretsV1alphaSecret, ApiCallback<SecretsV1alphaSecret> _callback) throws ApiException {
        Call localVarCall = this.updateSecretsV1alphaSecretValidateBeforeCall(environment, name, org, secretsV1alphaSecret, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecret>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSecretsV1alphaSecretDestinationCall(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SecretsV1alphaSecretDestination localVarPostBody = secretsV1alphaSecretDestination;
        String localVarPath = "/apis/secrets/v1alpha/orgs/{org}/environments/{environment}/secretdestinations/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSecretsV1alphaSecretDestinationValidateBeforeCall(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSecretsV1alphaSecretDestination(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSecretsV1alphaSecretDestination(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSecretsV1alphaSecretDestination(Async)");
        }
        if (secretsV1alphaSecretDestination == null) {
            throw new ApiException("Missing the required parameter 'secretsV1alphaSecretDestination' when calling updateSecretsV1alphaSecretDestination(Async)");
        }
        return this.updateSecretsV1alphaSecretDestinationCall(environment, name, org, secretsV1alphaSecretDestination, _callback);
    }

    public SecretsV1alphaSecretDestination updateSecretsV1alphaSecretDestination(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination) throws ApiException {
        ApiResponse<SecretsV1alphaSecretDestination> localVarResp = this.updateSecretsV1alphaSecretDestinationWithHttpInfo(environment, name, org, secretsV1alphaSecretDestination);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1alphaSecretDestination> updateSecretsV1alphaSecretDestinationWithHttpInfo(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination) throws ApiException {
        Call localVarCall = this.updateSecretsV1alphaSecretDestinationValidateBeforeCall(environment, name, org, secretsV1alphaSecretDestination, null);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSecretsV1alphaSecretDestinationAsync(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination, ApiCallback<SecretsV1alphaSecretDestination> _callback) throws ApiException {
        Call localVarCall = this.updateSecretsV1alphaSecretDestinationValidateBeforeCall(environment, name, org, secretsV1alphaSecretDestination, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSecretsV1alphaSecretDestinationFinalizersCall(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SecretsV1alphaSecretDestination localVarPostBody = secretsV1alphaSecretDestination;
        String localVarPath = "/apis/secrets/v1alpha/orgs/{org}/environments/{environment}/secretdestinations/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSecretsV1alphaSecretDestinationFinalizersValidateBeforeCall(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSecretsV1alphaSecretDestinationFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSecretsV1alphaSecretDestinationFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSecretsV1alphaSecretDestinationFinalizers(Async)");
        }
        if (secretsV1alphaSecretDestination == null) {
            throw new ApiException("Missing the required parameter 'secretsV1alphaSecretDestination' when calling updateSecretsV1alphaSecretDestinationFinalizers(Async)");
        }
        return this.updateSecretsV1alphaSecretDestinationFinalizersCall(environment, name, org, secretsV1alphaSecretDestination, _callback);
    }

    public SecretsV1alphaSecretDestination updateSecretsV1alphaSecretDestinationFinalizers(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination) throws ApiException {
        ApiResponse<SecretsV1alphaSecretDestination> localVarResp = this.updateSecretsV1alphaSecretDestinationFinalizersWithHttpInfo(environment, name, org, secretsV1alphaSecretDestination);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1alphaSecretDestination> updateSecretsV1alphaSecretDestinationFinalizersWithHttpInfo(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination) throws ApiException {
        Call localVarCall = this.updateSecretsV1alphaSecretDestinationFinalizersValidateBeforeCall(environment, name, org, secretsV1alphaSecretDestination, null);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSecretsV1alphaSecretDestinationFinalizersAsync(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination, ApiCallback<SecretsV1alphaSecretDestination> _callback) throws ApiException {
        Call localVarCall = this.updateSecretsV1alphaSecretDestinationFinalizersValidateBeforeCall(environment, name, org, secretsV1alphaSecretDestination, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSecretsV1alphaSecretDestinationStatusCall(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SecretsV1alphaSecretDestination localVarPostBody = secretsV1alphaSecretDestination;
        String localVarPath = "/apis/secrets/v1alpha/orgs/{org}/environments/{environment}/secretdestinations/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSecretsV1alphaSecretDestinationStatusValidateBeforeCall(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSecretsV1alphaSecretDestinationStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSecretsV1alphaSecretDestinationStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSecretsV1alphaSecretDestinationStatus(Async)");
        }
        if (secretsV1alphaSecretDestination == null) {
            throw new ApiException("Missing the required parameter 'secretsV1alphaSecretDestination' when calling updateSecretsV1alphaSecretDestinationStatus(Async)");
        }
        return this.updateSecretsV1alphaSecretDestinationStatusCall(environment, name, org, secretsV1alphaSecretDestination, _callback);
    }

    public SecretsV1alphaSecretDestination updateSecretsV1alphaSecretDestinationStatus(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination) throws ApiException {
        ApiResponse<SecretsV1alphaSecretDestination> localVarResp = this.updateSecretsV1alphaSecretDestinationStatusWithHttpInfo(environment, name, org, secretsV1alphaSecretDestination);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1alphaSecretDestination> updateSecretsV1alphaSecretDestinationStatusWithHttpInfo(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination) throws ApiException {
        Call localVarCall = this.updateSecretsV1alphaSecretDestinationStatusValidateBeforeCall(environment, name, org, secretsV1alphaSecretDestination, null);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSecretsV1alphaSecretDestinationStatusAsync(String environment, String name, String org, SecretsV1alphaSecretDestination secretsV1alphaSecretDestination, ApiCallback<SecretsV1alphaSecretDestination> _callback) throws ApiException {
        Call localVarCall = this.updateSecretsV1alphaSecretDestinationStatusValidateBeforeCall(environment, name, org, secretsV1alphaSecretDestination, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecretDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSecretsV1alphaSecretFinalizersCall(String environment, String name, String org, SecretsV1alphaSecret secretsV1alphaSecret, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SecretsV1alphaSecret localVarPostBody = secretsV1alphaSecret;
        String localVarPath = "/apis/secrets/v1alpha/orgs/{org}/environments/{environment}/secrets/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSecretsV1alphaSecretFinalizersValidateBeforeCall(String environment, String name, String org, SecretsV1alphaSecret secretsV1alphaSecret, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSecretsV1alphaSecretFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSecretsV1alphaSecretFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSecretsV1alphaSecretFinalizers(Async)");
        }
        if (secretsV1alphaSecret == null) {
            throw new ApiException("Missing the required parameter 'secretsV1alphaSecret' when calling updateSecretsV1alphaSecretFinalizers(Async)");
        }
        return this.updateSecretsV1alphaSecretFinalizersCall(environment, name, org, secretsV1alphaSecret, _callback);
    }

    public SecretsV1alphaSecret updateSecretsV1alphaSecretFinalizers(String environment, String name, String org, SecretsV1alphaSecret secretsV1alphaSecret) throws ApiException {
        ApiResponse<SecretsV1alphaSecret> localVarResp = this.updateSecretsV1alphaSecretFinalizersWithHttpInfo(environment, name, org, secretsV1alphaSecret);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1alphaSecret> updateSecretsV1alphaSecretFinalizersWithHttpInfo(String environment, String name, String org, SecretsV1alphaSecret secretsV1alphaSecret) throws ApiException {
        Call localVarCall = this.updateSecretsV1alphaSecretFinalizersValidateBeforeCall(environment, name, org, secretsV1alphaSecret, null);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecret>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSecretsV1alphaSecretFinalizersAsync(String environment, String name, String org, SecretsV1alphaSecret secretsV1alphaSecret, ApiCallback<SecretsV1alphaSecret> _callback) throws ApiException {
        Call localVarCall = this.updateSecretsV1alphaSecretFinalizersValidateBeforeCall(environment, name, org, secretsV1alphaSecret, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1alphaSecret>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

