/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.flink.apiserver.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.confluent.flink.apiserver.client.JSON;
import io.confluent.flink.apiserver.client.model.SqlV1Column;
import io.confluent.flink.apiserver.client.model.SqlV1PrimaryKey;
import io.confluent.flink.apiserver.client.model.SqlV1TableDistribution;
import io.confluent.flink.apiserver.client.model.SqlV1TopicMetadata;
import io.confluent.flink.apiserver.client.model.SqlV1Watermark;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SqlV1TableSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_COLUMNS = "columns";
    @SerializedName(value="columns")
    private List<SqlV1Column> columns = new ArrayList<SqlV1Column>();
    public static final String SERIALIZED_NAME_COMMENT = "comment";
    @SerializedName(value="comment")
    private String comment;
    public static final String SERIALIZED_NAME_DISTRIBUTION = "distribution";
    @SerializedName(value="distribution")
    private SqlV1TableDistribution distribution;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private KindEnum kind;
    public static final String SERIALIZED_NAME_OPTIONS = "options";
    @SerializedName(value="options")
    private Map<String, String> options = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_PARTITION_KEY = "partitionKey";
    @SerializedName(value="partitionKey")
    private List<String> partitionKey = new ArrayList<String>();
    public static final String SERIALIZED_NAME_PRIMARY_KEY = "primaryKey";
    @SerializedName(value="primaryKey")
    private SqlV1PrimaryKey primaryKey;
    public static final String SERIALIZED_NAME_TOPIC_METADATA = "topicMetadata";
    @SerializedName(value="topicMetadata")
    private SqlV1TopicMetadata topicMetadata;
    public static final String SERIALIZED_NAME_TOPIC_SYNCED = "topicSynced";
    @SerializedName(value="topicSynced")
    private Boolean topicSynced = false;
    public static final String SERIALIZED_NAME_VIEW_EXPANDED_QUERY = "viewExpandedQuery";
    @SerializedName(value="viewExpandedQuery")
    private String viewExpandedQuery;
    public static final String SERIALIZED_NAME_VIEW_QUERY = "viewQuery";
    @SerializedName(value="viewQuery")
    private String viewQuery;
    public static final String SERIALIZED_NAME_WATERMARKS = "watermarks";
    @SerializedName(value="watermarks")
    private List<SqlV1Watermark> watermarks = new ArrayList<SqlV1Watermark>();
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public SqlV1TableSpec columns(List<SqlV1Column> columns) {
        this.columns = columns;
        return this;
    }

    public SqlV1TableSpec addColumnsItem(SqlV1Column columnsItem) {
        if (this.columns == null) {
            this.columns = new ArrayList<SqlV1Column>();
        }
        this.columns.add(columnsItem);
        return this;
    }

    @Nullable
    public List<SqlV1Column> getColumns() {
        return this.columns;
    }

    public void setColumns(List<SqlV1Column> columns) {
        this.columns = columns;
    }

    public SqlV1TableSpec comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public SqlV1TableSpec distribution(SqlV1TableDistribution distribution) {
        this.distribution = distribution;
        return this;
    }

    @Nullable
    public SqlV1TableDistribution getDistribution() {
        return this.distribution;
    }

    public void setDistribution(SqlV1TableDistribution distribution) {
        this.distribution = distribution;
    }

    public SqlV1TableSpec kind(KindEnum kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    public KindEnum getKind() {
        return this.kind;
    }

    public void setKind(KindEnum kind) {
        this.kind = kind;
    }

    public SqlV1TableSpec options(Map<String, String> options) {
        this.options = options;
        return this;
    }

    public SqlV1TableSpec putOptionsItem(String key, String optionsItem) {
        if (this.options == null) {
            this.options = new HashMap<String, String>();
        }
        this.options.put(key, optionsItem);
        return this;
    }

    @Nullable
    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public SqlV1TableSpec partitionKey(List<String> partitionKey) {
        this.partitionKey = partitionKey;
        return this;
    }

    public SqlV1TableSpec addPartitionKeyItem(String partitionKeyItem) {
        if (this.partitionKey == null) {
            this.partitionKey = new ArrayList<String>();
        }
        this.partitionKey.add(partitionKeyItem);
        return this;
    }

    @Nullable
    public List<String> getPartitionKey() {
        return this.partitionKey;
    }

    public void setPartitionKey(List<String> partitionKey) {
        this.partitionKey = partitionKey;
    }

    public SqlV1TableSpec primaryKey(SqlV1PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
        return this;
    }

    @Nullable
    public SqlV1PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(SqlV1PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public SqlV1TableSpec topicMetadata(SqlV1TopicMetadata topicMetadata) {
        this.topicMetadata = topicMetadata;
        return this;
    }

    @Nullable
    public SqlV1TopicMetadata getTopicMetadata() {
        return this.topicMetadata;
    }

    public void setTopicMetadata(SqlV1TopicMetadata topicMetadata) {
        this.topicMetadata = topicMetadata;
    }

    public SqlV1TableSpec topicSynced(Boolean topicSynced) {
        this.topicSynced = topicSynced;
        return this;
    }

    @Nullable
    public Boolean getTopicSynced() {
        return this.topicSynced;
    }

    public void setTopicSynced(Boolean topicSynced) {
        this.topicSynced = topicSynced;
    }

    public SqlV1TableSpec viewExpandedQuery(String viewExpandedQuery) {
        this.viewExpandedQuery = viewExpandedQuery;
        return this;
    }

    @Nullable
    public String getViewExpandedQuery() {
        return this.viewExpandedQuery;
    }

    public void setViewExpandedQuery(String viewExpandedQuery) {
        this.viewExpandedQuery = viewExpandedQuery;
    }

    public SqlV1TableSpec viewQuery(String viewQuery) {
        this.viewQuery = viewQuery;
        return this;
    }

    @Nullable
    public String getViewQuery() {
        return this.viewQuery;
    }

    public void setViewQuery(String viewQuery) {
        this.viewQuery = viewQuery;
    }

    public SqlV1TableSpec watermarks(List<SqlV1Watermark> watermarks) {
        this.watermarks = watermarks;
        return this;
    }

    public SqlV1TableSpec addWatermarksItem(SqlV1Watermark watermarksItem) {
        if (this.watermarks == null) {
            this.watermarks = new ArrayList<SqlV1Watermark>();
        }
        this.watermarks.add(watermarksItem);
        return this;
    }

    @Nullable
    public List<SqlV1Watermark> getWatermarks() {
        return this.watermarks;
    }

    public void setWatermarks(List<SqlV1Watermark> watermarks) {
        this.watermarks = watermarks;
    }

    public SqlV1TableSpec putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlV1TableSpec sqlV1TableSpec = (SqlV1TableSpec)o;
        return Objects.equals(this.columns, sqlV1TableSpec.columns) && Objects.equals(this.comment, sqlV1TableSpec.comment) && Objects.equals(this.distribution, sqlV1TableSpec.distribution) && Objects.equals((Object)this.kind, (Object)sqlV1TableSpec.kind) && Objects.equals(this.options, sqlV1TableSpec.options) && Objects.equals(this.partitionKey, sqlV1TableSpec.partitionKey) && Objects.equals(this.primaryKey, sqlV1TableSpec.primaryKey) && Objects.equals(this.topicMetadata, sqlV1TableSpec.topicMetadata) && Objects.equals(this.topicSynced, sqlV1TableSpec.topicSynced) && Objects.equals(this.viewExpandedQuery, sqlV1TableSpec.viewExpandedQuery) && Objects.equals(this.viewQuery, sqlV1TableSpec.viewQuery) && Objects.equals(this.watermarks, sqlV1TableSpec.watermarks) && Objects.equals(this.additionalProperties, sqlV1TableSpec.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.columns, this.comment, this.distribution, this.kind, this.options, this.partitionKey, this.primaryKey, this.topicMetadata, this.topicSynced, this.viewExpandedQuery, this.viewQuery, this.watermarks, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SqlV1TableSpec {\n");
        sb.append("    columns: ").append(this.toIndentedString(this.columns)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    distribution: ").append(this.toIndentedString(this.distribution)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString((Object)this.kind)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    partitionKey: ").append(this.toIndentedString(this.partitionKey)).append("\n");
        sb.append("    primaryKey: ").append(this.toIndentedString(this.primaryKey)).append("\n");
        sb.append("    topicMetadata: ").append(this.toIndentedString(this.topicMetadata)).append("\n");
        sb.append("    topicSynced: ").append(this.toIndentedString(this.topicSynced)).append("\n");
        sb.append("    viewExpandedQuery: ").append(this.toIndentedString(this.viewExpandedQuery)).append("\n");
        sb.append("    viewQuery: ").append(this.toIndentedString(this.viewQuery)).append("\n");
        sb.append("    watermarks: ").append(this.toIndentedString(this.watermarks)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in SqlV1TableSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_COLUMNS) != null && !jsonObj.get(SERIALIZED_NAME_COLUMNS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_COLUMNS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `columns` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COLUMNS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMMENT) != null && !jsonObj.get(SERIALIZED_NAME_COMMENT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_COMMENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `comment` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMMENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonNull()) {
            KindEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_KIND));
        }
        if (jsonObj.get(SERIALIZED_NAME_PARTITION_KEY) != null && !jsonObj.get(SERIALIZED_NAME_PARTITION_KEY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PARTITION_KEY).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `partitionKey` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PARTITION_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VIEW_EXPANDED_QUERY) != null && !jsonObj.get(SERIALIZED_NAME_VIEW_EXPANDED_QUERY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VIEW_EXPANDED_QUERY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `viewExpandedQuery` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VIEW_EXPANDED_QUERY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VIEW_QUERY) != null && !jsonObj.get(SERIALIZED_NAME_VIEW_QUERY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VIEW_QUERY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `viewQuery` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VIEW_QUERY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_WATERMARKS) != null && !jsonObj.get(SERIALIZED_NAME_WATERMARKS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_WATERMARKS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `watermarks` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WATERMARKS).toString()));
        }
    }

    public static SqlV1TableSpec fromJson(String jsonString) throws IOException {
        return (SqlV1TableSpec)JSON.getGson().fromJson(jsonString, SqlV1TableSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_COLUMNS);
        openapiFields.add(SERIALIZED_NAME_COMMENT);
        openapiFields.add(SERIALIZED_NAME_DISTRIBUTION);
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_PARTITION_KEY);
        openapiFields.add(SERIALIZED_NAME_PRIMARY_KEY);
        openapiFields.add(SERIALIZED_NAME_TOPIC_METADATA);
        openapiFields.add(SERIALIZED_NAME_TOPIC_SYNCED);
        openapiFields.add(SERIALIZED_NAME_VIEW_EXPANDED_QUERY);
        openapiFields.add(SERIALIZED_NAME_VIEW_QUERY);
        openapiFields.add(SERIALIZED_NAME_WATERMARKS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!SqlV1TableSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SqlV1TableSpec.class));
            return new TypeAdapter<SqlV1TableSpec>(){

                public void write(JsonWriter out, SqlV1TableSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public SqlV1TableSpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    SqlV1TableSpec.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    SqlV1TableSpec instance = (SqlV1TableSpec)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum KindEnum {
        EXTERNAL("External"),
        NATIVE("Native"),
        VIEW("View");

        private String value;

        private KindEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static KindEnum fromValue(String value) {
            for (KindEnum b : KindEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            KindEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<KindEnum> {
            public void write(JsonWriter jsonWriter, KindEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public KindEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return KindEnum.fromValue(value);
            }
        }
    }
}

