/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.common;

public abstract class WindowIndexedArrays {
    public static final int INVALID_INDEX = -1;
    protected volatile long startWindowIndex;

    public void updateStartWindowIndex(long newStartWindowIndex) {
        this.startWindowIndex = newStartWindowIndex;
    }

    protected abstract int length();

    protected void validateWindowIndex(long windowIndex) {
        if (!this.inValidWindowRange(windowIndex)) {
            throw new IllegalArgumentException(String.format("Index %d is out of range [%d, %d]", windowIndex, this.startWindowIndex, this.lastWindowIndex()));
        }
    }

    protected int prevArrayIndex(int arrayIndex) {
        return arrayIndex == this.firstArrayIndex() ? -1 : (arrayIndex + this.length() - 1) % this.length();
    }

    protected int nextArrayIndex(int arrayIndex) {
        return arrayIndex == this.lastArrayIndex() ? -1 : (arrayIndex + 1) % this.length();
    }

    protected int firstArrayIndex() {
        return this.arrayIndex(this.startWindowIndex);
    }

    protected int lastArrayIndex() {
        return this.arrayIndex(this.lastWindowIndex());
    }

    protected long lastWindowIndex() {
        return this.currentWindowIndex() - 1L;
    }

    protected boolean inValidWindowRange(long windowIndex) {
        return windowIndex >= this.startWindowIndex && windowIndex <= this.lastWindowIndex();
    }

    protected long currentWindowIndex() {
        return this.startWindowIndex + (long)this.length() - 1L;
    }

    protected int arrayIndex(long windowIndex) {
        return (int)(windowIndex % (long)this.length());
    }
}

