/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.metricdef;

import com.linkedin.cruisecontrol.metricdef.MetricInfo;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.monitor.metricdefinition.KafkaMetricDef;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class MetricDef {
    private final AtomicInteger nextIndex = new AtomicInteger(0);
    private final Map<KafkaMetricDef, MetricInfo> metricInfoByDef = new HashMap<KafkaMetricDef, MetricInfo>();
    private final List<MetricInfo> metricInfoByIndex = new ArrayList<MetricInfo>();
    private final Map<Resource, List<MetricInfo>> metricInfoByResource = new HashMap<Resource, List<MetricInfo>>();

    public synchronized MetricDef define(KafkaMetricDef kafkaMetricDef) {
        this.metricInfoByDef.compute(kafkaMetricDef, (k, v) -> {
            if (v != null) {
                throw new IllegalArgumentException("Metric " + String.valueOf((Object)kafkaMetricDef) + " is already defined");
            }
            short metricId = this.getAndIncrementMetricId();
            return new MetricInfo(kafkaMetricDef, metricId);
        });
        MetricInfo info = this.metricInfoByDef.get((Object)kafkaMetricDef);
        this.metricInfoByIndex.add(info.id(), info);
        if (kafkaMetricDef.resource() != null) {
            this.metricInfoByResource.computeIfAbsent(kafkaMetricDef.resource(), g -> new ArrayList()).add(info);
        }
        return this;
    }

    private short getAndIncrementMetricId() {
        int metricId = this.nextIndex.getAndIncrement();
        if (metricId > Short.MAX_VALUE) {
            throw new IllegalStateException(String.format("Metric Ids beyond %d are not supported.", (short)Short.MAX_VALUE));
        }
        return (short)metricId;
    }

    public List<MetricInfo> metricInfoForResource(Resource resource) {
        return this.metricInfoByResource.getOrDefault((Object)resource, Collections.emptyList());
    }

    public MetricInfo metricInfo(KafkaMetricDef metricDef) {
        MetricInfo info = this.metricInfoByDef.get((Object)metricDef);
        if (info == null) {
            throw new IllegalArgumentException("Metric " + String.valueOf((Object)metricDef) + " is not defined. Currently defined metrics are " + String.valueOf(this.metricInfoByDef));
        }
        return info;
    }

    public MetricInfo metricInfo(short id) {
        if (id >= this.nextIndex.get()) {
            throw new IllegalArgumentException("Metric Id " + id + " is not defined. Currently defined metrics are " + String.valueOf(this.metricInfoByIndex));
        }
        return this.metricInfoByIndex.get(id);
    }

    public List<MetricInfo> all() {
        return Collections.unmodifiableList(this.metricInfoByIndex);
    }

    public int size() {
        return this.metricInfoByDef.size();
    }
}

