/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.monitor.sampling.aggregator;

import com.linkedin.cruisecontrol.metricdef.MetricDef;
import com.linkedin.cruisecontrol.metricdef.MetricInfo;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricValues;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.monitor.metricdefinition.KafkaMetricDef;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public class AggregatedMetricValues {
    private static final short ALL_METRICS_SIZE = (short)KafkaMetricDef.commonMetricDef().all().size();
    private final MetricValues[] metricValues;

    public AggregatedMetricValues() {
        this.metricValues = new MetricValues[ALL_METRICS_SIZE];
    }

    public AggregatedMetricValues(Map<Short, MetricValues> valuesByMetricId) {
        if (valuesByMetricId == null) {
            throw new IllegalArgumentException("The metric values cannot be null");
        }
        int length = valuesByMetricId.isEmpty() ? -1 : valuesByMetricId.values().iterator().next().length();
        for (MetricValues values2 : valuesByMetricId.values()) {
            if (length == values2.length()) continue;
            throw new IllegalArgumentException("The metric values must have the same length for each metric. Saw two different lengths of " + length + " and " + values2.length());
        }
        this.metricValues = new MetricValues[ALL_METRICS_SIZE];
        valuesByMetricId.forEach((id, values) -> {
            this.metricValues[id.shortValue()] = values;
        });
    }

    public AggregatedMetricValues(MetricValues[] values) {
        if (values == null) {
            throw new IllegalArgumentException("The metric values cannot be null");
        }
        if (values.length != ALL_METRICS_SIZE) {
            throw new IllegalArgumentException("The metric values must be available for all metrics. Expected length of " + ALL_METRICS_SIZE + " and found " + values.length);
        }
        Set uniqueLengths = Arrays.stream(values).filter(Objects::nonNull).map(MetricValues::length).collect(Collectors.toSet());
        if (uniqueLengths.size() > 1) {
            throw new IllegalArgumentException("The metric values must have the same length for each metric. Saw multiple different lengths " + String.valueOf(uniqueLengths));
        }
        this.metricValues = values;
    }

    public AggregatedMetricValues(AggregatedMetricValues other) {
        this();
        for (int i = 0; i < other.metricValues.length; ++i) {
            MetricValues omv = other.metricValues[i];
            if (omv == null) continue;
            this.metricValues[i] = new MetricValues(omv);
        }
    }

    public MetricValues valuesFor(short metricId) {
        return this.metricValues[metricId];
    }

    public AggregatedMetricValues valuesFor(Collection<Short> metricIds, boolean shareValueArray) {
        AggregatedMetricValues values = new AggregatedMetricValues();
        metricIds.forEach(id -> {
            MetricValues valuesForId = this.metricValues[id];
            if (valuesForId == null) {
                throw new IllegalArgumentException("Metric id " + id + " does not exist.");
            }
            if (shareValueArray) {
                values.metricValues()[id.shortValue()] = valuesForId;
            } else {
                values.add((short)id, valuesForId);
            }
        });
        return values;
    }

    public MetricValues valuesForResource(Resource resource, MetricDef metricDef, boolean shareValueArray) {
        List<MetricInfo> metricInfos = metricDef.metricInfoForResource(resource);
        if (metricInfos.size() == 1 && shareValueArray) {
            return this.metricValues[((MetricInfo)metricInfos.iterator().next()).id()];
        }
        MetricValues metricValues = new MetricValues(this.length());
        metricInfos.forEach(info -> {
            MetricValues valuesForId = this.metricValues[info.id()];
            if (valuesForId == null) {
                throw new IllegalArgumentException("Metric " + String.valueOf(info) + " does not exist.");
            }
            metricValues.add(valuesForId);
        });
        return metricValues;
    }

    public int length() {
        for (MetricValues m : this.metricValues) {
            if (m == null) continue;
            return m.length();
        }
        return 0;
    }

    public boolean isEmpty() {
        return Arrays.stream(this.metricValues).allMatch(Objects::isNull);
    }

    public Set<Short> metricIds() {
        HashSet<Short> metricIds = new HashSet<Short>();
        for (int i = 0; i < this.metricValues.length; ++i) {
            if (this.metricValues[i] == null) continue;
            metricIds.add((short)i);
        }
        return Collections.unmodifiableSet(metricIds);
    }

    public void add(short metricId, MetricValues metricValuesToAdd) {
        if (metricValuesToAdd == null) {
            throw new IllegalArgumentException("The metric values to be added cannot be null");
        }
        if (!this.isEmpty() && metricValuesToAdd.length() != this.length()) {
            throw new IllegalArgumentException("The existing metric length is " + this.length() + " which is different from the metric length of " + metricValuesToAdd.length() + " that is being added.");
        }
        if (this.metricValues[metricId] == null) {
            this.metricValues[metricId] = new MetricValues(metricValuesToAdd.length());
        }
        MetricValues metricValues = this.metricValues[metricId];
        metricValues.add(metricValuesToAdd);
    }

    public void add(AggregatedMetricValues other) {
        for (int i = 0; i < other.metricValues.length; ++i) {
            MetricValues valuesForMetric;
            short metricId = (short)i;
            MetricValues otherValuesForMetric = other.metricValues[metricId];
            if (otherValuesForMetric == null) continue;
            if (this.metricValues[metricId] == null) {
                this.metricValues[metricId] = new MetricValues(otherValuesForMetric.length());
            }
            if ((valuesForMetric = this.metricValues[metricId]).length() != otherValuesForMetric.length()) {
                throw new IllegalStateException("The two values arrays have different lengths " + valuesForMetric.length() + " and " + otherValuesForMetric.length());
            }
            valuesForMetric.add(otherValuesForMetric);
        }
    }

    public void subtract(AggregatedMetricValues other) {
        for (int i = 0; i < other.metricValues.length; ++i) {
            short metricId = (short)i;
            MetricValues otherValuesForMetric = other.metricValues[metricId];
            if (otherValuesForMetric == null) continue;
            MetricValues valuesForMetric = this.valuesFor(metricId);
            if (valuesForMetric == null) {
                throw new IllegalStateException("Cannot subtract a values from a non-existing MetricValues");
            }
            if (valuesForMetric.length() != otherValuesForMetric.length()) {
                throw new IllegalStateException("The two values arrays have different lengths " + valuesForMetric.length() + " and " + otherValuesForMetric.length());
            }
            valuesForMetric.subtract(otherValuesForMetric);
        }
    }

    public void multiplyLoadFor(Resource resource, double multiplyBy) {
        KafkaMetricDef.resourceToMetricIds(resource).forEach(metricId -> this.metricValues[metricId].multiply(multiplyBy));
    }

    public void clear() {
        Arrays.fill(this.metricValues, null);
    }

    public void writeTo(OutputStream out) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        osw.write("{%n");
        for (int i = 0; i < this.metricValues.length; ++i) {
            if (this.metricValues[i] == null) continue;
            osw.write(String.format("metricId:\"%d\", values:\"", i));
            this.metricValues[i].writeTo(out);
            osw.write("}\"");
        }
    }

    private MetricValues[] metricValues() {
        return this.metricValues;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner("\n", "{", "}");
        for (int i = 0; i < this.metricValues.length; ++i) {
            if (this.metricValues[i] == null) continue;
            joiner.add(String.format("metricId:\"%d\", values:\"%s\"", i, this.metricValues[i]));
        }
        return joiner.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregatedMetricValues that = (AggregatedMetricValues)o;
        return Arrays.equals(this.metricValues, that.metricValues);
    }

    public int hashCode() {
        return this.metricValues != null ? Arrays.hashCode(this.metricValues) : 0;
    }
}

