/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.monitor.sampling.aggregator;

import com.linkedin.cruisecontrol.common.LongGenerationed;
import com.linkedin.cruisecontrol.model.Entity;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricSampleCompleteness;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.ValuesAndExtrapolations;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MetricSampleAggregationResult<E extends Entity>
extends LongGenerationed {
    private final Map<E, ValuesAndExtrapolations> entityValuesAndExtrapolations = new HashMap<E, ValuesAndExtrapolations>();
    private final Set<E> invalidEntities = new HashSet();
    private final MetricSampleCompleteness<E> completeness;

    public MetricSampleAggregationResult(long generation, MetricSampleCompleteness<E> completeness) {
        super(generation);
        this.completeness = completeness;
    }

    public Map<E, ValuesAndExtrapolations> valuesAndExtrapolations() {
        return this.entityValuesAndExtrapolations;
    }

    public Set<E> invalidEntities() {
        return this.invalidEntities;
    }

    public MetricSampleCompleteness<E> completeness() {
        return this.completeness;
    }

    void addResult(E entity, ValuesAndExtrapolations valuesAndExtrapolations) {
        this.entityValuesAndExtrapolations.put(entity, valuesAndExtrapolations);
    }

    void recordInvalidEntity(E entity) {
        this.invalidEntities.add(entity);
    }
}

