/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.monitor.sampling.aggregator;

import com.linkedin.cruisecontrol.common.LongGenerationed;
import com.linkedin.cruisecontrol.model.Entity;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class MetricSampleCompleteness<E extends Entity>
extends LongGenerationed {
    private final SortedMap<Long, Float> validEntityRatioByWindowIndex = new TreeMap(Collections.reverseOrder());
    private final SortedMap<Long, Float> validEntityRatioWithGroupGranularityByWindowIndex = new TreeMap(Collections.reverseOrder());
    private final SortedMap<Long, Float> validEntityGroupRatioByWindowIndex = new TreeMap(Collections.reverseOrder());
    private final SortedMap<Long, Float> extrapolatedEntitiesByWindowIndex = new TreeMap(Collections.reverseOrder());
    private final SortedSet<Long> validWindowIndices = new TreeSet(Collections.reverseOrder());
    private final long windowMs;
    private final Set<E> validEntities = new HashSet();
    private final Set<String> validEntityGroups = new HashSet<String>();
    private float validEntityRatio = 0.0f;
    private float validEntityGroupRatio = 0.0f;

    public MetricSampleCompleteness(long generation, long windowMs) {
        super(generation);
        this.windowMs = windowMs;
    }

    void addValidEntityRatio(long windowIndex, float validEntityRatio) {
        this.validEntityRatioByWindowIndex.put(windowIndex, Float.valueOf(validEntityRatio));
    }

    void addValidEntityRatioWithGroupGranularity(long windowIndex, float validEntityRatio) {
        this.validEntityRatioWithGroupGranularityByWindowIndex.put(windowIndex, Float.valueOf(validEntityRatio));
    }

    void addValidEntityGroupRatio(long windowIndex, float validEntityGroupRatio) {
        this.validEntityGroupRatioByWindowIndex.put(windowIndex, Float.valueOf(validEntityGroupRatio));
    }

    void addExtrapolationEntityRatio(long windowIndex, float extrapolatedEntityRatio) {
        this.extrapolatedEntitiesByWindowIndex.put(windowIndex, Float.valueOf(extrapolatedEntityRatio));
    }

    void addValidWindowIndex(long windowIndex) {
        this.validWindowIndices.add(windowIndex);
    }

    void setValidEntityRatio(float validEntityRatio) {
        this.validEntityRatio = validEntityRatio;
    }

    void setValidEntityGroupRatio(float validEntityGroupRatio) {
        this.validEntityGroupRatio = validEntityGroupRatio;
    }

    void addValidEntities(Set<E> coveredEntities) {
        this.validEntities.addAll(coveredEntities);
    }

    void addValidEntityGroups(Set<String> coveredEntityGroups) {
        this.validEntityGroups.addAll(coveredEntityGroups);
    }

    void retainAllValidEntities(Set<E> coveredEntitiesToRetain) {
        this.validEntities.retainAll(coveredEntitiesToRetain);
    }

    void retainAllValidEntityGroups(Set<String> coveredEntityGroupsToRetain) {
        this.validEntityGroups.retainAll(coveredEntityGroupsToRetain);
    }

    public SortedMap<Long, Float> validEntityRatioByWindowIndex() {
        return this.validEntityRatioByWindowIndex;
    }

    public SortedMap<Long, Float> validEntityRatioWithGroupGranularityByWindowIndex() {
        return this.validEntityRatioWithGroupGranularityByWindowIndex;
    }

    public SortedMap<Long, Float> validEntityGroupRatioByWindowIndex() {
        return this.validEntityGroupRatioByWindowIndex;
    }

    public SortedMap<Long, Float> extrapolatedEntitiesByWindowIndex() {
        return this.extrapolatedEntitiesByWindowIndex;
    }

    public SortedSet<Long> validWindowIndices() {
        return this.validWindowIndices;
    }

    public Set<E> validEntities() {
        return this.validEntities;
    }

    public Set<String> validEntityGroups() {
        return this.validEntityGroups;
    }

    public float validEntityRatio() {
        return this.validEntityRatio;
    }

    public float validEntityGroupRatio() {
        return this.validEntityGroupRatio;
    }

    public long firstWindowIndex() {
        return this.validEntityRatioByWindowIndex.lastKey();
    }

    public long lastWindowIndex() {
        return this.validEntityRatioByWindowIndex.firstKey();
    }

    public long windowMs() {
        return this.windowMs;
    }

    public String toString() {
        return "MetricSampleCompleteness{validEntityRatioByWindowIndex=" + String.valueOf(this.validEntityRatioByWindowIndex) + ", validEntityRatioWithGroupGranularityByWindowIndex=" + String.valueOf(this.validEntityRatioWithGroupGranularityByWindowIndex) + ", validEntityGroupRatioByWindowIndex=" + String.valueOf(this.validEntityGroupRatioByWindowIndex) + ", extrapolatedEntitiesByWindowIndex=" + String.valueOf(this.extrapolatedEntitiesByWindowIndex) + ", validWindowIndices=" + String.valueOf(this.validWindowIndices) + ", windowMs=" + this.windowMs + ", validEntities=" + String.valueOf(this.validEntities) + ", validEntityGroups=" + String.valueOf(this.validEntityGroups) + ", validEntityRatio=" + this.validEntityRatio + ", validEntityGroupRatio=" + this.validEntityGroupRatio + "}";
    }
}

