/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.monitor.sampling.aggregator;

import com.linkedin.cruisecontrol.metricdef.MetricDef;
import com.linkedin.cruisecontrol.metricdef.MetricInfo;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregatedMetricValues;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.Extrapolation;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricValues;
import com.linkedin.kafka.cruisecontrol.monitor.metricdefinition.KafkaMetricDef;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ValuesAndExtrapolations {
    private static final short ALL_METRICS_SIZE = (short)KafkaMetricDef.commonMetricDef().all().size();
    private final AggregatedMetricValues metricValues;
    private final Extrapolation[] extrapolations;
    private final boolean haveExtrapolations;
    private List<Long> windows;

    public ValuesAndExtrapolations(AggregatedMetricValues metricValues, Extrapolation[] extrapolations) {
        this.metricValues = metricValues;
        this.extrapolations = extrapolations;
        this.haveExtrapolations = Arrays.stream(extrapolations).anyMatch(Objects::nonNull);
    }

    public AggregatedMetricValues metricValues() {
        return this.metricValues;
    }

    public Map<Integer, Extrapolation> extrapolations() {
        if (!this.haveExtrapolations()) {
            return Collections.emptyMap();
        }
        HashMap<Integer, Extrapolation> extraPolationMap = new HashMap<Integer, Extrapolation>();
        for (int i = 0; i < this.extrapolations.length; ++i) {
            if (this.extrapolations[i] == null) continue;
            extraPolationMap.put(i, this.extrapolations[i]);
        }
        return extraPolationMap;
    }

    public boolean haveExtrapolations() {
        return this.haveExtrapolations;
    }

    public List<Long> windows() {
        return Collections.unmodifiableList(this.windows);
    }

    public long window(int index) {
        return this.windows.get(index);
    }

    public void setWindows(List<Long> windows) {
        this.windows = windows;
    }

    static ValuesAndExtrapolations empty(int numWindows, MetricDef metricDef) {
        MetricValues[] values = new MetricValues[ALL_METRICS_SIZE];
        for (MetricInfo mi : metricDef.all()) {
            values[mi.id()] = new MetricValues(numWindows);
        }
        Extrapolation[] extrapolations = new Extrapolation[numWindows];
        Arrays.fill((Object[])extrapolations, (Object)Extrapolation.NO_VALID_EXTRAPOLATION);
        return new ValuesAndExtrapolations(new AggregatedMetricValues(values), extrapolations);
    }
}

