/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.PlanComputationOptions;
import com.linkedin.kafka.cruisecontrol.common.SbkAdminUtils;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.executor.Executor;
import com.linkedin.kafka.cruisecontrol.monitor.LoadMonitor;
import com.linkedin.kafka.cruisecontrol.plan.PlanComputationUtils;
import com.linkedin.kafka.cruisecontrol.server.BrokerShutdownManager;
import io.confluent.databalancer.operation.EvenClusterLoadStateManager;
import java.util.regex.Pattern;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.utils.Time;

public class KafkaCruiseControlContext {
    private final Integer brokerId;
    private final Time time;
    private final KafkaCruiseControl.CcStartupMode startupMode;
    private final PlanComputationOptions defaultPlanComputationOptions;
    private final PlanComputationUtils computationUtils;
    private final ConfluentAdmin adminClient;
    private final SbkAdminUtils sbkAdminUtils;
    private final LoadMonitor loadMonitor;
    private final Executor executor;
    private final BrokerShutdownManager brokerShutdownManager;
    private final EvenClusterLoadStateManager evenClusterLoadStateManager;
    private volatile boolean selfHealingEnabled;
    private volatile KafkaCruiseControlConfig config;
    private volatile Pattern excludedTopicsPattern;

    private KafkaCruiseControlContext(Integer brokerId, KafkaCruiseControlConfig config, Time time, KafkaCruiseControl.CcStartupMode startupMode, PlanComputationOptions defaultPlanComputationOptions, PlanComputationUtils computationUtils, ConfluentAdmin adminClient, SbkAdminUtils sbkAdminUtils, LoadMonitor loadMonitor, Executor executor, BrokerShutdownManager brokerShutdownManager, EvenClusterLoadStateManager evenClusterLoadStateManager) {
        this.brokerId = brokerId;
        this.config = config;
        this.time = time;
        this.startupMode = startupMode;
        this.defaultPlanComputationOptions = defaultPlanComputationOptions;
        this.computationUtils = computationUtils;
        this.adminClient = adminClient;
        this.sbkAdminUtils = sbkAdminUtils;
        this.loadMonitor = loadMonitor;
        this.executor = executor;
        this.brokerShutdownManager = brokerShutdownManager;
        this.evenClusterLoadStateManager = evenClusterLoadStateManager;
        this.excludedTopicsPattern = Pattern.compile(config.getString("topics.excluded.from.partition.movement"));
    }

    public Integer brokerId() {
        return this.brokerId;
    }

    public KafkaCruiseControl.CcStartupMode startupMode() {
        return this.startupMode;
    }

    public KafkaCruiseControlConfig config() {
        return this.config;
    }

    public void config(KafkaCruiseControlConfig newConfig) {
        String newExcludedTopicsPatternStr;
        String oldExcludedTopicsPatternStr = this.config.getString("topics.excluded.from.partition.movement");
        if (!oldExcludedTopicsPatternStr.equals(newExcludedTopicsPatternStr = newConfig.getString("topics.excluded.from.partition.movement"))) {
            this.excludedTopicsPattern = Pattern.compile(newExcludedTopicsPatternStr);
        }
        this.config = newConfig;
    }

    public Time time() {
        return this.time;
    }

    public EvenClusterLoadStateManager evenClusterLoadStateManager() {
        return this.evenClusterLoadStateManager;
    }

    public Pattern excludedTopicsPattern() {
        return this.excludedTopicsPattern;
    }

    public PlanComputationOptions defaultPlanComputationOptions() {
        return this.defaultPlanComputationOptions;
    }

    public PlanComputationUtils computationUtils() {
        return this.computationUtils;
    }

    public ConfluentAdmin adminClient() {
        return this.adminClient;
    }

    public SbkAdminUtils sbkAdminUtils() {
        return this.sbkAdminUtils;
    }

    public LoadMonitor loadMonitor() {
        return this.loadMonitor;
    }

    public Executor executor() {
        return this.executor;
    }

    public BrokerShutdownManager brokerShutdownManager() {
        return this.brokerShutdownManager;
    }

    public void selfHealingEnabled(boolean selfHealingEnabled) {
        this.selfHealingEnabled = selfHealingEnabled;
    }

    public boolean selfHealingEnabled() {
        return this.selfHealingEnabled;
    }

    public static class KafkaCruiseControlContextBuilder {
        private Integer brokerId;
        private volatile KafkaCruiseControlConfig config;
        private Time time;
        private KafkaCruiseControl.CcStartupMode startupMode;
        private PlanComputationOptions defaultPlanComputationOptions;
        private PlanComputationUtils computationUtils;
        private ConfluentAdmin adminClient;
        private SbkAdminUtils sbkAdminUtils;
        private LoadMonitor loadMonitor;
        private Executor executor;
        private EvenClusterLoadStateManager evenClusterLoadStateManager;
        private BrokerShutdownManager brokerShutdownManager;

        public static KafkaCruiseControlContextBuilder of(Integer brokerId, KafkaCruiseControlConfig config, Time time, KafkaCruiseControl.CcStartupMode startupMode) {
            KafkaCruiseControlContextBuilder builder = new KafkaCruiseControlContextBuilder();
            builder.brokerId = brokerId;
            builder.config = config;
            builder.time = time;
            builder.startupMode = startupMode;
            return builder;
        }

        public Integer brokerId() {
            return this.brokerId;
        }

        public KafkaCruiseControlConfig config() {
            return this.config;
        }

        public Time time() {
            return this.time;
        }

        public KafkaCruiseControl.CcStartupMode startupMode() {
            return this.startupMode;
        }

        public KafkaCruiseControlContextBuilder defaultPlanComputationOptions(PlanComputationOptions defaultPlanComputationOptions) {
            this.defaultPlanComputationOptions = defaultPlanComputationOptions;
            return this;
        }

        public KafkaCruiseControlContextBuilder computationUtils(PlanComputationUtils computationUtils) {
            this.computationUtils = computationUtils;
            return this;
        }

        public KafkaCruiseControlContextBuilder adminClient(ConfluentAdmin adminClient) {
            this.adminClient = adminClient;
            return this;
        }

        public KafkaCruiseControlContextBuilder sbkAdminUtils(SbkAdminUtils sbkAdminUtils) {
            this.sbkAdminUtils = sbkAdminUtils;
            return this;
        }

        public KafkaCruiseControlContextBuilder loadMonitor(LoadMonitor loadMonitor) {
            this.loadMonitor = loadMonitor;
            return this;
        }

        public KafkaCruiseControlContextBuilder executor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public KafkaCruiseControlContextBuilder brokerShutdownManager(BrokerShutdownManager brokerShutdownManager) {
            this.brokerShutdownManager = brokerShutdownManager;
            return this;
        }

        public KafkaCruiseControlContextBuilder evenClusterLoadStateManagers(EvenClusterLoadStateManager evenClusterLoadStateManager) {
            this.evenClusterLoadStateManager = evenClusterLoadStateManager;
            return this;
        }

        public KafkaCruiseControlContext build() {
            return new KafkaCruiseControlContext(this.brokerId, this.config, this.time, this.startupMode, this.defaultPlanComputationOptions, this.computationUtils, this.adminClient, this.sbkAdminUtils, this.loadMonitor, this.executor, this.brokerShutdownManager, this.evenClusterLoadStateManager);
        }
    }
}

