/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import io.confluent.kafka.clients.CloudAdmin;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.TopicExistsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SbkTopicUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SbkTopicUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkTopicPropertiesMaybeCreate(SbkTopicConfig topicConfig, Map<String, ?> config) {
        block6: {
            CloudAdmin adminClient = KafkaCruiseControlUtils.createAdmin(KafkaCruiseControlUtils.filterAdminClientConfigs(config));
            try {
                int numberOfBrokersInCluster = ((Collection)adminClient.describeCluster().nodes().get()).size();
                short replicationFactor = topicConfig.replicationFactor;
                if (numberOfBrokersInCluster < replicationFactor) {
                    LOG.warn("Kafka cluster has {} brokers but the requested replication factor is {} for topic {}.", new Object[]{numberOfBrokersInCluster, (int)replicationFactor, topicConfig.topic});
                    break block6;
                }
                ListTopicsOptions options = new ListTopicsOptions().listInternal(true);
                Set topics = (Set)adminClient.listTopics(options).names().get();
                boolean bl = !SbkTopicUtils.ensureTopicCreated((ConfluentAdmin)adminClient, topics, topicConfig.topic, topicConfig.cleanupPolicy, topicConfig.minRetentionTimeMs, replicationFactor, topicConfig.partitionCount);
                return bl;
            }
            catch (InterruptedException | ExecutionException ex) {
                LOG.error("Error while checking topic {} exsistence", (Object)topicConfig.topic, (Object)ex);
            }
            finally {
                KafkaCruiseControlUtils.closeAdminClientWithTimeout((Admin)adminClient, 0L);
            }
        }
        return false;
    }

    static boolean ensureTopicCreated(ConfluentAdmin adminClient, Set<String> allTopics, String topic, String cleanupPolicy, long retentionMs, int replicationFactor, int partitionCount) {
        HashMap<String, String> props = new HashMap<String, String>(2);
        props.put("retention.ms", Long.toString(retentionMs));
        props.put("cleanup.policy", cleanupPolicy);
        if (!allTopics.contains(topic)) {
            LOG.info("DataBalancer: Creating topic {} ", (Object)topic);
            NewTopic newTopic = new NewTopic(topic, partitionCount, (short)replicationFactor).configs(props);
            try {
                adminClient.createTopics(Collections.singleton(newTopic)).all().get();
                return true;
            }
            catch (ExecutionException e2) {
                if (e2.getCause() instanceof TopicExistsException) {
                    LOG.info("{} topic already exists. It wasn't present in the list of topics: {}", (Object)topic, allTopics);
                }
                throw new RuntimeException(e2.getCause());
            }
            catch (InterruptedException e3) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e3);
            }
        }
        try {
            LOG.info("DataBalancer: Adjusting topic {} configuration", (Object)topic);
            ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
            List alterConfigOps = props.entrySet().stream().map(e -> new AlterConfigOp(new ConfigEntry((String)e.getKey(), (String)e.getValue()), AlterConfigOp.OpType.SET)).collect(Collectors.toList());
            Map configs = Collections.singletonMap(topicResource, alterConfigOps);
            try {
                adminClient.incrementalAlterConfigs(configs).all().get();
                TopicDescription topicDescription = (TopicDescription)((KafkaFuture)adminClient.describeTopics(Collections.singleton(topic)).topicNameValues().get(topic)).get();
                SbkTopicUtils.maybeIncreaseTopicPartitionCount(adminClient, topic, topicDescription, partitionCount);
            }
            catch (InterruptedException | ExecutionException e4) {
                throw new RuntimeException(e4.getMessage());
            }
        }
        catch (RuntimeException re) {
            LOG.error("Skip updating configuration of topic " + topic + " due to exception.", (Throwable)re);
        }
        return false;
    }

    public static void deleteTopics(ConfluentAdmin adminClient, Set<String> allTopics, List<String> topics) {
        Objects.requireNonNull(allTopics);
        List topicsToDelete = topics.stream().filter(allTopics::contains).collect(Collectors.toList());
        if (topicsToDelete.isEmpty()) {
            LOG.info("DataBalancer: No topics to be deleted.");
            return;
        }
        try {
            LOG.info("DataBalancer: Deleting topic(s) {} ", topicsToDelete);
            adminClient.deleteTopics(topicsToDelete).all().get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    static void maybeIncreaseTopicPartitionCount(ConfluentAdmin adminClient, String topic, TopicDescription topicDescription, int partitionCount) throws ExecutionException, InterruptedException {
        if (partitionCount > topicDescription.partitions().size()) {
            LOG.info("DataBalancer: Adjusting topic {} partition count to {}", (Object)topic, (Object)partitionCount);
            Map<String, NewPartitions> newPartitions = Collections.singletonMap(topic, NewPartitions.increaseTo((int)partitionCount));
            adminClient.createPartitions(newPartitions).all().get();
            LOG.info("Kafka topic " + topic + " now has " + partitionCount + " partitions.");
        }
    }

    public static final class SbkTopicConfig {
        public final long minRetentionTimeMs;
        public final short replicationFactor;
        public final String topic;
        public final int partitionCount;
        public final String cleanupPolicy;

        public SbkTopicConfig(long minRetentionTimeMs, short replicationFactor, String topic, int partitionCount, String cleanupPolicy) {
            this.minRetentionTimeMs = minRetentionTimeMs;
            this.replicationFactor = replicationFactor;
            this.topic = topic;
            this.partitionCount = partitionCount;
            this.cleanupPolicy = cleanupPolicy;
        }
    }

    public static final class SbkTopicConfigBuilder {
        private long minRetentionTimeMs;
        private short replicationFactor;
        private String topic;
        private int partitionCount;
        private String cleanupPolicy;

        public SbkTopicConfig build() {
            return new SbkTopicConfig(this.minRetentionTimeMs, this.replicationFactor, this.topic, this.partitionCount, this.cleanupPolicy);
        }

        public SbkTopicConfigBuilder setMinRetentionTimeMs(long minRetentionTimeMs) {
            this.minRetentionTimeMs = minRetentionTimeMs;
            return this;
        }

        public SbkTopicConfigBuilder setReplicationFactor(Map<String, ?> config, String replicationFactorConfig, short defaultReplicationFactor) {
            Object replicationFactor = config.get(replicationFactorConfig);
            this.replicationFactor = replicationFactor == null || replicationFactor.toString().isEmpty() ? defaultReplicationFactor : Short.parseShort(replicationFactor.toString());
            return this;
        }

        public SbkTopicConfigBuilder setTopic(String topic) {
            this.topic = topic;
            return this;
        }

        public SbkTopicConfigBuilder setPartitionCount(Map<String, ?> config, String partitionCountConfig, int defaultPartitionCount) {
            Object partitionCount = config.get(partitionCountConfig);
            this.partitionCount = partitionCount == null || partitionCount.toString().isEmpty() ? defaultPartitionCount : Integer.parseInt(partitionCount.toString());
            return this;
        }

        public SbkTopicConfigBuilder setPartitionCount(int partitionCount) {
            this.partitionCount = partitionCount;
            return this;
        }

        public SbkTopicConfigBuilder setCleanupPolicy(String cleanupPolicy) {
            this.cleanupPolicy = cleanupPolicy;
            return this;
        }
    }
}

