/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum ActionType {
    INTER_BROKER_REPLICA_MOVEMENT("REPLICA"),
    INTER_CELL_PARTITION_MOVEMENT("PARTITION"),
    LEADERSHIP_MOVEMENT("LEADER"),
    INTER_BROKER_REPLICA_SWAP("SWAP");

    private static final List<ActionType> CACHED_VALUES;
    private final String balancingAction;

    public static List<ActionType> cachedValues() {
        return CACHED_VALUES;
    }

    private ActionType(String balancingAction) {
        this.balancingAction = balancingAction;
    }

    public String balancingAction() {
        return this.balancingAction;
    }

    public String toString() {
        return this.balancingAction;
    }

    static {
        CACHED_VALUES = Collections.unmodifiableList(Arrays.asList(ActionType.values()));
    }
}

