/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalBalancingActionAcceptance;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;

public class PartitionBalancingAction
implements BalancingAction {
    private static final String REPLICA_MOVES_KEY = "replicaMoves";
    private final Map<Replica, Broker> replicaMoves;
    private final TopicPartition topicPartition;

    public PartitionBalancingAction(Map<Replica, Broker> replicaMoves) {
        Objects.requireNonNull(replicaMoves, "Null replica moves provided.");
        Set partitions = replicaMoves.keySet().stream().map(Replica::topicPartition).collect(Collectors.toSet());
        if (partitions.size() != 1) {
            throw new RuntimeException("Replica list in partition move belong to more than one partition: " + String.valueOf(partitions));
        }
        this.topicPartition = (TopicPartition)partitions.iterator().next();
        if (new HashSet<Broker>(replicaMoves.values()).size() != replicaMoves.size()) {
            throw new RuntimeException("Two replica of a partition cannot be on same broker: " + String.valueOf(replicaMoves));
        }
        this.replicaMoves = replicaMoves;
    }

    @Override
    public ActionType balancingAction() {
        return ActionType.INTER_CELL_PARTITION_MOVEMENT;
    }

    @Override
    public ActionAcceptance actionAcceptance(GoalBalancingActionAcceptance actionAcceptance, ClusterModel clusterModel) {
        return actionAcceptance.partitionActionAcceptance(this, clusterModel);
    }

    @Override
    public boolean selfSatisfied(ClusterModel clusterModel, GoalBalancingActionAcceptance actionAcceptance) {
        return actionAcceptance.partitionActionSelfSatisfied(clusterModel, this);
    }

    public Map<Replica, Broker> replicaMoves() {
        return this.replicaMoves;
    }

    @Override
    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public int hashCode() {
        return this.replicaMoves.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        PartitionBalancingAction that = (PartitionBalancingAction)other;
        return this.replicaMoves.equals(that.replicaMoves);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + String.valueOf(this.replicaMoves);
    }

    @Override
    public Map<String, Object> getJsonStructure() {
        return Collections.singletonMap(REPLICA_MOVES_KEY, this.replicaMoves);
    }
}

