/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.IncrementalResourceDistributionGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.ProposalObservabilityTrackingOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.thresholds.BalancingThresholdsFactory;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.thresholds.ResourceUtilizationRatioThresholds;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.model.Cell;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalCPUResourceDistributionGoal
extends IncrementalResourceDistributionGoal {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalCPUResourceDistributionGoal.class);
    private int numTopProposalsToTrack;
    private boolean topProposalTrackingEnabled = true;

    @Override
    public String name() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void configure(KafkaCruiseControlConfig kccConfig) {
        super.configure(kccConfig);
        this.numTopProposalsToTrack = kccConfig.getInt("incremental.balancing.cpu.top.proposal.tracking.num.proposals");
        this.topProposalTrackingEnabled = kccConfig.getBoolean("incremental.balancing.cpu.top.proposal.tracking.enabled");
    }

    @Override
    protected Resource resource() {
        return Resource.CPU;
    }

    @Override
    protected boolean validatePercentages() {
        return false;
    }

    @Override
    protected ResourceUtilizationRatioThresholds balancingThresholds(ClusterModel clusterModel, OptimizationOptions optimizationOptions, boolean needValidation) {
        ResourceUtilizationRatioThresholds thresholds = BalancingThresholdsFactory.computeAbsoluteThresholds(clusterModel, optimizationOptions, this.balancingConstraint, this.resource(), needValidation);
        LOG.info("[{}] CPU thresholds computed: upper={}%, lower={}%, mean={}%, lowUtil={}%", new Object[]{this.name(), thresholds.balanceUpperThreshold() * 100.0, thresholds.balanceLowerThreshold() * 100.0, thresholds.meanUtilizationRatio() * 100.0, thresholds.lowUtilizationRatio() * 100.0});
        return thresholds;
    }

    @Override
    protected ResourceUtilizationRatioThresholds balancingThresholdsForCell(Cell cell, OptimizationOptions optimizationOptions, boolean needValidation) {
        ResourceUtilizationRatioThresholds thresholds = BalancingThresholdsFactory.computeAbsoluteThresholdsForCell(cell, optimizationOptions, this.balancingConstraint, this.resource(), needValidation);
        LOG.info("[{}] CPU thresholds for cell {} computed: upper={}%, lower={}%, mean={}%, lowUtil={}%", new Object[]{this.name(), cell.id(), thresholds.balanceUpperThreshold() * 100.0, thresholds.balanceLowerThreshold() * 100.0, thresholds.meanUtilizationRatio() * 100.0, thresholds.lowUtilizationRatio() * 100.0});
        return thresholds;
    }

    @Override
    public boolean runWithHardGoal() {
        return true;
    }

    @Override
    protected ProposalObservabilityTrackingOptions proposalTrackingOptions() {
        return new ProposalObservabilityTrackingOptions(this.topProposalTrackingEnabled && LOG.isDebugEnabled(), this.numTopProposalsToTrack);
    }
}

