/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.CapacityGoal;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.model.Replica;

public class MirrorInboundCapacityGoal
extends CapacityGoal {
    public MirrorInboundCapacityGoal() {
    }

    MirrorInboundCapacityGoal(BalancingConstraint constraint) {
        super(constraint);
    }

    @Override
    protected boolean shouldExcludeForReplicaMove(Replica replica) {
        return !replica.isOriginalOffline() && !replica.isLeader();
    }

    @Override
    public CapacityGoal.CapacityViolationResponse selfHealingCapacityViolationResponse() {
        return CapacityGoal.CapacityViolationResponse.ACCEPT_ALWAYS;
    }

    @Override
    protected Resource.CompositeResource resource() {
        return Resource.CompositeResource.PRODUCE_IN_MIRROR_IN;
    }

    @Override
    public String name() {
        return MirrorInboundCapacityGoal.class.getSimpleName();
    }
}

