/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RebalanceStep {
    public static final Logger log = LoggerFactory.getLogger(RebalanceStep.class);

    default public boolean balance() {
        try {
            return this.doBalance();
        }
        catch (Exception e) {
            log.error("RebalanceHandler {} threw an unexpected exception while trying to balance", (Object)this.getClass().getName(), (Object)e);
            throw e;
        }
    }

    public boolean doBalance();

    default public RebalanceStep onFailureThen(RebalanceStep nextHandler) {
        return () -> {
            boolean noMoreBalancingNeeded = this.balance();
            if (noMoreBalancingNeeded) {
                log.debug("RebalanceHandler {} either balanced successfully or skipped/aborted balancing.", (Object)this.getClass().getName());
                return true;
            }
            log.debug("RebalanceHandler {} could not balance. Proceeding to {}", (Object)this.getClass().getName(), (Object)nextHandler.getClass().getName());
            return nextHandler.balance();
        };
    }
}

