/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.CapacityGoal;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.model.Replica;

public final class ReplicationInboundCapacityGoal
extends CapacityGoal {
    @Override
    public boolean shouldExcludeForReplicaMove(Replica replica) {
        return replica.isLeader() && !replica.isOriginalOffline();
    }

    @Override
    public CapacityGoal.CapacityViolationResponse selfHealingCapacityViolationResponse() {
        return CapacityGoal.CapacityViolationResponse.ACCEPT_ALWAYS;
    }

    @Override
    public Resource.CompositeResource resource() {
        return Resource.CompositeResource.ofResource(Resource.REPLICATION_IN);
    }

    @Override
    public String name() {
        return ReplicationInboundCapacityGoal.class.getSimpleName();
    }
}

