/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ReplicaBalancingAction;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.TopicImbalanceScoreType;
import java.util.List;
import java.util.Set;

public interface TopicStats {
    public double getAverageLeadersForBrokerForTopic(String var1, Broker var2, double var3);

    public void initializeAverageLeadersForBrokersForTopic(ClusterModel var1, String var2);

    public double getAverageFollowersForBrokerForTopic(String var1, Broker var2, double var3);

    public void initializeAverageFollowersForBrokersForTopic(ClusterModel var1, String var2);

    public List<Integer> replicaDistributionForTopic(ClusterModel var1, String var2, Boolean var3, Broker var4);

    public List<Integer> replicaDistributionAfterAction(ClusterModel var1, ReplicaBalancingAction var2, Boolean var3);

    public List<String> getEligibleTopicsForRebalance();

    public void setEligibleTopicsForRebalance(List<String> var1);

    public Double getEligibleTopicsForRebalanceInitialScore(String var1);

    public double getTopicImbalanceScore(String var1, ClusterModel var2);

    public double getTopicImbalanceScore(String var1, ClusterModel var2, Broker var3);

    public void logChangeInTopicImbalanceScore(String var1, ClusterModel var2);

    public Set<Broker> getEligibleDestinationBrokers(ClusterModel var1, Broker var2);

    public Set<Broker> getEligibleSourceBrokers(ClusterModel var1, Broker var2);

    public boolean hasMoreTopicLeadersForRack(String var1);

    public boolean hasLessTopicLeadersForRack(String var1);

    public boolean canAccommodateMoreTopicLeadersForRack(String var1);

    public boolean canAccommodateMoreTopicLeadersForRack(String var1, Broker var2);

    public int numTopicLeadersThatCanBeMovedToRack(String var1);

    public boolean metRackTopicLeadersUpperBound(String var1);

    public boolean canReleaseMoreTopicLeadersForRack(String var1);

    public boolean canReleaseMoreTopicLeadersForRack(String var1, Broker var2);

    public int numTopicLeadersThatCanBeMovedFromRack(String var1);

    public boolean metRackTopicLeadersLowerBound(String var1);

    public boolean isCurrentTopicLeadersCountAtUpperBoundForRack(String var1, Broker var2);

    public boolean isCurrentTopicLeadersCountAtLowerBoundForRack(String var1, Broker var2);

    public void incrementCurrentTopicLeadersPerRack(String var1, Broker var2, Integer var3);

    public void decrementCurrentTopicLeadersPerRack(String var1, Broker var2, Integer var3);

    public void initializeRackRelatedTopicLeaderDistribution(ClusterModel var1, String var2);

    public void initializeBrokersCountPerRack(ClusterModel var1);

    public void initializeTopicsToRebalanceInitialScores(ClusterModel var1, TopicImbalanceScoreType var2);
}

