/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals.internals;

import com.linkedin.kafka.cruisecontrol.analyzer.AnalyzerUtils;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public class IncrementalResourceDistributionStatsSnapshot {
    private final int numBrokersAboveLowerBoundThreshold;
    private final double incrementalLowerBoundPercentage;
    private final double incrementalStepRatioPercentage;
    private final boolean isCellEnabled;
    private final int cellId;
    private final Map<Integer, Double> desiredIncrementalImprovementByBrokerId;
    private final Map<Integer, String> resourceUsageByBroker;
    private final double clusterMeanUtilizationPercentage;
    private final double cellMeanUtilizationPercentage;

    public IncrementalResourceDistributionStatsSnapshot(boolean isCellEnabled, int cellId, Map<Integer, String> resourceUsageByBroker, Map<Integer, Double> desiredIncrementalImprovementPercentageByBrokerId, double incrementalLowerBoundPercentage, double incrementalStepRatioPercentage, double clusterMeanUtilizationPercentage, double cellMeanUtilizationPercentage) {
        this.isCellEnabled = isCellEnabled;
        this.cellId = cellId;
        this.desiredIncrementalImprovementByBrokerId = desiredIncrementalImprovementPercentageByBrokerId;
        this.incrementalLowerBoundPercentage = incrementalLowerBoundPercentage;
        this.incrementalStepRatioPercentage = incrementalStepRatioPercentage;
        this.clusterMeanUtilizationPercentage = clusterMeanUtilizationPercentage;
        this.cellMeanUtilizationPercentage = cellMeanUtilizationPercentage;
        this.resourceUsageByBroker = resourceUsageByBroker;
        this.numBrokersAboveLowerBoundThreshold = (int)desiredIncrementalImprovementPercentageByBrokerId.values().stream().filter(t -> AnalyzerUtils.isLarger(t, incrementalLowerBoundPercentage)).count();
    }

    public int numBrokersAboveLowerBoundThreshold() {
        return this.numBrokersAboveLowerBoundThreshold;
    }

    public double clusterMeanUtilizationPercentage() {
        return this.clusterMeanUtilizationPercentage;
    }

    public double cellMeanUtilizationPercentage() {
        return this.cellMeanUtilizationPercentage;
    }

    public double incrementalStepRatio() {
        return this.incrementalStepRatioPercentage;
    }

    public double desiredIncrementalImprovementPercent(int brokerId) {
        Double incrementalImprovement = this.desiredIncrementalImprovementByBrokerId.get(brokerId);
        if (incrementalImprovement == null) {
            throw new IllegalArgumentException(String.format("brokeId (%d) does not exist in the incremental improvements keys (%s)", brokerId, this.desiredIncrementalImprovementByBrokerId.keySet()));
        }
        return Math.max(incrementalImprovement, this.incrementalLowerBoundPercentage);
    }

    public boolean isCellEnabled() {
        return this.isCellEnabled;
    }

    public int cellId() {
        return this.cellId;
    }

    public String toString() {
        return "IncrementalResourceDistributionStatsSnapshot{numBrokersAboveLowerBoundThreshold=" + this.numBrokersAboveLowerBoundThreshold + ", incrementalLowerBound=" + this.incrementalLowerBoundPercentage + ", incrementalStepRatio=" + this.incrementalStepRatioPercentage + ", clusterMeanUtilizationPercentage=" + this.clusterMeanUtilizationPercentage + ", cellMeanUtilizationPercentage=" + this.cellMeanUtilizationPercentage + ", incrementalBalancingThresholdByBrokerId=" + String.valueOf(this.desiredIncrementalImprovementByBrokerId) + ", resourceUsageByBroker=" + String.valueOf(this.resourceUsageByBroker) + "}";
    }
}

