/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals.internals;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.AbstractDistributionStatsSnapshot;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.BrokerResourceStats;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.thresholds.ReplicaCountThresholds;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaDistributionStatsSnapshot
extends AbstractDistributionStatsSnapshot {
    protected static final Logger LOG = LoggerFactory.getLogger(ReplicaDistributionStatsSnapshot.class);
    private final ReplicaCountThresholds replicaThresholds;

    public ReplicaDistributionStatsSnapshot(BrokerResourceStats minBrokerResource, BrokerResourceStats maxBrokerResource, ReplicaCountThresholds replicaThresholds) {
        super(minBrokerResource, maxBrokerResource);
        this.replicaThresholds = replicaThresholds;
    }

    public ReplicaCountThresholds replicaThresholds() {
        return this.replicaThresholds;
    }

    public static ReplicaDistributionStatsSnapshot compute(ReplicaCountThresholds replicaThresholds, List<BrokerResourceStats> resources) throws IllegalArgumentException {
        if (resources.isEmpty()) {
            String errorMsg = "No broker resources were given to compute.";
            LOG.error(errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        BrokerResourceStats minBrokerResourceUnderLowerLimit = null;
        BrokerResourceStats maxBrokerResourceOverUpperLimit = null;
        for (BrokerResourceStats brokerResourceStats : resources) {
            maxBrokerResourceOverUpperLimit = ReplicaDistributionStatsSnapshot.maxResource(brokerResourceStats, maxBrokerResourceOverUpperLimit);
            minBrokerResourceUnderLowerLimit = ReplicaDistributionStatsSnapshot.minResource(brokerResourceStats, minBrokerResourceUnderLowerLimit);
        }
        return new ReplicaDistributionStatsSnapshot(minBrokerResourceUnderLowerLimit, maxBrokerResourceOverUpperLimit, replicaThresholds);
    }

    public static enum ReplicaResource {
        LEADER,
        REPLICA;

    }
}

