/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals.internals;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.AbstractDistributionStatsSnapshot;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.BrokerResourceStats;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.thresholds.ResourceUtilizationRatioThresholdsProvider;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.model.Cell;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;

public class ResourceDistributionStatsSnapshot
extends AbstractDistributionStatsSnapshot {
    private final int numBrokersUnderLowUtilizationThreshold;
    private final int cellId;
    private final ResourceValueThresholds resourceValueThresholds;

    private ResourceDistributionStatsSnapshot(BrokerResourceStats minBrokerResource, BrokerResourceStats maxBrokerResource, int numBrokersUnderLowUtilizationThreshold, int cellId, ResourceValueThresholds resourceValueThresholds) {
        super(minBrokerResource, maxBrokerResource);
        this.numBrokersUnderLowUtilizationThreshold = numBrokersUnderLowUtilizationThreshold;
        this.cellId = cellId;
        this.resourceValueThresholds = resourceValueThresholds;
    }

    public int numBrokersUnderLowUtilizationThreshold() {
        return this.numBrokersUnderLowUtilizationThreshold;
    }

    public ResourceValueThresholds resourceValueThresholds() {
        return this.resourceValueThresholds;
    }

    public String toString() {
        return "ResourceDistributionStatsSnapshot{minBrokerResourceUnderLowerLimitOpt=" + String.valueOf(this.minBrokerResource) + ", maxBrokerResourceOverUpperLimitOpt=" + String.valueOf(this.maxBrokerResource) + ", numBrokersUnderLowUtilizationThreshold=" + this.numBrokersUnderLowUtilizationThreshold + ", cellId=" + this.cellId + ", resourceValueThresholds=" + String.valueOf(this.resourceValueThresholds) + "}";
    }

    public static List<ResourceDistributionStatsSnapshot> tryCompute(Collection<BrokerResourceStats> brokerResourceStats, ResourceUtilizationRatioThresholdsProvider thresholds) throws IllegalArgumentException {
        if (brokerResourceStats.isEmpty()) {
            String errorMsg = "No broker brokerResourceStats were given to compute.";
            LOG.error(errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        Optional<Double> brokerCapacityOpt = ResourceDistributionStatsSnapshot.validateEvenBrokerResourceCapacities(brokerResourceStats, thresholds.resource());
        if (!brokerCapacityOpt.isPresent()) {
            LOG.warn("Could not compute resource distribution stats snapshot due to uneven broker capacities.");
            return Collections.emptyList();
        }
        double brokerCapacity = brokerCapacityOpt.get();
        Map<Integer, List<BrokerResourceStats>> cellToBroker = brokerResourceStats.stream().filter(stats -> !Cell.isImaginaryCellId(stats.cellId())).collect(Collectors.groupingBy(BrokerResourceStats::cellId));
        return cellToBroker.entrySet().stream().map(cellIdBrokerStats -> {
            int cellId = (Integer)cellIdBrokerStats.getKey();
            List brokerResourceStatsList = (List)cellIdBrokerStats.getValue();
            double lowerBalanceValue = thresholds.balanceLowerThreshold(cellId) * brokerCapacity;
            double upperBalanceValue = thresholds.balanceUpperThreshold(cellId) * brokerCapacity;
            double lowUtilizationValue = thresholds.lowUtilizationRatio(cellId) * brokerCapacity;
            double meanUtilizationValue = thresholds.meanUtilizationRatio(cellId) * brokerCapacity;
            int numBrokerUnderMinUtil = 0;
            BrokerResourceStats minBrokerResourceUnderLowerLimit = null;
            BrokerResourceStats maxBrokerResourceOverUpperLimit = null;
            for (BrokerResourceStats brokerResource : brokerResourceStatsList) {
                if (brokerResource.utilizationValue() < lowUtilizationValue) {
                    ++numBrokerUnderMinUtil;
                    continue;
                }
                minBrokerResourceUnderLowerLimit = ResourceDistributionStatsSnapshot.minResource(brokerResource, minBrokerResourceUnderLowerLimit);
                maxBrokerResourceOverUpperLimit = ResourceDistributionStatsSnapshot.maxResource(brokerResource, maxBrokerResourceOverUpperLimit);
            }
            return new ResourceDistributionStatsSnapshot(minBrokerResourceUnderLowerLimit, maxBrokerResourceOverUpperLimit, numBrokerUnderMinUtil, cellId, new ResourceValueThresholds(upperBalanceValue, lowerBalanceValue, lowUtilizationValue, meanUtilizationValue, thresholds.resource()));
        }).collect(Collectors.toList());
    }

    private static Optional<Double> validateEvenBrokerResourceCapacities(Collection<BrokerResourceStats> resources, Resource resource) {
        return GoalUtils.validateEvenBrokerResourceCapacities(resources.stream().collect(Collectors.toMap(BrokerResourceStats::brokerId, BrokerResourceStats::capacityValue)), resource);
    }

    public int cellId() {
        return this.cellId;
    }

    @ThreadSafe
    public static class ResourceValueThresholds {
        public final double balanceUpperValueThreshold;
        public final double balanceLowerValueThreshold;
        public final double lowUtilizationValueThreshold;
        public final double meanUtilizationValueThreshold;
        public final Resource resource;

        public ResourceValueThresholds(double balanceUpperValueThreshold, double balanceLowerValueThreshold, double lowUtilizationValueThreshold, double meanUtilizationValueThreshold, Resource resource) {
            this.balanceUpperValueThreshold = balanceUpperValueThreshold;
            this.balanceLowerValueThreshold = balanceLowerValueThreshold;
            this.lowUtilizationValueThreshold = lowUtilizationValueThreshold;
            this.meanUtilizationValueThreshold = meanUtilizationValueThreshold;
            this.resource = resource;
        }

        public String toString() {
            String lowUtilStr = String.format("%.2f", this.lowUtilizationValueThreshold);
            String meanUtilStr = String.format("%.2f", this.meanUtilizationValueThreshold);
            String balanceLowerThresholdStr = String.format("%.2f", this.balanceLowerValueThreshold);
            String balanceUpperThresholdStr = String.format("%.2f", this.balanceUpperValueThreshold);
            return String.format("Resource Value Thresholds for %s - low utilization threshold %s, mean utilization threshold %s, lower limit: %s, upper limit: %s", this.resource.resource(), lowUtilStr, meanUtilStr, balanceLowerThresholdStr, balanceUpperThresholdStr);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceValueThresholds that = (ResourceValueThresholds)o;
            return Double.compare(that.balanceUpperValueThreshold, this.balanceUpperValueThreshold) == 0 && Double.compare(that.balanceLowerValueThreshold, this.balanceLowerValueThreshold) == 0 && Double.compare(that.lowUtilizationValueThreshold, this.lowUtilizationValueThreshold) == 0 && Double.compare(that.meanUtilizationValueThreshold, this.meanUtilizationValueThreshold) == 0 && this.resource == that.resource;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.balanceUpperValueThreshold, this.balanceLowerValueThreshold, this.lowUtilizationValueThreshold, this.meanUtilizationValueThreshold, this.resource});
        }
    }
}

