/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals.thresholds;

import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;

public final class DistributionThresholdUtils {
    public static double validateRatio(double ratioValue, String name) {
        if (ratioValue < 0.0 || ratioValue > 1.0) {
            throw new IllegalArgumentException(String.format("An invalid value %f was supplied for %s. Must be within the range 0.0-1.0.", ratioValue, name));
        }
        return ratioValue;
    }

    public static double balancePercentage(OptimizationOptions optimizationOptions, BalancingConstraint balancingConstraint, Resource resource) {
        return DistributionThresholdUtils.balancePercentage(optimizationOptions, balancingConstraint, balancingConstraint.resourceBalancePercentage(resource));
    }

    public static double balancePercentage(OptimizationOptions optimizationOptions, BalancingConstraint balancingConstraint, double resourceBalancePercentage) {
        double multiplier = optimizationOptions.isTriggeredByGoalViolation() ? balancingConstraint.goalViolationDistributionThresholdMultiplier() : 1.0;
        double balancePercentage = resourceBalancePercentage * multiplier;
        return balancePercentage - 1.0;
    }

    public static double clusterUtilizationAverage(ClusterModel clusterModel, Resource resource) {
        return clusterModel.expectedUtilizationInEligibleSourceBrokersFor(resource) / clusterModel.eligibleDestinationCapacityFor(resource);
    }

    public static double computeBalanceRelativeUpperThresholdPercentage(double utilizationPercentage, OptimizationOptions optimizationOptions, BalancingConstraint balancingConstraint, Resource resource) {
        return Math.min(1.0, utilizationPercentage * (1.0 + DistributionThresholdUtils.balancePercentage(optimizationOptions, balancingConstraint, resource)));
    }

    public static double computeBalanceAbsoluteUpperThresholdPercentage(double utilizationPercentage, OptimizationOptions optimizationOptions, BalancingConstraint balancingConstraint, Resource resource) {
        return Math.min(1.0, utilizationPercentage + DistributionThresholdUtils.balancePercentage(optimizationOptions, balancingConstraint, resource));
    }

    public static double computeBalanceRelativeLowerThresholdPercentage(double utilizationPercentage, OptimizationOptions optimizationOptions, BalancingConstraint balancingConstraint, Resource resource) {
        return utilizationPercentage * Math.max(0.0, 1.0 - DistributionThresholdUtils.balancePercentage(optimizationOptions, balancingConstraint, resource));
    }

    public static double computeBalanceAbsoluteLowerThresholdPercentage(double utilizationPercentage, OptimizationOptions optimizationOptions, BalancingConstraint balancingConstraint, Resource resource) {
        return Math.max(0.0, utilizationPercentage - DistributionThresholdUtils.balancePercentage(optimizationOptions, balancingConstraint, resource));
    }
}

