/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals.thresholds;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.thresholds.DistributionThresholdUtils;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import java.util.Objects;

public final class ResourceUtilizationRatioThresholds {
    private final double balanceUpperThreshold;
    private final double balanceLowerThreshold;
    private final double meanUtilizationRatio;
    private final double lowUtilizationRatio;
    private final Resource resource;

    private ResourceUtilizationRatioThresholds(double balanceUpperThreshold, double balanceLowerThreshold, double meanUtilizationRatio, double lowUtilizationRatio, Resource resource) {
        this.balanceUpperThreshold = balanceUpperThreshold;
        this.balanceLowerThreshold = balanceLowerThreshold;
        this.meanUtilizationRatio = meanUtilizationRatio;
        this.lowUtilizationRatio = lowUtilizationRatio;
        this.resource = resource;
    }

    public static ResourceUtilizationRatioThresholds create(double balanceUpperThreshold, double balanceLowerThreshold, double meanUtilizationRatio, double lowUtilizationRatio, Resource resource, boolean needValidation) {
        return new ResourceUtilizationRatioThresholds(needValidation ? DistributionThresholdUtils.validateRatio(balanceUpperThreshold, "balance upper percentage") : balanceUpperThreshold, needValidation ? DistributionThresholdUtils.validateRatio(balanceLowerThreshold, "balance lower percentage") : balanceLowerThreshold, needValidation ? DistributionThresholdUtils.validateRatio(meanUtilizationRatio, "mean utilization percentage") : meanUtilizationRatio, needValidation ? DistributionThresholdUtils.validateRatio(lowUtilizationRatio, "low utilization percentage") : lowUtilizationRatio, resource);
    }

    public double balanceUpperThreshold() {
        return this.balanceUpperThreshold;
    }

    public double balanceLowerThreshold() {
        return this.balanceLowerThreshold;
    }

    public double meanUtilizationRatio() {
        return this.meanUtilizationRatio;
    }

    public double lowUtilizationRatio() {
        return this.lowUtilizationRatio;
    }

    public Resource resource() {
        return this.resource;
    }

    public String toString() {
        String lowUtilStr = String.format("%.2f", this.lowUtilizationRatio * 100.0) + "%";
        String meanUtilStr = String.format("%.2f", this.meanUtilizationRatio * 100.0) + "%";
        String balanceLowerThresholdStr = String.format("%.2f", this.balanceLowerThreshold * 100.0) + "%";
        String balanceUpperThresholdStr = String.format("%.2f", this.balanceUpperThreshold * 100.0) + "%";
        return String.format("Resource Percentage Thresholds for %s - low utilization %s, mean utilization - %s, lower and upper limits - %s and %s", this.resource.resource(), lowUtilStr, meanUtilStr, balanceLowerThresholdStr, balanceUpperThresholdStr);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceUtilizationRatioThresholds that = (ResourceUtilizationRatioThresholds)o;
        return Double.compare(that.balanceUpperThreshold(), this.balanceUpperThreshold) == 0 && Double.compare(that.balanceLowerThreshold(), this.balanceLowerThreshold) == 0 && Double.compare(that.lowUtilizationRatio(), this.lowUtilizationRatio) == 0 && Double.compare(that.meanUtilizationRatio(), this.meanUtilizationRatio) == 0 && this.resource == that.resource();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.balanceUpperThreshold, this.balanceLowerThreshold, this.lowUtilizationRatio, this.meanUtilizationRatio, this.resource});
    }
}

