/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.async.progress;

import com.linkedin.kafka.cruisecontrol.async.progress.OperationStep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class OperationProgress {
    private static final String STEP = "step";
    private static final String DESCRIPTION = "description";
    private static final String TIME_IN_MS = "time-in-ms";
    private static final String COMPLETION_PERCENTAGE = "completionPercentage";
    private boolean mutable = true;
    private List<OperationStep> steps = new ArrayList<OperationStep>();
    private List<Long> startTimes = new ArrayList<Long>();

    public synchronized void addStep(OperationStep step) {
        this.ensureMutable();
        this.steps.add(step);
        this.startTimes.add(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refer(OperationProgress other) {
        List<Long> startTimes;
        List<OperationStep> steps;
        OperationProgress operationProgress = other;
        synchronized (operationProgress) {
            steps = other.steps;
            startTimes = other.startTimes;
        }
        operationProgress = this;
        synchronized (operationProgress) {
            this.ensureMutable();
            this.steps = steps;
            this.startTimes = startTimes;
            this.mutable = false;
        }
    }

    public synchronized List<OperationStep> progress() {
        return Collections.unmodifiableList(this.steps);
    }

    public synchronized void clear() {
        this.mutable = true;
        this.steps.clear();
        this.startTimes.clear();
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.steps.size(); ++i) {
            OperationStep step = this.steps.get(i);
            long time = (i == this.steps.size() - 1 ? System.currentTimeMillis() : this.startTimes.get(i + 1)) - this.startTimes.get(i);
            sb.append(String.format("(%6d ms) - (%3.1f%%) %s: %s%n", time, Float.valueOf(step.completionPercentage() * 100.0f), step.name(), step.description()));
        }
        return sb.toString();
    }

    public synchronized Object[] getJsonArray() {
        Object[] progressArray = new Object[this.steps.size()];
        for (int i = 0; i < this.steps.size(); ++i) {
            OperationStep step = this.steps.get(i);
            long time = (i == this.steps.size() - 1 ? System.currentTimeMillis() : this.startTimes.get(i + 1)) - this.startTimes.get(i);
            HashMap<String, Object> stepProgressMap = new HashMap<String, Object>();
            stepProgressMap.put(STEP, step.name());
            stepProgressMap.put(DESCRIPTION, step.description());
            stepProgressMap.put(TIME_IN_MS, time);
            stepProgressMap.put(COMPLETION_PERCENTAGE, (double)step.completionPercentage() * 100.0);
            progressArray[i] = stepProgressMap;
        }
        return progressArray;
    }

    private void ensureMutable() {
        if (!this.mutable) {
            throw new IllegalStateException("Cannot change this operation progress because it is immutable.");
        }
    }
}

