/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.common;

import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.detector.utils.TenantResourceUtils;
import com.linkedin.kafka.cruisecontrol.model.Tenant;
import com.linkedin.kafka.cruisecontrol.model.TenantResource;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Optional;

public enum CellResource {
    CPU(0, Resource.CPU),
    NW_IN(1, Resource.NW_IN),
    NW_OUT(2, Resource.NW_OUT),
    PRODUCE_IN(3, Resource.PRODUCE_IN),
    CONSUME_OUT(4, Resource.CONSUME_OUT),
    REPLICA_COUNT(5, null);

    private static final Collection<CellResource> CACHED_VALUES;
    private final int id;
    private final Resource resource;
    private final Comparator<Tenant> globalTenantResourceUtilComparator;

    private CellResource(int id, Resource resource) {
        this.id = id;
        this.resource = resource;
        this.globalTenantResourceUtilComparator = TenantResourceUtils.getResourceComparator(resource);
    }

    public static Collection<CellResource> cachedValues() {
        return CACHED_VALUES;
    }

    public int id() {
        return this.id;
    }

    public Resource resource() {
        return this.resource;
    }

    public Comparator<Tenant> tenantResourceUtilComparator() {
        return this.globalTenantResourceUtilComparator;
    }

    public Comparator<Tenant> tenantResourceUtilComparator(int cellId) {
        return TenantResourceUtils.getResourceComparator(cellId, this.resource);
    }

    public static Optional<CellResource> fromTenantResource(TenantResource tenantResource) {
        if (tenantResource == null) {
            return Optional.empty();
        }
        return CACHED_VALUES.stream().filter(cellResource -> cellResource.resource() != null && cellResource.resource().name().equals(tenantResource.name())).findFirst();
    }

    static {
        CACHED_VALUES = Collections.unmodifiableSet(EnumSet.allOf(CellResource.class));
    }
}

