/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.config;

import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.config.BrokerCapacityInfo;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public interface ClusterBrokerCapacityConfigResolver {
    public void mergeCapacitiesForBrokers(Map<Broker, Map<Resource, Double>> var1);

    public Map<Broker, BrokerCapacityInfo> capacitiesForBrokers(List<Broker> var1);

    public static class Broker {
        private final String rack;
        private final String host;
        private final int brokerId;

        public Broker(String rack, String host, int brokerId) {
            this.rack = rack;
            this.host = host;
            this.brokerId = brokerId;
        }

        public String rack() {
            return this.rack;
        }

        public String host() {
            return this.host;
        }

        public int brokerId() {
            return this.brokerId;
        }

        public String toString() {
            return String.format("Broker{Rack=%s, Host=%s, Id=%d}", this.rack, this.host, this.brokerId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Broker broker = (Broker)o;
            return this.brokerId == broker.brokerId && Objects.equals(this.rack, broker.rack) && Objects.equals(this.host, broker.host);
        }

        public int hashCode() {
            return Objects.hash(this.brokerId, this.rack, this.host);
        }
    }
}

