/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.cruisecontrol.detector.Anomaly;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyDetector;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyDetectorUtils;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyState;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyStats;
import com.linkedin.kafka.cruisecontrol.detector.BrokerFailures;
import com.linkedin.kafka.cruisecontrol.detector.CellOverload;
import com.linkedin.kafka.cruisecontrol.detector.GoalViolations;
import com.linkedin.kafka.cruisecontrol.detector.SelfHealingState;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyType;
import com.yammer.metrics.core.Meter;
import io.confluent.databalancer.metrics.GeneralSBCMetricsRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnomalyDetectorState {
    private static final Logger LOG = LoggerFactory.getLogger(AnomalyDetectorState.class);
    private static final String DETECTION_DATE = "detectionDate";
    private static final String ANOMALY_ID = "anomalyId";
    private static final String STATUS = "status";
    private static final String STATUS_UPDATE_DATE = "statusUpdateDate";
    private static final String FIXABLE_VIOLATED_GOALS = "fixableViolatedGoals";
    private static final String UNFIXABLE_VIOLATED_GOALS = "unfixableViolatedGoals";
    private static final String FAILED_BROKERS_BY_TIME_MS = "failedBrokersByTimeMs";
    private static final String TENANT_PROPOSALS_TO_EXECUTE = "tenantProposalsToExecute";
    private static final String SELF_HEALING_ENABLED = "selfHealingEnabled";
    private static final String SELF_HEALING_DISABLED = "selfHealingDisabled";
    private static final String RECENT_GOAL_VIOLATIONS = "recentGoalViolations";
    private static final String RECENT_BROKER_FAILURES = "recentBrokerFailures";
    private static final String RECENT_CELL_OVERLOAD = "recentCellOverload";
    private static final String ONGOING_SELF_HEALING_ANOMALY = "ongoingSelfHealingAnomaly";
    private static final String OPTIMIZATION_RESULT = "optimizationResult";
    private static final String METRICS = "metrics";
    private static final String MEAN_TIME_BETWEEN_ANOMALIES_MS = "meanTimeBetweenAnomaliesMs";
    private static final String MEAN_TIME_TO_START_FIX_MS = "meanTimeToStartFixMs";
    private static final String BALANCEDNESS_SCORE = "balancednessScore";
    static final String SELF_HEALING_ENABLED_METRIC_NAME = "self-healing-enabled";
    static final String SELF_HEALING_ENABLED_METRIC_TYPE_TAG = "anomaly-type";
    static final String BROKER_FAILURE_RATE_METRIC_NAME = "broker-failure-rate";
    static final String GOAL_VIOLATION_RATE_METRIC_NAME = "goal-violation-rate";
    static final String CELL_OVERLOAD_RATE_METRIC_NAME = "cell-overload-rate";
    static final String SELF_HEALING_STARTED_COUNT_METRIC_NAME = "number-of-self-healing-started";
    static final String SELF_HEALING_ERROR_COUNT_METRIC_NAME = "number-of-self-healing-errors";
    static final String SELF_HEALING_MEAN_START_TIME_METRIC_NAME = "mean-time-to-start-fix-ms";
    static final String NUM_SELF_HEALING_STARTED = "numSelfHealingStarted";
    private static final String ONGOING_ANOMALY_DURATION_MS = "ongoingAnomalyDurationMs";
    private static final long NO_ONGOING_ANOMALY_FLAG = -1L;
    private final Map<AnomalyType, Map<String, AnomalyState>> recentAnomaliesByType;
    private Anomaly ongoingSelfHealingAnomaly;
    private final SelfHealingState selfHealingState;
    private final int numCachedRecentAnomalyStates;
    private AnomalyStats anomalyStats;
    private volatile long ongoingAnomalyDetectionTimeMs;
    private long ongoingAnomalyCount;
    private double ongoingAnomalyDurationSumForAverageMs;
    private final Time time;
    private AtomicLong numSelfHealingStarted;
    private final AtomicLong numSelfHealingErrors;
    private final Map<AnomalyType, Meter> anomalyTypeMeterMap;
    private double balancednessScore;

    public AnomalyDetectorState(Time time, SelfHealingState selfHealingState, int numCachedRecentAnomalyStates, GeneralSBCMetricsRegistry metricRegistry) {
        this.time = time;
        this.numCachedRecentAnomalyStates = numCachedRecentAnomalyStates;
        this.recentAnomaliesByType = new HashMap<AnomalyType, Map<String, AnomalyState>>(AnomalyType.cachedValues().size());
        for (AnomalyType anomalyType : AnomalyType.cachedValues()) {
            this.recentAnomaliesByType.put(anomalyType, (Map<String, AnomalyState>)new LinkedHashMap<String, AnomalyState>(){

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, AnomalyState> eldest) {
                    return this.size() > AnomalyDetectorState.this.numCachedRecentAnomalyStates;
                }
            });
        }
        this.selfHealingState = selfHealingState;
        this.ongoingSelfHealingAnomaly = null;
        this.ongoingAnomalyDetectionTimeMs = -1L;
        this.ongoingAnomalyCount = 0L;
        this.ongoingAnomalyDurationSumForAverageMs = 0.0;
        this.numSelfHealingStarted = new AtomicLong(0L);
        this.numSelfHealingErrors = new AtomicLong(0L);
        HashMap<AnomalyType, Double> meanTimeBetweenAnomaliesMs = new HashMap<AnomalyType, Double>(AnomalyType.cachedValues().size());
        for (AnomalyType anomalyType : AnomalyType.cachedValues()) {
            meanTimeBetweenAnomaliesMs.put(anomalyType, 0.0);
        }
        this.anomalyStats = new AnomalyStats(meanTimeBetweenAnomaliesMs, 0.0, 0L, 0L);
        this.anomalyTypeMeterMap = this.registerAllAnomalyDetectorMetrics(metricRegistry);
    }

    private Map<AnomalyType, Meter> registerAllAnomalyDetectorMetrics(GeneralSBCMetricsRegistry metricRegistry) {
        HashMap<AnomalyType, Meter> typeMeterMap = new HashMap<AnomalyType, Meter>(AnomalyType.cachedValues().size());
        if (metricRegistry != null) {
            metricRegistry.newGauge(AnomalyDetector.class, SELF_HEALING_MEAN_START_TIME_METRIC_NAME, this::meanTimeToStartFixMs);
            metricRegistry.newGauge(AnomalyDetector.class, SELF_HEALING_STARTED_COUNT_METRIC_NAME, this::numSelfHealingStarted);
            metricRegistry.newGauge(AnomalyDetector.class, SELF_HEALING_ERROR_COUNT_METRIC_NAME, this::numSelfHealingErrors);
            this.registerTypeEnabledMetric(metricRegistry, AnomalyType.GOAL_VIOLATION);
            this.registerTypeEnabledMetric(metricRegistry, AnomalyType.BROKER_FAILURE);
            this.registerTypeEnabledMetric(metricRegistry, AnomalyType.CELL_OVERLOAD);
            typeMeterMap.put(AnomalyType.BROKER_FAILURE, metricRegistry.newMeter(AnomalyDetector.class, BROKER_FAILURE_RATE_METRIC_NAME, "broker-failures", TimeUnit.SECONDS));
            typeMeterMap.put(AnomalyType.GOAL_VIOLATION, metricRegistry.newMeter(AnomalyDetector.class, GOAL_VIOLATION_RATE_METRIC_NAME, "goal-violations", TimeUnit.SECONDS));
            typeMeterMap.put(AnomalyType.CELL_OVERLOAD, metricRegistry.newMeter(AnomalyDetector.class, CELL_OVERLOAD_RATE_METRIC_NAME, "cell-overload", TimeUnit.SECONDS));
        } else {
            AnomalyType.cachedValues().forEach(anomalyType -> typeMeterMap.put((AnomalyType)((Object)anomalyType), (Meter)null));
        }
        return typeMeterMap;
    }

    private void registerTypeEnabledMetric(GeneralSBCMetricsRegistry metricRegistry, AnomalyType anomalyType) {
        Map<String, String> selfHealingEnabledTags = Collections.singletonMap(SELF_HEALING_ENABLED_METRIC_TYPE_TAG, anomalyType.name());
        metricRegistry.newGauge(AnomalyDetector.class, SELF_HEALING_ENABLED_METRIC_NAME, () -> this.selfHealingEnabledStatus(anomalyType) ? 1 : 0, selfHealingEnabledTags);
    }

    void markAnomalyRate(AnomalyType anomalyType) {
        Meter m = this.anomalyTypeMeterMap.get((Object)anomalyType);
        if (m != null) {
            m.mark();
        }
    }

    synchronized void refreshMetrics(double balancednessScore) {
        HashMap<AnomalyType, Double> meanTimeBetweenAnomaliesMs = new HashMap<AnomalyType, Double>(AnomalyType.cachedValues().size());
        Iterator<AnomalyType> iterator = AnomalyType.cachedValues().iterator();
        while (iterator.hasNext()) {
            AnomalyType anomalyType;
            Meter m = this.anomalyTypeMeterMap.get((Object)(anomalyType = iterator.next()));
            meanTimeBetweenAnomaliesMs.put(anomalyType, m == null ? 0.0 : m.meanRate() * 1000.0);
        }
        this.anomalyStats = new AnomalyStats(meanTimeBetweenAnomaliesMs, this.meanTimeToStartFixMs(), this.numSelfHealingStarted.get(), this.ongoingAnomalyDurationMs());
        this.balancednessScore = balancednessScore;
    }

    private long ongoingAnomalyDurationMs() {
        return this.ongoingAnomalyDetectionTimeMs != -1L ? this.time.milliseconds() - this.ongoingAnomalyDetectionTimeMs : 0L;
    }

    private double meanTimeToStartFixMs() {
        long fixedAnomalyDurations = this.ongoingAnomalyDetectionTimeMs == -1L ? this.ongoingAnomalyCount : this.ongoingAnomalyCount - 1L;
        return fixedAnomalyDurations == 0L ? 0.0 : this.ongoingAnomalyDurationSumForAverageMs / (double)fixedAnomalyDurations;
    }

    synchronized void maybeClearOngoingAnomalyDetectionTimeMs() {
        if (this.ongoingAnomalyDetectionTimeMs != -1L) {
            double elapsed = this.time.milliseconds() - this.ongoingAnomalyDetectionTimeMs;
            this.ongoingAnomalyDurationSumForAverageMs += elapsed;
            this.ongoingAnomalyDetectionTimeMs = -1L;
        }
    }

    synchronized void maybeSetOngoingAnomalyDetectionTimeMs() {
        if (this.ongoingAnomalyDetectionTimeMs == -1L) {
            this.ongoingAnomalyDetectionTimeMs = this.time.milliseconds();
            ++this.ongoingAnomalyCount;
        }
    }

    final long numSelfHealingStarted() {
        return this.numSelfHealingStarted.get();
    }

    void incrementNumSelfHealingStarted() {
        this.numSelfHealingStarted.incrementAndGet();
    }

    final long numSelfHealingErrors() {
        return this.numSelfHealingErrors.get();
    }

    void incrementNumSelfHealingErrors() {
        this.numSelfHealingErrors.incrementAndGet();
    }

    Anomaly ongoingSelfHealingAnomaly() {
        return this.ongoingSelfHealingAnomaly;
    }

    Map<String, Object> anomalyStats() {
        HashMap<String, Object> stats = new HashMap<String, Object>(4);
        stats.put(MEAN_TIME_BETWEEN_ANOMALIES_MS, this.anomalyStats.meanTimeBetweenAnomaliesMs());
        stats.put(MEAN_TIME_TO_START_FIX_MS, this.anomalyStats.meanTimeToStartFixMs());
        stats.put(NUM_SELF_HEALING_STARTED, this.anomalyStats.numSelfHealingStarted());
        stats.put(ONGOING_ANOMALY_DURATION_MS, this.anomalyStats.ongoingAnomalyDurationMs());
        return stats;
    }

    public synchronized void markSelfHealingFinished(String anomalyId) {
        if (this.ongoingSelfHealingAnomaly == null || !this.ongoingSelfHealingAnomaly.anomalyId().equals(anomalyId)) {
            LOG.warn("Anomaly {} is not the current anomaly being handled, ignoring.", (Object)anomalyId);
            return;
        }
        this.ongoingSelfHealingAnomaly = null;
    }

    void addAnomalyDetection(AnomalyType anomalyType, Anomaly anomaly) {
        this.recentAnomaliesByType.get((Object)anomalyType).put(anomaly.anomalyId(), new AnomalyState(anomaly));
    }

    synchronized void onAnomalyHandle(Anomaly anomaly, AnomalyState.Status status) {
        AnomalyState recentAnomalyState;
        AnomalyType anomalyType = AnomalyDetectorUtils.getAnomalyType(anomaly);
        String anomalyId = anomaly.anomalyId();
        if (status == AnomalyState.Status.ATTEMPTING_FIX) {
            this.ongoingSelfHealingAnomaly = anomaly;
        }
        if ((recentAnomalyState = this.recentAnomaliesByType.get((Object)anomalyType).get(anomalyId)) != null) {
            recentAnomalyState.setStatus(status);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Anomaly (type: {}, anomalyId: {}) is no longer in the anomaly detector state cache.", (Object)anomalyType, (Object)anomalyId);
        }
    }

    public synchronized void setSelfHealingFor(AnomalyType anomalyType, boolean isSelfHealingEnabled) {
        this.selfHealingState.setSelfHealingFor(anomalyType, isSelfHealingEnabled);
    }

    public synchronized boolean getSelfHealingFor(AnomalyType anomalyType) {
        return this.selfHealingState.isSelfHealingEnabled(anomalyType);
    }

    public SelfHealingState selfHealingState() {
        return this.selfHealingState;
    }

    private static Map<String, Object> populateAnomalyDetails(AnomalyState anomalyState, AnomalyType anomalyType, boolean hasFixStarted) {
        HashMap<String, Object> anomalyDetails = new HashMap<String, Object>((hasFixStarted ? 6 : 5) + (anomalyType == AnomalyType.GOAL_VIOLATION ? 1 : 0));
        anomalyDetails.put(DETECTION_DATE, KafkaCruiseControlUtils.utcDateFor(anomalyState.detectionMs()));
        anomalyDetails.put(STATUS, (Object)anomalyState.status());
        anomalyDetails.put(ANOMALY_ID, anomalyState.anomalyId());
        anomalyDetails.put(STATUS_UPDATE_DATE, KafkaCruiseControlUtils.utcDateFor(anomalyState.statusUpdateMs()));
        switch (anomalyType) {
            case GOAL_VIOLATION: {
                GoalViolations goalViolations = (GoalViolations)anomalyState.anomaly();
                Map<Boolean, List<GoalViolations.GoalResult>> violatedGoalsByFixability = goalViolations.violatedGoalsByFixability();
                anomalyDetails.put(FIXABLE_VIOLATED_GOALS, violatedGoalsByFixability.getOrDefault(true, Collections.emptyList()).stream().map(g -> g.name));
                anomalyDetails.put(UNFIXABLE_VIOLATED_GOALS, violatedGoalsByFixability.getOrDefault(false, Collections.emptyList()).stream().map(g -> g.name));
                if (!hasFixStarted) break;
                anomalyDetails.put(OPTIMIZATION_RESULT, goalViolations.optimizationResultSummary());
                break;
            }
            case BROKER_FAILURE: {
                BrokerFailures brokerFailures = (BrokerFailures)anomalyState.anomaly();
                anomalyDetails.put(FAILED_BROKERS_BY_TIME_MS, brokerFailures.failedBrokers());
                if (!hasFixStarted) break;
                anomalyDetails.put(OPTIMIZATION_RESULT, brokerFailures.optimizationResultSummary());
                break;
            }
            case CELL_OVERLOAD: {
                CellOverload cellOverload = (CellOverload)anomalyState.anomaly();
                anomalyDetails.put(TENANT_PROPOSALS_TO_EXECUTE, cellOverload.cellOverloadPlans().stream().flatMap(cellOverloadPlan -> cellOverloadPlan.tenantProposals().stream()).collect(Collectors.toList()));
                if (!hasFixStarted) break;
                anomalyDetails.put(OPTIMIZATION_RESULT, cellOverload.optimizationResultSummary());
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized anomaly type " + String.valueOf((Object)anomalyType));
            }
        }
        return anomalyDetails;
    }

    Map<AnomalyType, Map<String, AnomalyState>> recentAnomaliesByType() {
        return this.recentAnomaliesByType;
    }

    private Set<Map<String, Object>> recentAnomalies(AnomalyType anomalyType) {
        Map<String, AnomalyState> anomaliesById = this.recentAnomaliesByType.get((Object)anomalyType);
        HashSet<Map<String, Object>> recentAnomalies = new HashSet<Map<String, Object>>(this.numCachedRecentAnomalyStates);
        for (Map.Entry<String, AnomalyState> entry : anomaliesById.entrySet()) {
            recentAnomalies.add(AnomalyDetectorState.populateAnomalyDetails(entry.getValue(), anomalyType, false));
        }
        return recentAnomalies;
    }

    private boolean selfHealingEnabledStatus(AnomalyType anomalyType) {
        return this.selfHealingState.isSelfHealingEnabled(anomalyType);
    }

    public synchronized String toString() {
        Set enabledSelfHealingTypes = AnomalyType.cachedValues().stream().filter(this::selfHealingEnabledStatus).map(Enum::name).collect(Collectors.toSet());
        Set disabledSelfHealingTypes = AnomalyType.cachedValues().stream().filter(t -> !this.selfHealingEnabledStatus((AnomalyType)((Object)t))).map(Enum::name).collect(Collectors.toSet());
        return String.format("{%s:%s, %s:%s, %s:%s, %s:%s, %s:%s, %s:%s, %s:%s, %s:%.3f}%n", SELF_HEALING_ENABLED, enabledSelfHealingTypes, SELF_HEALING_DISABLED, disabledSelfHealingTypes, RECENT_GOAL_VIOLATIONS, this.recentAnomalies(AnomalyType.GOAL_VIOLATION), RECENT_BROKER_FAILURES, this.recentAnomalies(AnomalyType.BROKER_FAILURE), RECENT_CELL_OVERLOAD, this.recentAnomalies(AnomalyType.CELL_OVERLOAD), METRICS, this.anomalyStats, ONGOING_SELF_HEALING_ANOMALY, this.ongoingSelfHealingAnomaly == null ? "None" : this.ongoingSelfHealingAnomaly.anomalyId(), BALANCEDNESS_SCORE, this.balancednessScore);
    }
}

