/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import java.util.Deque;
import java.util.LinkedList;
import org.apache.commons.math3.util.Pair;

public class ResourceUtilizationWindow {
    private final Deque<Pair<Long, Float>> values = new LinkedList<Pair<Long, Float>>();
    private float totalValue = 0.0f;

    public void addValue(long timestamp, double value) {
        this.values.addLast((Pair<Long, Float>)new Pair((Object)timestamp, (Object)Float.valueOf((float)value)));
        this.totalValue += (float)value;
    }

    public void deleteExpiredValues(long now, int durationMs) {
        while (this.length(now) > (long)durationMs) {
            float deleteValue = ((Float)this.values.removeFirst().getValue()).floatValue();
            this.totalValue -= deleteValue;
        }
    }

    public void clear() {
        this.values.clear();
        this.totalValue = 0.0f;
    }

    public double avg() {
        if (this.values.isEmpty()) {
            return 0.0;
        }
        return this.totalValue / (float)this.values.size();
    }

    public long length(long now) {
        if (this.values.isEmpty()) {
            return 0L;
        }
        return now - (Long)this.values.peekFirst().getKey();
    }

    public double sum() {
        return this.totalValue;
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }
}

