/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector.factory;

import com.linkedin.cruisecontrol.detector.Anomaly;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlOperationMetricsTracker;
import com.linkedin.kafka.cruisecontrol.config.ConfigSupplier;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.config.UpdatableSbcConfig;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyHistoryChecker;
import com.linkedin.kafka.cruisecontrol.detector.BrokerAdditionDetector;
import com.linkedin.kafka.cruisecontrol.detector.BrokerAdditionDetectorWithTopicDistribution;
import com.linkedin.kafka.cruisecontrol.detector.CellOverloadDetector;
import com.linkedin.kafka.cruisecontrol.detector.ResourceUtilisationDetectorType;
import com.linkedin.kafka.cruisecontrol.detector.ResourceUtilizationDetector;
import com.linkedin.kafka.cruisecontrol.detector.tenantstriping.TenantAutoScaler;
import com.linkedin.kafka.cruisecontrol.detector.utils.CellOverloadOccurrenceRecorder;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorInsightsChecker;
import io.confluent.databalancer.metrics.CellOverloadMetrics;
import io.confluent.databalancer.metrics.GeneralSBCMetricsRegistry;
import io.confluent.databalancer.metrics.internals.TenantUtilizationMetricHandler;
import io.confluent.databalancer.operation.BrokerAdditionV2StateManager;
import io.confluent.databalancer.persistence.ApiStatePersistenceStore;
import io.confluent.kafka.clients.CloudAdmin;
import java.util.LinkedHashMap;
import java.util.Queue;
import java.util.function.Supplier;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtilizationDetectorBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceUtilizationDetectorBuilder.class);
    private ApiStatePersistenceStore persistenceStore;
    private BrokerAdditionV2StateManager brokerAdditionV2StateManager;
    private CloudAdmin adminClient;
    private GeneralSBCMetricsRegistry metricsRegistry;
    private CellOverloadMetrics cellOverloadMetrics;
    private Supplier<Boolean> shouldSkipAnomalyDetectionSupplier;
    private ConfigSupplier configSupplier;
    private KafkaCruiseControlOperationMetricsTracker operationMetricsTracker;
    private UpdatableSbcConfig updatableSbcConfig;
    private Queue<Anomaly> anomalies;
    private Time time;
    private ExecutorInsightsChecker executorInsightsChecker;
    private AnomalyHistoryChecker goalViolationsHistoryChecker;

    public ResourceUtilizationDetectorBuilder persistenceStore(ApiStatePersistenceStore persistenceStore) {
        this.persistenceStore = persistenceStore;
        return this;
    }

    public ResourceUtilizationDetectorBuilder brokerAdditionV2StateManager(BrokerAdditionV2StateManager brokerAdditionV2StateManager) {
        this.brokerAdditionV2StateManager = brokerAdditionV2StateManager;
        return this;
    }

    public ResourceUtilizationDetectorBuilder adminClient(CloudAdmin adminClient) {
        this.adminClient = adminClient;
        return this;
    }

    public ResourceUtilizationDetectorBuilder metricsRegistry(GeneralSBCMetricsRegistry metricsRegistry) {
        this.metricsRegistry = metricsRegistry;
        return this;
    }

    public ResourceUtilizationDetectorBuilder cellOverloadMetrics(CellOverloadMetrics cellOverloadMetrics) {
        this.cellOverloadMetrics = cellOverloadMetrics;
        return this;
    }

    public ResourceUtilizationDetectorBuilder shouldSkipAnomalyDetectionSupplier(Supplier<Boolean> shouldSkipAnomalyDetectionSupplier) {
        this.shouldSkipAnomalyDetectionSupplier = shouldSkipAnomalyDetectionSupplier;
        return this;
    }

    public ResourceUtilizationDetectorBuilder configSupplier(ConfigSupplier configSupplier) {
        this.configSupplier = configSupplier;
        return this;
    }

    public ResourceUtilizationDetectorBuilder operationMetricsTracker(KafkaCruiseControlOperationMetricsTracker operationMetricsTracker) {
        this.operationMetricsTracker = operationMetricsTracker;
        return this;
    }

    public ResourceUtilizationDetectorBuilder updatableSbcConfig(UpdatableSbcConfig updatableSbcConfig) {
        this.updatableSbcConfig = updatableSbcConfig;
        return this;
    }

    public ResourceUtilizationDetectorBuilder anomalies(Queue<Anomaly> anomalies) {
        this.anomalies = anomalies;
        return this;
    }

    public ResourceUtilizationDetectorBuilder time(Time time) {
        this.time = time;
        return this;
    }

    public ResourceUtilizationDetectorBuilder executorInsightsChecker(ExecutorInsightsChecker executorInsightsChecker) {
        this.executorInsightsChecker = executorInsightsChecker;
        return this;
    }

    public ResourceUtilizationDetectorBuilder goalViolationsHistoryChecker(AnomalyHistoryChecker goalViolationsHistoryChecker) {
        this.goalViolationsHistoryChecker = goalViolationsHistoryChecker;
        return this;
    }

    public LinkedHashMap<ResourceUtilisationDetectorType, ResourceUtilizationDetector> buildResourceUtilizationDetectors() {
        LinkedHashMap<ResourceUtilisationDetectorType, ResourceUtilizationDetector> detectors = new LinkedHashMap<ResourceUtilisationDetectorType, ResourceUtilizationDetector>();
        KafkaCruiseControlConfig kccConfig = this.configSupplier.getConfig();
        if (kccConfig.getBoolean("incremental.balancing.enabled").booleanValue() && kccConfig.getBoolean("v2.addition.enabled").booleanValue()) {
            ResourceUtilizationDetector brokerAdditionDetector;
            if (kccConfig.getBoolean("topic.balancing.broker.addition.detector.with.trdg.enabled").booleanValue()) {
                LOG.info("Broker Addition Detector with Topic Distribution is Enabled.");
                brokerAdditionDetector = new BrokerAdditionDetectorWithTopicDistribution(kccConfig, this.time, this.metricsRegistry, this.brokerAdditionV2StateManager, this.operationMetricsTracker, this.updatableSbcConfig.updatableBalancingConstraint(), this.executorInsightsChecker, this.goalViolationsHistoryChecker);
            } else {
                LOG.info("Default Broker Addition Detector is Enabled.");
                brokerAdditionDetector = new BrokerAdditionDetector(kccConfig, this.time, this.metricsRegistry, this.brokerAdditionV2StateManager, this.operationMetricsTracker, this.updatableSbcConfig.updatableBalancingConstraint());
            }
            detectors.put(ResourceUtilisationDetectorType.BROKER_ADDITION_V2_DETECTOR, brokerAdditionDetector);
        }
        if (kccConfig.getBoolean("tenant.striping.enabled").booleanValue()) {
            LOG.info("Automated Tenant Striping is enabled.");
            detectors.put(ResourceUtilisationDetectorType.TENANT_AUTO_SCALER, new TenantAutoScaler(this.adminClient, this.configSupplier, this.time));
        }
        if (kccConfig.getBoolean("confluent.cells.enable").booleanValue()) {
            LOG.info("Cell Overload Detector is {}.", (Object)(kccConfig.getBoolean("inter.cell.balancing.enabled") != false ? "enabled" : "disabled, hence running in dry-run mode."));
            CellOverloadOccurrenceRecorder cellOverloadOccurrenceRecorder = new CellOverloadOccurrenceRecorder(this.persistenceStore);
            TenantUtilizationMetricHandler tenantUtilizationMetricHandler = new TenantUtilizationMetricHandler(kccConfig, this.cellOverloadMetrics);
            CellOverloadDetector cellOverloadDetector = new CellOverloadDetector(this.configSupplier, this.adminClient, this.shouldSkipAnomalyDetectionSupplier, this.anomalies, cellOverloadOccurrenceRecorder, this.cellOverloadMetrics, tenantUtilizationMetricHandler, this.time);
            detectors.put(ResourceUtilisationDetectorType.CELL_OVERLOAD_DETECTOR, cellOverloadDetector);
        }
        return detectors;
    }
}

