/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector.notifier;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.detector.BrokerFailures;
import com.linkedin.kafka.cruisecontrol.detector.CellOverload;
import com.linkedin.kafka.cruisecontrol.detector.GoalViolations;
import com.linkedin.kafka.cruisecontrol.detector.SelfHealingState;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyNotificationResult;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyType;
import io.confluent.databalancer.operation.BrokerAdditionV2StateManager;
import io.confluent.databalancer.operation.V2AdditionChecker;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfHealingNotifier
implements SelfHealingState {
    private static final Logger LOG = LoggerFactory.getLogger(SelfHealingNotifier.class);
    protected final Time time;
    protected final Map<AnomalyType, Boolean> selfHealingEnabled;
    protected long brokerFailureAlertThresholdMs;
    protected long selfHealingThresholdMs;
    private final V2AdditionChecker v2BrokerAdditionChecker;

    public SelfHealingNotifier(V2AdditionChecker v2BrokerAdditionChecker, long brokerFailureAlertThresholdMs, long selfHealingThresholdMs, boolean selfHealingBrokerFailureEnabled, boolean selfHealingGoalViolationEnabled, boolean selfHealingCellOverloadEnabled) {
        this(Time.SYSTEM, v2BrokerAdditionChecker, brokerFailureAlertThresholdMs, selfHealingThresholdMs, selfHealingBrokerFailureEnabled, selfHealingGoalViolationEnabled, selfHealingCellOverloadEnabled);
    }

    SelfHealingNotifier(Time time, V2AdditionChecker v2BrokerAdditionChecker, long brokerFailureAlertThresholdMs, long selfHealingThresholdMs, boolean selfHealingBrokerFailureEnabled, boolean selfHealingGoalViolationEnabled, boolean selfHealingCellOverloadEnabled) {
        this.time = time;
        this.v2BrokerAdditionChecker = v2BrokerAdditionChecker;
        this.selfHealingEnabled = new ConcurrentHashMap<AnomalyType, Boolean>(AnomalyType.cachedValues().size());
        this.brokerFailureAlertThresholdMs = brokerFailureAlertThresholdMs;
        this.selfHealingThresholdMs = selfHealingThresholdMs;
        if (brokerFailureAlertThresholdMs > selfHealingThresholdMs) {
            throw new IllegalArgumentException(String.format("The failure detection threshold %d cannot be larger than the auto fix threshold. %d", brokerFailureAlertThresholdMs, selfHealingThresholdMs));
        }
        this.selfHealingEnabled.put(AnomalyType.BROKER_FAILURE, selfHealingBrokerFailureEnabled);
        this.selfHealingEnabled.put(AnomalyType.GOAL_VIOLATION, selfHealingGoalViolationEnabled);
        this.selfHealingEnabled.put(AnomalyType.CELL_OVERLOAD, selfHealingCellOverloadEnabled);
    }

    @Override
    public synchronized boolean isSelfHealingEnabled(AnomalyType at) {
        return this.selfHealingEnabled.getOrDefault((Object)at, false);
    }

    @Override
    public synchronized boolean setSelfHealingFor(AnomalyType anomalyType, boolean isSelfHealingEnabled) {
        Boolean oldValue = this.selfHealingEnabled.put(anomalyType, isSelfHealingEnabled);
        if (oldValue == null) {
            oldValue = false;
        }
        return oldValue;
    }

    public AnomalyNotificationResult onGoalViolation(GoalViolations goalViolations) {
        boolean shouldRunGoalViolation = this.shouldGoalViolationRun();
        if (!shouldRunGoalViolation) {
            return AnomalyNotificationResult.ignore();
        }
        boolean shouldTrigger = !goalViolations.hasUnfixableGoals();
        this.alert(goalViolations, shouldTrigger, System.currentTimeMillis(), AnomalyType.GOAL_VIOLATION);
        if (!shouldTrigger) {
            LOG.warn("Skipping self healing for anomaly {} due to unfixable goals: {}", (Object)AnomalyType.GOAL_VIOLATION, goalViolations.violatedGoalsByFixability().get(false));
            return AnomalyNotificationResult.ignore();
        }
        return AnomalyNotificationResult.fix();
    }

    public AnomalyNotificationResult onBrokerFailure(BrokerFailures brokerFailures) {
        long earliestFailureTimeMs = brokerFailures.failedBrokers().values().stream().mapToLong(t -> t).min().orElse(Long.MAX_VALUE);
        long alertTimeMs = earliestFailureTimeMs + this.brokerFailureAlertThresholdMs;
        long selfHealingTimeMs = earliestFailureTimeMs + this.selfHealingThresholdMs;
        long nowMs = this.time.milliseconds();
        if (nowMs < alertTimeMs) {
            long delayMs = alertTimeMs - nowMs;
            return AnomalyNotificationResult.check(delayMs);
        }
        if (nowMs < selfHealingTimeMs) {
            long delayMs = selfHealingTimeMs - nowMs;
            this.alert(brokerFailures, false, selfHealingTimeMs, AnomalyType.BROKER_FAILURE);
            return AnomalyNotificationResult.check(delayMs);
        }
        boolean autoFixTriggered = this.isSelfHealingEnabled(AnomalyType.BROKER_FAILURE);
        this.alert(brokerFailures, autoFixTriggered, selfHealingTimeMs, AnomalyType.BROKER_FAILURE);
        if (!autoFixTriggered) {
            return AnomalyNotificationResult.ignore();
        }
        return AnomalyNotificationResult.fix();
    }

    public AnomalyNotificationResult onCellOverload(CellOverload cellOverload) {
        boolean shouldRunCellOverload = this.shouldCellOverloadRun();
        if (!shouldRunCellOverload) {
            return AnomalyNotificationResult.ignore();
        }
        this.alert(cellOverload, true, System.currentTimeMillis(), AnomalyType.CELL_OVERLOAD);
        return AnomalyNotificationResult.fix();
    }

    public void alert(Object anomaly, boolean autoFixTriggered, long selfHealingStartTime, AnomalyType anomalyType) {
        LOG.debug("{} detected {}. Self healing {}.", new Object[]{anomalyType, anomaly, this.isSelfHealingEnabled(anomalyType) ? String.format("start time %s", KafkaCruiseControlUtils.toDateString(selfHealingStartTime)) : "is disabled"});
        if (autoFixTriggered) {
            LOG.info("Self-healing for anomaly {} has been triggered.", (Object)anomalyType);
        }
    }

    private boolean shouldGoalViolationRun() {
        List<BrokerAdditionV2StateManager.PendingAddition> pendingAdditions;
        boolean isSelfHealingEnabled = this.isSelfHealingEnabled(AnomalyType.GOAL_VIOLATION);
        if (!isSelfHealingEnabled && !(pendingAdditions = this.v2BrokerAdditionChecker.pendingBrokerAdditions()).isEmpty()) {
            LOG.info("Self healing for goal violations is disabled but will attempt to run in spite of the setting because there are pending broker additions: {}", pendingAdditions);
            return true;
        }
        return isSelfHealingEnabled;
    }

    private boolean shouldCellOverloadRun() {
        return this.isSelfHealingEnabled(AnomalyType.CELL_OVERLOAD);
    }
}

