/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector.utils;

import com.linkedin.kafka.cruisecontrol.analyzer.AnalyzerUtils;
import com.linkedin.kafka.cruisecontrol.detector.tenantstriping.DesiredStripeFactorCalculator;
import com.linkedin.kafka.cruisecontrol.model.TenantResourceUsage;
import com.linkedin.kafka.cruisecontrol.model.TenantStripingInfo;
import java.util.Comparator;
import java.util.Map;

public class TenantResourceUsageComparator
implements Comparator<TenantResourceUsage> {
    private final Map<String, TenantStripingInfo> stripeFactorMap;
    private final DesiredStripeFactorCalculator desiredStripeFactorCalculator;

    public TenantResourceUsageComparator(Map<String, TenantStripingInfo> stripeFactorMap, DesiredStripeFactorCalculator desiredStripeFactorCalculator) {
        this.stripeFactorMap = stripeFactorMap;
        this.desiredStripeFactorCalculator = desiredStripeFactorCalculator;
    }

    @Override
    public int compare(TenantResourceUsage usage1, TenantResourceUsage usage2) {
        double desiredPerStripeUsage2;
        double diff2Ratio;
        Integer tenant1StripeCount = this.stripeFactorMap.get(usage1.tenantId()).stripeCount();
        Integer tenant2StripeCount = this.stripeFactorMap.get(usage2.tenantId()).stripeCount();
        double perStripeUsage1 = usage1.perStripeUsage(tenant1StripeCount);
        double perStripeUsage2 = usage2.perStripeUsage(tenant2StripeCount);
        double desiredPerStripeUsage1 = this.desiredStripeFactorCalculator.desiredStripeUsage(usage1.tenantResource());
        double diff1Ratio = (perStripeUsage1 - desiredPerStripeUsage1) / desiredPerStripeUsage1;
        return AnalyzerUtils.isSmaller(diff1Ratio, diff2Ratio = (perStripeUsage2 - (desiredPerStripeUsage2 = this.desiredStripeFactorCalculator.desiredStripeUsage(usage2.tenantResource()).doubleValue())) / desiredPerStripeUsage2) ? 1 : -1;
    }
}

