/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector.utils;

import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.model.Tenant;
import java.util.Comparator;
import java.util.function.ToDoubleFunction;

public class TenantResourceUtils {
    private TenantResourceUtils() {
    }

    public static Comparator<Tenant> getResourceComparator(Resource resource) {
        ToDoubleFunction<Tenant> tenantResourceUtilAcrossCells = tenant -> tenant.getResourceUsage(resource);
        return Comparator.comparingDouble(tenantResourceUtilAcrossCells).reversed();
    }

    public static Comparator<Tenant> getResourceComparator(int cellId, Resource resource) {
        ToDoubleFunction<Tenant> tenantResourceUtilAcrossCells = tenant -> tenant.getResourceUsage(cellId, resource);
        return Comparator.comparingDouble(tenantResourceUtilAcrossCells).reversed();
    }
}

