/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.executor;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.executor.BrokerExecutionTaskTracker;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTask;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTaskGenerator;
import com.linkedin.kafka.cruisecontrol.executor.PartitionProposal;
import com.linkedin.kafka.cruisecontrol.executor.TenantProposal;
import com.linkedin.kafka.cruisecontrol.executor.strategy.ReplicaMovementStrategy;
import com.linkedin.kafka.cruisecontrol.model.ReplicaId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionTaskPlanner {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionTaskPlanner.class);
    private final ExecutionTaskGenerator taskGenerator;
    private Map<Integer, SortedSet<ExecutionTask>> interPartMoveTaskByBrokerId;
    private final Map<Long, ExecutionTask> remainingLeadershipMovements;
    private final Map<Long, ExecutionTask> remainingTenantMovements;
    private final ReplicaMovementStrategy defaultReplicaMovementTaskStrategy;
    private final boolean isV2ExecutorEnabled;

    public ExecutionTaskPlanner(List<String> defaultReplicaMovementStrategies, KafkaCruiseControlConfig config) {
        this(new ExecutionTaskGenerator(config), defaultReplicaMovementStrategies, config.getBoolean("v2.executor.enabled"));
    }

    ExecutionTaskPlanner(ExecutionTaskGenerator taskGenerator, List<String> defaultReplicaMovementStrategies, boolean isV2ExecutorEnabled) {
        this.taskGenerator = taskGenerator;
        this.isV2ExecutorEnabled = isV2ExecutorEnabled;
        this.interPartMoveTaskByBrokerId = new HashMap<Integer, SortedSet<ExecutionTask>>();
        this.defaultReplicaMovementTaskStrategy = ReplicaMovementStrategy.generateChainedReplicaMovementStrategies(defaultReplicaMovementStrategies);
        this.remainingLeadershipMovements = new HashMap<Long, ExecutionTask>();
        this.remainingTenantMovements = new HashMap<Long, ExecutionTask>();
    }

    public void addPartitionProposals(Collection<PartitionProposal> proposals, Cluster cluster) {
        LOG.trace("Cluster state before adding proposals: {}.", (Object)cluster);
        this.maybeAddInterBrokerReplicaMovementTasks(proposals, cluster);
        this.maybeAddLeaderChangeTasks(proposals, cluster);
    }

    public void addTenantProposals(Collection<TenantProposal> proposals) {
        Set<ExecutionTask> tenantTasks = this.taskGenerator.generateTenantTasks(proposals);
        tenantTasks.forEach(t -> this.remainingTenantMovements.put(t.executionId(), (ExecutionTask)t));
    }

    private void maybeAddInterBrokerReplicaMovementTasks(Collection<PartitionProposal> proposals, Cluster cluster) {
        Set<ExecutionTask> generatedTasks = this.taskGenerator.generateInterBrokerReplicaMovementTasks(proposals, cluster);
        this.interPartMoveTaskByBrokerId = this.orderInterBrokerReplicaMovementTasks(generatedTasks, cluster);
    }

    public void overrideInterBrokerTasksWithOrdering(Collection<ExecutionTask> tasks, Cluster cluster) {
        if (this.anyRemainingInterBrokerTasks()) {
            throw new IllegalStateException("Cannot re-plan ordering of inter-broker execution tasks while existing inter-broker tasks remain unexecuted as they would be overridden: " + String.valueOf(this.interPartMoveTaskByBrokerId.values()));
        }
        this.interPartMoveTaskByBrokerId = this.orderInterBrokerReplicaMovementTasks(new HashSet<ExecutionTask>(tasks), cluster);
    }

    private void maybeAddLeaderChangeTasks(Collection<PartitionProposal> proposals, Cluster cluster) {
        Set<ExecutionTask> leaderTasks = this.taskGenerator.generateLeaderChangeTasks(proposals, cluster);
        leaderTasks.forEach(t -> this.remainingLeadershipMovements.put(t.executionId(), (ExecutionTask)t));
    }

    public Set<ExecutionTask> remainingInterBrokerReplicaMovements() {
        HashSet<ExecutionTask> pendingExecutionTasks = new HashSet<ExecutionTask>();
        this.interPartMoveTaskByBrokerId.values().forEach(pendingExecutionTasks::addAll);
        return pendingExecutionTasks;
    }

    boolean anyRemainingInterBrokerTasks() {
        return this.interPartMoveTaskByBrokerId.values().stream().anyMatch(s -> !s.isEmpty());
    }

    public Collection<ExecutionTask> remainingLeadershipMovements() {
        return this.remainingLeadershipMovements.values();
    }

    public Collection<ExecutionTask> remainingTenantMovements() {
        return this.remainingTenantMovements.values();
    }

    public List<ExecutionTask> removeLeadershipMovementTasks(int numTasks) {
        return this.removeMovementTasks(numTasks, this.remainingLeadershipMovements);
    }

    private List<ExecutionTask> removeMovementTasks(int numTasks, Map<Long, ExecutionTask> executionTaskMap) {
        ArrayList<ExecutionTask> movementsList = new ArrayList<ExecutionTask>();
        Iterator<ExecutionTask> movementsIterator = executionTaskMap.values().iterator();
        for (int i = 0; i < numTasks && movementsIterator.hasNext(); ++i) {
            movementsList.add(movementsIterator.next());
            movementsIterator.remove();
        }
        return movementsList;
    }

    public List<ExecutionTask> removeTenantMovementTasks(int numTasks) {
        return this.removeMovementTasks(numTasks, this.remainingTenantMovements);
    }

    public List<ExecutionTask> drainInterBrokerTasks(BrokerExecutionTaskTracker brokerExecutionTracker, Set<TopicPartition> inProgressPartitions) {
        if (this.isV2ExecutorEnabled) {
            return this.drainMultiShotTasks(brokerExecutionTracker, inProgressPartitions);
        }
        return this.drainSingleShotTasks(brokerExecutionTracker, inProgressPartitions);
    }

    private List<ExecutionTask> drainSingleShotTasks(BrokerExecutionTaskTracker brokerExecutionTracker, Set<TopicPartition> inProgressPartitions) {
        ArrayList<ExecutionTask> executableReplicaMovements = new ArrayList<ExecutionTask>();
        HashSet<Integer> brokersInvolved = new HashSet<Integer>();
        HashSet<TopicPartition> partitionsInvolved = new HashSet<TopicPartition>();
        boolean newTaskAdded = true;
        while (newTaskAdded) {
            newTaskAdded = false;
            brokersInvolved.clear();
            ArrayList<Integer> knownBrokers = new ArrayList<Integer>(brokerExecutionTracker.knownBrokers());
            Collections.shuffle(knownBrokers);
            block1: for (Integer sourceBroker : knownBrokers) {
                if (brokersInvolved.contains(sourceBroker)) continue;
                SortedSet<ExecutionTask> proposalsForBroker = this.interPartMoveTaskByBrokerId.get(sourceBroker);
                LOG.trace("Execution task for broker {} are {}", (Object)sourceBroker, proposalsForBroker);
                if (proposalsForBroker == null) continue;
                for (ExecutionTask task : proposalsForBroker) {
                    LOG.trace("Considering execution task {} for broker {}", (Object)task, (Object)sourceBroker);
                    Set<Integer> destinationBrokers = task.partitionProposal().replicasToAdd().stream().mapToInt(ReplicaId::brokerId).boxed().collect(Collectors.toSet());
                    if (brokersInvolved.contains(sourceBroker) || KafkaCruiseControlUtils.containsAny(brokersInvolved, destinationBrokers)) {
                        LOG.trace("Skipping execution task {} because either the source or the destination brokers were already involved in the generated proposals", (Object)task);
                        continue;
                    }
                    TopicPartition tp = task.partitionProposal().topicPartition();
                    boolean isExecutable = this.isExecutableTask(task, brokerExecutionTracker);
                    boolean isPartitionInProgress = inProgressPartitions.contains(tp);
                    boolean isPartitionInvolved = partitionsInvolved.contains(tp);
                    if (isExecutable && !isPartitionInProgress && !isPartitionInvolved) {
                        partitionsInvolved.add(tp);
                        executableReplicaMovements.add(task);
                        brokersInvolved.add(sourceBroker);
                        brokersInvolved.addAll(destinationBrokers);
                        proposalsForBroker.remove(task);
                        int nSourceSlots = task.requiredParallelism();
                        brokerExecutionTracker.addTaskForBroker(sourceBroker, nSourceSlots);
                        for (int broker : destinationBrokers) {
                            brokerExecutionTracker.addTaskForBroker(broker, 1);
                        }
                        newTaskAdded = true;
                        LOG.debug("Found ready task {} for broker {}. Broker concurrency state: {}", new Object[]{task, sourceBroker, brokerExecutionTracker});
                        continue block1;
                    }
                    LOG.trace("Skipped execution task {} - isExecutable: {}, isPartitionInProgress: {}, isPartitionInvolved: {}", new Object[]{task, isExecutable, isPartitionInProgress, isPartitionInvolved});
                }
            }
        }
        LOG.trace("Generated {} inter-broker replica movement tasks for brokers with concurrency {}", (Object)executableReplicaMovements.size(), (Object)brokerExecutionTracker);
        return executableReplicaMovements;
    }

    private List<ExecutionTask> drainMultiShotTasks(BrokerExecutionTaskTracker brokerExecutionTracker, Set<TopicPartition> inProgressPartitions) {
        ArrayList<ExecutionTask> executableReplicaMovements = new ArrayList<ExecutionTask>();
        HashMap<ReplicaId, Set> tasksByDestination = new HashMap<ReplicaId, Set>();
        HashMap<Integer, Integer> remainingBySource = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> remainingByDestination = new HashMap<Integer, Integer>();
        for (Integer source : this.interPartMoveTaskByBrokerId.keySet()) {
            for (ExecutionTask task : this.interPartMoveTaskByBrokerId.get(source)) {
                if (inProgressPartitions.contains(task.partitionProposal().topicPartition())) continue;
                if (task.partitionProposal().isLeadershipShuffle()) {
                    executableReplicaMovements.add(task);
                    continue;
                }
                remainingBySource.put(source, remainingBySource.getOrDefault(source, 0) + task.partitionProposal().replicasToAdd().size());
                for (ReplicaId destination : task.partitionProposal().replicasToAdd()) {
                    tasksByDestination.computeIfAbsent(destination, k -> new HashSet()).add(task);
                    remainingByDestination.put(destination.brokerId(), remainingByDestination.getOrDefault(destination.brokerId(), 0) + 1);
                }
            }
        }
        LOG.info("Draining tasks with {}", (Object)brokerExecutionTracker);
        ArrayList allDestinationBrokers = new ArrayList(tasksByDestination.keySet());
        HashSet<TopicPartition> involvedPartitions = new HashSet<TopicPartition>();
        boolean newTaskAdded = true;
        block3: while (newTaskAdded) {
            newTaskAdded = false;
            Map<Integer, Integer> destinationsToUnusedSlots = brokerExecutionTracker.brokerToUnusedDestinationSlots();
            allDestinationBrokers.sort((a, b) -> !((Integer)destinationsToUnusedSlots.get(a.brokerId())).equals(destinationsToUnusedSlots.get(b.brokerId())) ? Integer.compare((Integer)destinationsToUnusedSlots.get(b.brokerId()), (Integer)destinationsToUnusedSlots.get(a.brokerId())) : Integer.compare((Integer)remainingByDestination.get(b.brokerId()), (Integer)remainingByDestination.get(a.brokerId())));
            for (ReplicaId destination : allDestinationBrokers) {
                Map<Integer, Integer> sourcesToUnusedSlots = brokerExecutionTracker.brokerToUnusedSourceSlots();
                TreeSet proposalsForBroker = new TreeSet((a, b) -> {
                    PartitionProposal proposalA = a.partitionProposal();
                    PartitionProposal proposalB = b.partitionProposal();
                    Integer srcA = proposalA.oldLeader().brokerId();
                    Integer srcB = proposalB.oldLeader().brokerId();
                    return proposalA.replicasToAdd().size() != proposalB.replicasToAdd().size() ? Integer.compare(proposalA.replicasToAdd().size(), proposalB.replicasToAdd().size()) : (!((Integer)sourcesToUnusedSlots.get(srcB)).equals(sourcesToUnusedSlots.get(srcA)) ? Integer.compare((Integer)sourcesToUnusedSlots.get(srcB), (Integer)sourcesToUnusedSlots.get(srcA)) : (!((Integer)remainingBySource.get(srcA)).equals(remainingBySource.get(srcB)) ? Integer.compare((Integer)remainingBySource.get(srcB), (Integer)remainingBySource.get(srcA)) : 1));
                });
                proposalsForBroker.addAll((Collection)tasksByDestination.get(destination));
                for (ExecutionTask task : proposalsForBroker) {
                    Integer sourceBroker = task.partitionProposal().oldLeader().brokerId();
                    PartitionProposal proposal = task.partitionProposal();
                    if (involvedPartitions.contains(proposal.topicPartition()) || brokerExecutionTracker.wouldOverloadBrokerAsSource(sourceBroker) || brokerExecutionTracker.wouldOverloadBrokerAsDestination(destination.brokerId()) || proposal.replicasToAdd().size() > proposal.numReplicasToAddInSameRackAsOldLeader() && proposal.isReplicaInSameRackAsOldLeader(destination)) continue;
                    newTaskAdded = true;
                    proposal.proposeReplicaToAdd(destination);
                    executableReplicaMovements.add(task);
                    involvedPartitions.add(proposal.topicPartition());
                    brokerExecutionTracker.addTaskForBrokerAsSource(sourceBroker);
                    brokerExecutionTracker.addTaskForBrokerAsDestination(destination.brokerId());
                    remainingBySource.put(sourceBroker, (Integer)remainingBySource.get(sourceBroker) - 1);
                    remainingByDestination.put(destination.brokerId(), (Integer)remainingByDestination.get(destination.brokerId()) - 1);
                    LOG.debug("Found ready task new-replica {} for broker {}. Broker concurrency state: {}", new Object[]{task, sourceBroker, brokerExecutionTracker});
                    break;
                }
                if (!newTaskAdded) continue;
                continue block3;
            }
        }
        LOG.info("Drained tasks with {}", (Object)brokerExecutionTracker);
        return executableReplicaMovements;
    }

    public void clear() {
        this.interPartMoveTaskByBrokerId.clear();
        this.remainingLeadershipMovements.clear();
    }

    private boolean isExecutableTask(ExecutionTask task, BrokerExecutionTaskTracker brokerExecutionTracker) {
        int nSimultaneousMoves = task.requiredParallelism();
        if (brokerExecutionTracker.wouldOverloadBroker(task.partitionProposal().oldLeader().brokerId(), nSimultaneousMoves)) {
            return false;
        }
        for (ReplicaId destinationBroker : task.partitionProposal().replicasToAdd()) {
            if (!brokerExecutionTracker.wouldOverloadBroker(destinationBroker.brokerId(), 1)) continue;
            return false;
        }
        return true;
    }

    private Map<Integer, SortedSet<ExecutionTask>> orderInterBrokerReplicaMovementTasks(Set<ExecutionTask> tasks, Cluster cluster) {
        return this.defaultReplicaMovementTaskStrategy.applyStrategy(tasks, cluster);
    }

    public void removeTask(ExecutionTask task) {
        if (this.interPartMoveTaskByBrokerId.containsKey(task.partitionProposal().oldLeader().brokerId())) {
            this.interPartMoveTaskByBrokerId.get(task.partitionProposal().oldLeader().brokerId()).remove(task);
        }
    }
}

