/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.executor;

import com.linkedin.kafka.cruisecontrol.executor.ExecutionTask;
import com.linkedin.kafka.cruisecontrol.executor.Executor;
import com.linkedin.kafka.cruisecontrol.model.ReplicaId;
import io.confluent.databalancer.metrics.GeneralSBCMetricsRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.kafka.common.utils.Time;

public class ExecutionTaskTracker {
    private final ConcurrentMap<ExecutionTask.TaskType, Map<ExecutionTask.State, Set<ExecutionTask>>> tasksByType;
    final ConcurrentMap<Integer, Long> remainingInterBrokerDataToMoveInMBByDestinationBroker = new ConcurrentHashMap<Integer, Long>();
    final Set<Integer> registeredInterBrokerRemainingMetricBrokers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final GeneralSBCMetricsRegistry metricsRegistry;
    private volatile long remainingInterBrokerDataToMoveInMB;
    private volatile long inExecutionInterBrokerDataMovementInMB;
    private volatile long finishedInterBrokerDataMovementInMB;
    private final Time time;
    private volatile boolean stopRequested;
    static final String INTER_BROKER_REPLICA_ACTION = "replica-action";
    private static final String REMAINING_DATA_TO_MOVE_METRIC_NAME_SUFFIX = "remaining-data-to-move-mb";
    static final String TOTAL_REMAINING_DATA_TO_MOVE_METRIC_NAME_SUFFIX = "total-remaining-data-to-move-mb";
    static final String TOTAL_IN_PROGRESS_DATA_TO_MOVE_METRIC_NAME_SUFFIX = "total-in-progress-data-to-move-mb";
    static final String TOTAL_COMPLETED_DATA_TO_MOVE_METRIC_NAME_SUFFIX = "total-completed-data-to-move-mb";
    static final String DESTINATION_BROKER_ID_TAG = "destinationBrokerId";
    static final String INTER_BROKER_REMAINING_DATA_TO_MOVE_MB = "replica-action-remaining-data-to-move-mb";
    static final String LEADERSHIP_ACTION = "leadership-action";
    static final String TENANT_ACTION = "tenant-action";
    private static final String IN_PROGRESS = "in-progress";
    private static final String PENDING = "pending";
    private static final String ABORTING = "aborting";
    private static final String TO_BE_RETRIED = "to be retried";
    private static final String ABORTED = "aborted";
    private static final String DEAD = "dead";
    private static final String COMPLETED = "completed";

    ExecutionTaskTracker(GeneralSBCMetricsRegistry metricsRegistry, Time time) {
        List<ExecutionTask.State> states = ExecutionTask.State.cachedValues();
        List<ExecutionTask.TaskType> taskTypes = ExecutionTask.TaskType.cachedValues();
        this.tasksByType = new ConcurrentHashMap<ExecutionTask.TaskType, Map<ExecutionTask.State, Set<ExecutionTask>>>(taskTypes.size());
        for (ExecutionTask.TaskType type : taskTypes) {
            ConcurrentHashMap taskMap = new ConcurrentHashMap(states.size());
            for (ExecutionTask.State state : states) {
                taskMap.put(state, ConcurrentHashMap.newKeySet());
            }
            this.tasksByType.put(type, taskMap);
        }
        this.remainingInterBrokerDataToMoveInMB = 0L;
        this.inExecutionInterBrokerDataMovementInMB = 0L;
        this.finishedInterBrokerDataMovementInMB = 0L;
        this.time = time;
        this.metricsRegistry = metricsRegistry;
        this.stopRequested = false;
        this.registerGaugeSensors(metricsRegistry);
    }

    private void registerGaugeSensors(GeneralSBCMetricsRegistry metricRegistry) {
        for (ExecutionTask.TaskType type : ExecutionTask.TaskType.cachedValues()) {
            String typeString = type.metricPrefix();
            for (ExecutionTask.State state : ExecutionTask.State.cachedValues()) {
                String stateString = state == ExecutionTask.State.PENDING ? PENDING : (state == ExecutionTask.State.IN_PROGRESS ? IN_PROGRESS : (state == ExecutionTask.State.TO_RETRY ? TO_BE_RETRIED : (state == ExecutionTask.State.ABORTING ? ABORTING : (state == ExecutionTask.State.ABORTED ? ABORTED : (state == ExecutionTask.State.COMPLETED ? COMPLETED : DEAD)))));
                metricRegistry.newGauge(Executor.class, typeString + "-" + stateString, () -> state == ExecutionTask.State.PENDING && this.stopRequested ? 0 : ((Set)((Map)this.tasksByType.get((Object)type)).get((Object)state)).size());
            }
        }
        metricRegistry.newGauge(Executor.class, TOTAL_REMAINING_DATA_TO_MOVE_METRIC_NAME_SUFFIX, () -> this.remainingInterBrokerDataToMoveInMB);
        metricRegistry.newGauge(Executor.class, TOTAL_IN_PROGRESS_DATA_TO_MOVE_METRIC_NAME_SUFFIX, () -> this.inExecutionInterBrokerDataMovementInMB);
        metricRegistry.newGauge(Executor.class, TOTAL_COMPLETED_DATA_TO_MOVE_METRIC_NAME_SUFFIX, () -> this.finishedInterBrokerDataMovementInMB);
    }

    public void markTaskBackAsPendingAfterIntermediateSuccess(ExecutionTask task) {
        ((Set)((Map)this.tasksByType.get((Object)task.type())).get((Object)task.state())).remove(task);
        task.pending();
        this.updateDataMovement(task);
        ((Set)((Map)this.tasksByType.get((Object)task.type())).get((Object)ExecutionTask.State.PENDING)).add(task);
    }

    public void markTaskState(ExecutionTask task, ExecutionTask.State newState) {
        ((Set)((Map)this.tasksByType.get((Object)task.type())).get((Object)task.state())).remove(task);
        switch (newState) {
            case PENDING: {
                task.pending();
                break;
            }
            case IN_PROGRESS: {
                task.inProgress(this.time.milliseconds());
                this.updateDataMovement(task);
                break;
            }
            case TO_RETRY: {
                task.toBeRetried();
                this.updateDataMovement(task);
                break;
            }
            case ABORTING: {
                task.abort();
                break;
            }
            case ABORTED: {
                task.aborted(this.time.milliseconds());
                this.updateDataMovement(task);
                break;
            }
            case COMPLETED: {
                task.completed(this.time.milliseconds());
                this.updateDataMovement(task);
                break;
            }
            case DEAD: {
                task.kill(this.time.milliseconds());
                this.updateDataMovement(task);
                break;
            }
        }
        ((Set)((Map)this.tasksByType.get((Object)task.type())).get((Object)newState)).add(task);
    }

    public List<ExecutionTask> deadExecutionTasks() {
        ArrayList<ExecutionTask> deadExecutionTasks = new ArrayList<ExecutionTask>();
        this.tasksByType.forEach((key, value) -> deadExecutionTasks.addAll((Collection)value.get((Object)ExecutionTask.State.DEAD)));
        return deadExecutionTasks;
    }

    public Set<ExecutionTask> tasksToBeRetried(ExecutionTask.TaskType type) {
        return this.tasksByType.getOrDefault((Object)type, Collections.emptyMap()).getOrDefault((Object)ExecutionTask.State.TO_RETRY, Collections.emptySet());
    }

    private void updateDataMovement(ExecutionTask task) {
        if (task.type() != ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION) {
            return;
        }
        long totalDataToMove = task.partitionProposal().interBrokerDataToMoveInMB();
        long destinationBrokerDataToReceive = task.partitionProposal().singleDestinationBrokerDataToReceiveInMB();
        if (task.state() == ExecutionTask.State.IN_PROGRESS) {
            if (task.partitionProposal().replicaToAdd() == null) {
                this.remainingInterBrokerDataToMoveInMB -= totalDataToMove;
                this.inExecutionInterBrokerDataMovementInMB += totalDataToMove;
                this.updateDestinationBrokerRemainingDataToMove(task.partitionProposal().replicasToAdd(), -destinationBrokerDataToReceive);
            } else {
                this.remainingInterBrokerDataToMoveInMB -= destinationBrokerDataToReceive;
                this.inExecutionInterBrokerDataMovementInMB += destinationBrokerDataToReceive;
                this.updateDestinationBrokerRemainingDataToMove(task.partitionProposal().replicaToAdd().brokerId(), -destinationBrokerDataToReceive);
            }
        } else if (task.state() == ExecutionTask.State.ABORTED || task.state() == ExecutionTask.State.DEAD || task.state() == ExecutionTask.State.COMPLETED || task.state() == ExecutionTask.State.PENDING) {
            if (task.partitionProposal().replicaToAdd() == null) {
                this.inExecutionInterBrokerDataMovementInMB -= totalDataToMove;
                this.finishedInterBrokerDataMovementInMB += totalDataToMove;
            } else {
                this.inExecutionInterBrokerDataMovementInMB -= destinationBrokerDataToReceive;
                this.finishedInterBrokerDataMovementInMB += destinationBrokerDataToReceive;
            }
        } else if (task.state() == ExecutionTask.State.TO_RETRY) {
            if (task.partitionProposal().replicaToAdd() == null) {
                this.remainingInterBrokerDataToMoveInMB += totalDataToMove;
                this.inExecutionInterBrokerDataMovementInMB -= totalDataToMove;
                this.updateDestinationBrokerRemainingDataToMove(task.partitionProposal().replicasToAdd(), destinationBrokerDataToReceive);
            } else {
                this.remainingInterBrokerDataToMoveInMB += destinationBrokerDataToReceive;
                this.inExecutionInterBrokerDataMovementInMB -= destinationBrokerDataToReceive;
                this.updateDestinationBrokerRemainingDataToMove(task.partitionProposal().replicaToAdd().brokerId(), destinationBrokerDataToReceive);
            }
        }
    }

    public void addTasksToTrace(Collection<ExecutionTask> tasks, ExecutionTask.TaskType taskType) {
        ((Set)((Map)this.tasksByType.get((Object)taskType)).get((Object)ExecutionTask.State.PENDING)).addAll(tasks);
        if (taskType == ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION) {
            long totalDataToMoveSum = 0L;
            for (ExecutionTask task : tasks) {
                long totalDataToMoveMb = task.partitionProposal().interBrokerDataToMoveInMB();
                totalDataToMoveSum += totalDataToMoveMb;
                this.updateDestinationBrokerRemainingDataToMove(task.partitionProposal().replicasToAdd(), task.partitionProposal().singleDestinationBrokerDataToReceiveInMB());
            }
            this.remainingInterBrokerDataToMoveInMB = totalDataToMoveSum;
        }
    }

    private void updateDestinationBrokerRemainingDataToMove(List<ReplicaId> destinationBrokers, long dataToMoveInMb) {
        for (ReplicaId replicaId : destinationBrokers) {
            int destinationBrokerId = replicaId.brokerId();
            this.updateDestinationBrokerRemainingDataToMove(destinationBrokerId, dataToMoveInMb);
        }
    }

    private void updateDestinationBrokerRemainingDataToMove(int destinationBrokerId, long dataToMoveInMb) {
        if (!this.registeredInterBrokerRemainingMetricBrokers.contains(destinationBrokerId)) {
            this.metricsRegistry.newGauge(Executor.class, INTER_BROKER_REMAINING_DATA_TO_MOVE_MB, () -> this.remainingInterBrokerDataToMoveInMBByDestinationBroker.getOrDefault(destinationBrokerId, 0L), Collections.singletonMap(DESTINATION_BROKER_ID_TAG, Integer.toString(destinationBrokerId)));
            this.registeredInterBrokerRemainingMetricBrokers.add(destinationBrokerId);
        }
        this.remainingInterBrokerDataToMoveInMBByDestinationBroker.merge(destinationBrokerId, dataToMoveInMb, Long::sum);
    }

    private Map<ExecutionTask.TaskType, Map<ExecutionTask.State, Integer>> taskStat() {
        HashMap<ExecutionTask.TaskType, Map<ExecutionTask.State, Integer>> taskStatMap = new HashMap<ExecutionTask.TaskType, Map<ExecutionTask.State, Integer>>(ExecutionTask.TaskType.cachedValues().size());
        for (ExecutionTask.TaskType type : ExecutionTask.TaskType.cachedValues()) {
            taskStatMap.put(type, new HashMap());
            ((Map)this.tasksByType.get((Object)type)).forEach((k, v) -> ((Map)taskStatMap.get((Object)type)).put(k, v.size()));
        }
        return taskStatMap;
    }

    private Map<ExecutionTask.TaskType, Map<ExecutionTask.State, Set<ExecutionTask>>> filteredTasksByState(Set<ExecutionTask.TaskType> taskTypesToGetFullList) {
        HashMap<ExecutionTask.TaskType, Map<ExecutionTask.State, Set<ExecutionTask>>> tasksByState = new HashMap<ExecutionTask.TaskType, Map<ExecutionTask.State, Set<ExecutionTask>>>(taskTypesToGetFullList.size());
        for (ExecutionTask.TaskType type : taskTypesToGetFullList) {
            tasksByState.put(type, new HashMap());
            ((Map)this.tasksByType.get((Object)type)).forEach((k, v) -> ((Map)tasksByState.get((Object)type)).put(k, new HashSet(v)));
        }
        return tasksByState;
    }

    public void clear() {
        this.tasksByType.values().forEach(m -> m.values().forEach(Set::clear));
        this.remainingInterBrokerDataToMoveInMB = 0L;
        this.inExecutionInterBrokerDataMovementInMB = 0L;
        this.finishedInterBrokerDataMovementInMB = 0L;
        this.remainingInterBrokerDataToMoveInMBByDestinationBroker.clear();
        this.stopRequested = false;
    }

    public void setStopRequested() {
        this.stopRequested = true;
    }

    public int numRemainingInterBrokerPartitionMovements() {
        return this.numPendingInterBrokerPartitionMovements() + this.numInterBrokerPartitionMovementsToBeRetried();
    }

    public int numPendingInterBrokerPartitionMovements() {
        return ((Set)((Map)this.tasksByType.get((Object)ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION)).get((Object)ExecutionTask.State.PENDING)).size();
    }

    public int numPendingReplicaMovements() {
        Set pendingTasks = (Set)((Map)this.tasksByType.get((Object)ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION)).get((Object)ExecutionTask.State.PENDING);
        int pendingReplicaMovements = 0;
        for (ExecutionTask task : pendingTasks) {
            pendingReplicaMovements += task.partitionProposal().replicasToAdd().size();
        }
        return pendingReplicaMovements;
    }

    public Set<ExecutionTask> pendingInterBrokerPartitionMovements() {
        return new HashSet<ExecutionTask>((Collection)((Map)this.tasksByType.get((Object)ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION)).get((Object)ExecutionTask.State.PENDING));
    }

    public int numInterBrokerPartitionMovementsToBeRetried() {
        return ((Set)((Map)this.tasksByType.get((Object)ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION)).get((Object)ExecutionTask.State.TO_RETRY)).size();
    }

    public long remainingInterBrokerDataToMoveInMB() {
        return this.remainingInterBrokerDataToMoveInMB;
    }

    public Map<Integer, Long> remainingInterBrokerDataToMoveByDestinationBroker() {
        return Collections.unmodifiableMap(this.remainingInterBrokerDataToMoveInMBByDestinationBroker);
    }

    public int numFinishedInterBrokerPartitionMovements() {
        return ((Set)((Map)this.tasksByType.get((Object)ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION)).get((Object)ExecutionTask.State.COMPLETED)).size() + ((Set)((Map)this.tasksByType.get((Object)ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION)).get((Object)ExecutionTask.State.DEAD)).size() + ((Set)((Map)this.tasksByType.get((Object)ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION)).get((Object)ExecutionTask.State.ABORTED)).size();
    }

    public long finishedInterBrokerDataMovementInMB() {
        return this.finishedInterBrokerDataMovementInMB;
    }

    public Set<ExecutionTask> inExecutionTasks(Collection<ExecutionTask.TaskType> types) {
        HashSet<ExecutionTask> inExecutionTasks = new HashSet<ExecutionTask>();
        for (ExecutionTask.TaskType type : types) {
            inExecutionTasks.addAll((Collection)((Map)this.tasksByType.get((Object)type)).get((Object)ExecutionTask.State.IN_PROGRESS));
            inExecutionTasks.addAll((Collection)((Map)this.tasksByType.get((Object)type)).get((Object)ExecutionTask.State.ABORTING));
        }
        return inExecutionTasks;
    }

    public long inExecutionInterBrokerDataMovementInMB() {
        return this.inExecutionInterBrokerDataMovementInMB;
    }

    public int numRemainingLeadershipMovements() {
        return this.numPendingLeadershipMovements() + this.numLeadershipMovementsToBeRetried();
    }

    public int numPendingLeadershipMovements() {
        return ((Set)((Map)this.tasksByType.get((Object)ExecutionTask.TaskType.LEADER_ACTION)).get((Object)ExecutionTask.State.PENDING)).size();
    }

    public int numLeadershipMovementsToBeRetried() {
        return ((Set)((Map)this.tasksByType.get((Object)ExecutionTask.TaskType.LEADER_ACTION)).get((Object)ExecutionTask.State.TO_RETRY)).size();
    }

    public int numFinishedLeadershipMovements() {
        return ((Set)((Map)this.tasksByType.get((Object)ExecutionTask.TaskType.LEADER_ACTION)).get((Object)ExecutionTask.State.COMPLETED)).size() + ((Set)((Map)this.tasksByType.get((Object)ExecutionTask.TaskType.LEADER_ACTION)).get((Object)ExecutionTask.State.DEAD)).size() + ((Set)((Map)this.tasksByType.get((Object)ExecutionTask.TaskType.LEADER_ACTION)).get((Object)ExecutionTask.State.ABORTED)).size();
    }

    public ExecutionTasksSummary getExecutionTasksSummary(Set<ExecutionTask.TaskType> taskTypesToGetFullList) {
        return new ExecutionTasksSummary(this.finishedInterBrokerDataMovementInMB, this.inExecutionInterBrokerDataMovementInMB, this.remainingInterBrokerDataToMoveInMB, this.taskStat(), this.filteredTasksByState(taskTypesToGetFullList));
    }

    public static class ExecutionTasksSummary {
        private long finishedInterBrokerDataMovementInMB;
        private long inExecutionInterBrokerDataMovementInMB;
        private final long remainingInterBrokerDataToMoveInMB;
        private Map<ExecutionTask.TaskType, Map<ExecutionTask.State, Integer>> taskStat;
        private Map<ExecutionTask.TaskType, Map<ExecutionTask.State, Set<ExecutionTask>>> filteredTasksByState;

        ExecutionTasksSummary(long finishedInterBrokerDataMovementInMB, long inExecutionInterBrokerDataMovementInMB, long remainingInterBrokerDataToMoveInMB, Map<ExecutionTask.TaskType, Map<ExecutionTask.State, Integer>> taskStat, Map<ExecutionTask.TaskType, Map<ExecutionTask.State, Set<ExecutionTask>>> filteredTasksByState) {
            this.finishedInterBrokerDataMovementInMB = finishedInterBrokerDataMovementInMB;
            this.inExecutionInterBrokerDataMovementInMB = inExecutionInterBrokerDataMovementInMB;
            this.remainingInterBrokerDataToMoveInMB = remainingInterBrokerDataToMoveInMB;
            this.taskStat = taskStat;
            this.filteredTasksByState = filteredTasksByState;
        }

        public long finishedInterBrokerDataMovementInMB() {
            return this.finishedInterBrokerDataMovementInMB;
        }

        public long inExecutionInterBrokerDataMovementInMB() {
            return this.inExecutionInterBrokerDataMovementInMB;
        }

        public long remainingInterBrokerDataToMoveInMB() {
            return this.remainingInterBrokerDataToMoveInMB;
        }

        public Map<ExecutionTask.TaskType, Map<ExecutionTask.State, Integer>> taskStat() {
            return this.taskStat;
        }

        public String summarize(ExecutionTask.TaskType type) {
            Map<ExecutionTask.State, Integer> numMovementsPerState = this.taskStat.get((Object)type);
            String numMovementsPerStateSummary = numMovementsPerState == null || numMovementsPerState.isEmpty() ? "<none>" : ExecutionTask.State.summarize(numMovementsPerState);
            return String.format("For %s - %s", type.toString(), numMovementsPerStateSummary);
        }

        public Map<ExecutionTask.TaskType, Map<ExecutionTask.State, Set<ExecutionTask>>> filteredTasksByState() {
            return this.filteredTasksByState;
        }
    }
}

