/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.executor;

import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyType;

public class ExecutorNotification {
    private ActionAgent startedBy;
    private ActionAgent endedBy;
    private final long startMs;
    private final long endMs;
    private final boolean executionSucceeded;
    private String operation;
    private Throwable exception = null;
    private final String actionUuid;

    public ExecutorNotification(long executionStartMs, long endMs, String uuid, boolean stopRequested, boolean executionStoppedByUser, Throwable executionException, boolean executionSucceeded) {
        this.startMs = executionStartMs;
        this.endMs = endMs;
        this.startedBy = ActionAgent.UNKNOWN;
        this.operation = "UNKNOWN";
        this.actionUuid = uuid;
        this.executionSucceeded = executionSucceeded;
        if (uuid != null) {
            for (AnomalyType type : AnomalyType.cachedValues()) {
                if (!this.actionUuid.startsWith(type.toString())) continue;
                this.startedBy = ActionAgent.CRUISE_CONTROL;
                this.operation = type.toString() + " Fix Action";
                break;
            }
        }
        this.endedBy = ActionAgent.EXECUTION_COMPLETION;
        if (stopRequested) {
            this.endedBy = executionStoppedByUser ? ActionAgent.USER : ActionAgent.CRUISE_CONTROL;
        } else if (executionException != null) {
            this.endedBy = ActionAgent.EXCEPTION;
            this.exception = executionException;
        }
    }

    public ActionAgent startedBy() {
        return this.startedBy;
    }

    public ActionAgent endedBy() {
        return this.endedBy;
    }

    public long startMs() {
        return this.startMs;
    }

    public long endMs() {
        return this.endMs;
    }

    public boolean executionSucceeded() {
        return this.executionSucceeded;
    }

    public String operation() {
        return this.operation;
    }

    public String actionUuid() {
        return this.actionUuid;
    }

    public boolean startedByUser() {
        return this.startedBy == ActionAgent.USER;
    }

    public Throwable exception() {
        return this.exception;
    }

    public static enum ActionAgent {
        USER,
        CRUISE_CONTROL,
        EXCEPTION,
        EXECUTION_COMPLETION,
        UNKNOWN;

    }
}

