/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.executor;

import com.linkedin.kafka.cruisecontrol.executor.ExecutionTask;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTaskTracker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExecutorState {
    private static final String TRIGGERED_USER_TASK_ID = "triggeredUserTaskId";
    private static final String STATE = "state";
    private static final String RECENTLY_REMOVED_BROKERS = "recentlyRemovedBrokers";
    private static final String NUM_TOTAL_LEADERSHIP_MOVEMENTS = "numTotalLeadershipMovements";
    private static final String NUM_PENDING_LEADERSHIP_MOVEMENTS = "numPendingLeadershipMovements";
    private static final String NUM_CANCELLED_LEADERSHIP_MOVEMENTS = "numCancelledLeadershipMovements";
    private static final String NUM_FINISHED_LEADERSHIP_MOVEMENTS = "numFinishedLeadershipMovements";
    private static final String PENDING_LEADERSHIP_MOVEMENT = "pendingLeadershipMovement";
    private static final String CANCELLED_LEADERSHIP_MOVEMENT = "cancelledLeadershipMovement";
    private static final String MAXIMUM_CONCURRENT_LEADER_MOVEMENTS = "maximumConcurrentLeaderMovements";
    private static final String NUM_TOTAL_INTER_BROKER_PARTITION_MOVEMENTS = "numTotalPartitionMovements";
    private static final String NUM_PENDING_INTER_BROKER_PARTITION_MOVEMENTS = "numPendingPartitionMovements";
    private static final String NUM_CANCELLED_INTER_BROKER_PARTITION_MOVEMENTS = "numCancelledPartitionMovements";
    private static final String NUM_IN_PROGRESS_INTER_BROKER_PARTITION_MOVEMENTS = "numInProgressPartitionMovements";
    private static final String NUM_ABORTING_INTER_BROKER_PARTITION_MOVEMENTS = "abortingPartitions";
    private static final String NUM_FINISHED_INTER_BROKER_PARTITION_MOVEMENTS = "numFinishedPartitionMovements";
    private static final String IN_PROGRESS_INTER_BROKER_PARTITION_MOVEMENT = "inProgressPartitionMovement";
    private static final String PENDING_INTER_BROKER_PARTITION_MOVEMENT = "pendingPartitionMovement";
    private static final String CANCELLED_INTER_BROKER_PARTITION_MOVEMENT = "cancelledPartitionMovement";
    private static final String DEAD_INTER_BROKER_PARTITION_MOVEMENT = "deadPartitionMovement";
    private static final String COMPLETED_INTER_BROKER_PARTITION_MOVEMENT = "completedPartitionMovement";
    private static final String ABORTING_INTER_BROKER_PARTITION_MOVEMENT = "abortingPartitionMovement";
    private static final String ABORTED_INTER_BROKER_PARTITION_MOVEMENT = "abortedPartitionMovement";
    private static final String FINISHED_INTER_BROKER_DATA_MOVEMENT = "finishedDataMovement";
    private static final String TOTAL_INTER_BROKER_DATA_TO_MOVE = "totalDataToMove";
    private static final String MAXIMUM_CONCURRENT_INTER_BROKER_PARTITION_MOVEMENTS_PER_BROKER = "maximumConcurrentPartitionMovementsPerBroker";
    private static final String ERROR = "error";
    private final State state;
    private ExecutionTaskTracker.ExecutionTasksSummary executionTasksSummary;
    private final int maximumConcurrentInterBrokerPartitionMovementsPerBroker;
    private final int maximumConcurrentLeaderMovements;
    private final String uuid;
    private final Set<Integer> recentlyRemovedBrokers;

    private ExecutorState(State state, ExecutionTaskTracker.ExecutionTasksSummary executionTasksSummary, int maximumConcurrentInterBrokerPartitionMovementsPerBroker, int maximumConcurrentLeaderMovements, String uuid, Set<Integer> recentlyRemovedBrokers) {
        this.state = state;
        this.executionTasksSummary = executionTasksSummary;
        this.maximumConcurrentInterBrokerPartitionMovementsPerBroker = maximumConcurrentInterBrokerPartitionMovementsPerBroker;
        this.maximumConcurrentLeaderMovements = maximumConcurrentLeaderMovements;
        this.uuid = uuid;
        this.recentlyRemovedBrokers = recentlyRemovedBrokers;
    }

    public static ExecutorState noTaskInProgress(Set<Integer> recentlyRemovedBrokers) {
        return new ExecutorState(State.NO_TASK_IN_PROGRESS, null, 0, 0, "", recentlyRemovedBrokers);
    }

    public static ExecutorState executionStarted(String uuid, Set<Integer> recentlyRemovedBrokers) {
        return new ExecutorState(State.STARTING_EXECUTION, null, 0, 0, uuid, recentlyRemovedBrokers);
    }

    public static ExecutorState operationInProgress(State state, ExecutionTaskTracker.ExecutionTasksSummary executionTasksSummary, int maximumConcurrentInterBrokerPartitionMovementsPerBroker, int maximumConcurrentLeaderMovements, String uuid, Set<Integer> recentlyRemovedBrokers) {
        if (state == State.NO_TASK_IN_PROGRESS || state == State.STARTING_EXECUTION) {
            throw new IllegalArgumentException(String.format("%s is not an operation-in-progress executor state.", new Object[]{state}));
        }
        return new ExecutorState(state, executionTasksSummary, maximumConcurrentInterBrokerPartitionMovementsPerBroker, maximumConcurrentLeaderMovements, uuid, recentlyRemovedBrokers);
    }

    public State state() {
        return this.state;
    }

    public int numTotalMovements(ExecutionTask.TaskType type) {
        return this.executionTasksSummary.taskStat().get((Object)type).values().stream().mapToInt(i -> i).sum();
    }

    public int numFinishedMovements(ExecutionTask.TaskType type) {
        return this.executionTasksSummary.taskStat().get((Object)type).get((Object)ExecutionTask.State.DEAD) + this.executionTasksSummary.taskStat().get((Object)type).get((Object)ExecutionTask.State.COMPLETED) + this.executionTasksSummary.taskStat().get((Object)type).get((Object)ExecutionTask.State.ABORTED);
    }

    public long numTotalInterBrokerDataToMove() {
        return this.executionTasksSummary.inExecutionInterBrokerDataMovementInMB() + this.executionTasksSummary.finishedInterBrokerDataMovementInMB() + this.executionTasksSummary.remainingInterBrokerDataToMoveInMB();
    }

    public String uuid() {
        return this.uuid;
    }

    public Set<Integer> recentlyRemovedBrokers() {
        return this.recentlyRemovedBrokers;
    }

    public ExecutionTaskTracker.ExecutionTasksSummary executionTasksSummary() {
        return this.executionTasksSummary;
    }

    private List<Object> getTaskDetails(ExecutionTask.TaskType type, ExecutionTask.State state) {
        ArrayList<Object> taskList = new ArrayList<Object>();
        for (ExecutionTask task : this.executionTasksSummary.filteredTasksByState().get((Object)type).get((Object)state)) {
            taskList.add(task.getJsonStructure());
        }
        return taskList;
    }

    public Map<String, Object> getJsonStructure(boolean verbose) {
        HashMap<String, Object> execState = new HashMap<String, Object>();
        execState.put(STATE, (Object)this.state);
        if (this.recentlyRemovedBrokers != null && !this.recentlyRemovedBrokers.isEmpty()) {
            execState.put(RECENTLY_REMOVED_BROKERS, this.recentlyRemovedBrokers);
        }
        switch (this.state.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                execState.put(TRIGGERED_USER_TASK_ID, this.uuid);
                break;
            }
            case 3: {
                execState.put(TRIGGERED_USER_TASK_ID, this.uuid);
                execState.put(MAXIMUM_CONCURRENT_LEADER_MOVEMENTS, this.maximumConcurrentLeaderMovements);
                execState.put(NUM_PENDING_LEADERSHIP_MOVEMENTS, this.executionTasksSummary.taskStat().get((Object)ExecutionTask.TaskType.LEADER_ACTION).get((Object)ExecutionTask.State.PENDING));
                execState.put(NUM_FINISHED_LEADERSHIP_MOVEMENTS, this.numFinishedMovements(ExecutionTask.TaskType.LEADER_ACTION));
                execState.put(NUM_TOTAL_LEADERSHIP_MOVEMENTS, this.numTotalMovements(ExecutionTask.TaskType.LEADER_ACTION));
                if (!verbose) break;
                execState.put(PENDING_LEADERSHIP_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.LEADER_ACTION, ExecutionTask.State.PENDING));
                break;
            }
            case 2: {
                Map<ExecutionTask.State, Integer> interBrokerPartitionMovementStats = this.executionTasksSummary.taskStat().get((Object)ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION);
                execState.put(TRIGGERED_USER_TASK_ID, this.uuid);
                execState.put(MAXIMUM_CONCURRENT_INTER_BROKER_PARTITION_MOVEMENTS_PER_BROKER, this.maximumConcurrentInterBrokerPartitionMovementsPerBroker);
                execState.put(NUM_IN_PROGRESS_INTER_BROKER_PARTITION_MOVEMENTS, interBrokerPartitionMovementStats.get((Object)ExecutionTask.State.IN_PROGRESS));
                execState.put(NUM_ABORTING_INTER_BROKER_PARTITION_MOVEMENTS, interBrokerPartitionMovementStats.get((Object)ExecutionTask.State.ABORTING));
                execState.put(NUM_PENDING_INTER_BROKER_PARTITION_MOVEMENTS, interBrokerPartitionMovementStats.get((Object)ExecutionTask.State.PENDING));
                execState.put(NUM_FINISHED_INTER_BROKER_PARTITION_MOVEMENTS, this.numFinishedMovements(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION));
                execState.put(NUM_TOTAL_INTER_BROKER_PARTITION_MOVEMENTS, this.numTotalMovements(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION));
                execState.put(FINISHED_INTER_BROKER_DATA_MOVEMENT, this.executionTasksSummary.finishedInterBrokerDataMovementInMB());
                execState.put(TOTAL_INTER_BROKER_DATA_TO_MOVE, this.numTotalInterBrokerDataToMove());
                if (!verbose) break;
                execState.put(IN_PROGRESS_INTER_BROKER_PARTITION_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION, ExecutionTask.State.IN_PROGRESS));
                execState.put(PENDING_INTER_BROKER_PARTITION_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION, ExecutionTask.State.PENDING));
                execState.put(ABORTING_INTER_BROKER_PARTITION_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION, ExecutionTask.State.ABORTING));
                execState.put(ABORTED_INTER_BROKER_PARTITION_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION, ExecutionTask.State.ABORTED));
                execState.put(DEAD_INTER_BROKER_PARTITION_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION, ExecutionTask.State.DEAD));
                execState.put(COMPLETED_INTER_BROKER_PARTITION_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION, ExecutionTask.State.COMPLETED));
                break;
            }
            case 4: {
                Map<ExecutionTask.State, Integer> interBrokerPartitionMovementStats = this.executionTasksSummary.taskStat().get((Object)ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION);
                execState.put(TRIGGERED_USER_TASK_ID, this.uuid);
                execState.put(MAXIMUM_CONCURRENT_INTER_BROKER_PARTITION_MOVEMENTS_PER_BROKER, this.maximumConcurrentInterBrokerPartitionMovementsPerBroker);
                execState.put(MAXIMUM_CONCURRENT_LEADER_MOVEMENTS, this.maximumConcurrentLeaderMovements);
                execState.put(NUM_CANCELLED_LEADERSHIP_MOVEMENTS, this.executionTasksSummary.taskStat().get((Object)ExecutionTask.TaskType.LEADER_ACTION).get((Object)ExecutionTask.State.PENDING));
                execState.put(NUM_IN_PROGRESS_INTER_BROKER_PARTITION_MOVEMENTS, interBrokerPartitionMovementStats.get((Object)ExecutionTask.State.IN_PROGRESS));
                execState.put(NUM_ABORTING_INTER_BROKER_PARTITION_MOVEMENTS, interBrokerPartitionMovementStats.get((Object)ExecutionTask.State.ABORTING));
                execState.put(NUM_CANCELLED_INTER_BROKER_PARTITION_MOVEMENTS, interBrokerPartitionMovementStats.get((Object)ExecutionTask.State.PENDING));
                if (!verbose) break;
                execState.put(CANCELLED_LEADERSHIP_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.LEADER_ACTION, ExecutionTask.State.PENDING));
                execState.put(CANCELLED_INTER_BROKER_PARTITION_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION, ExecutionTask.State.PENDING));
                execState.put(IN_PROGRESS_INTER_BROKER_PARTITION_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION, ExecutionTask.State.IN_PROGRESS));
                execState.put(ABORTING_INTER_BROKER_PARTITION_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION, ExecutionTask.State.ABORTING));
                break;
            }
            default: {
                execState.clear();
                execState.put(ERROR, "ILLEGAL_STATE_EXCEPTION");
            }
        }
        return execState;
    }

    public String getPlaintext() {
        String recentlyRemovedBrokers = this.recentlyRemovedBrokers != null && !this.recentlyRemovedBrokers.isEmpty() ? String.format(", %s: %s", RECENTLY_REMOVED_BROKERS, this.recentlyRemovedBrokers) : "";
        switch (this.state.ordinal()) {
            case 0: {
                return String.format("{%s: %s%s}", new Object[]{STATE, this.state, recentlyRemovedBrokers});
            }
            case 1: {
                return String.format("{%s: %s, %s: %s%s}", new Object[]{STATE, this.state, TRIGGERED_USER_TASK_ID, this.uuid, recentlyRemovedBrokers});
            }
            case 3: {
                return String.format("{%s: %s, finished/total leadership movements: %d/%d, maximum concurrent leadership movements: %d, %s: %s%s}", new Object[]{STATE, this.state, this.numFinishedMovements(ExecutionTask.TaskType.LEADER_ACTION), this.numTotalMovements(ExecutionTask.TaskType.LEADER_ACTION), this.maximumConcurrentLeaderMovements, TRIGGERED_USER_TASK_ID, this.uuid, recentlyRemovedBrokers});
            }
            case 2: {
                Map<ExecutionTask.State, Integer> interBrokerPartitionMovementStats = this.executionTasksSummary.taskStat().get((Object)ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION);
                return String.format("{%s: %s, pending/in-progress/aborting/finished/total inter-broker partition movement %d/%d/%d/%d/%d, completed/total bytes(MB): %d/%d, maximum concurrent inter-broker partition movements per-broker: %d, %s: %s%s}", new Object[]{STATE, this.state, interBrokerPartitionMovementStats.get((Object)ExecutionTask.State.PENDING), interBrokerPartitionMovementStats.get((Object)ExecutionTask.State.IN_PROGRESS), interBrokerPartitionMovementStats.get((Object)ExecutionTask.State.ABORTING), this.numFinishedMovements(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION), this.numTotalMovements(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION), this.executionTasksSummary.finishedInterBrokerDataMovementInMB(), this.numTotalInterBrokerDataToMove(), this.maximumConcurrentInterBrokerPartitionMovementsPerBroker, TRIGGERED_USER_TASK_ID, this.uuid, recentlyRemovedBrokers});
            }
            case 4: {
                Map<ExecutionTask.State, Integer> interBrokerPartitionMovementStats = this.executionTasksSummary.taskStat().get((Object)ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION);
                return String.format("{%s: %s, cancelled/in-progress/aborting/total inter-broker partition movements movements: %d/%d/%d/%d,cancelled/total leadership movements: %d/%d, maximum concurrent inter-broker partition movements per-broker: %d, maximum concurrent leadership movements: %d, %s: %s%s}", new Object[]{STATE, this.state, interBrokerPartitionMovementStats.get((Object)ExecutionTask.State.PENDING), interBrokerPartitionMovementStats.get((Object)ExecutionTask.State.IN_PROGRESS), interBrokerPartitionMovementStats.get((Object)ExecutionTask.State.ABORTING), this.numTotalMovements(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION), this.executionTasksSummary.taskStat().get((Object)ExecutionTask.TaskType.LEADER_ACTION).get((Object)ExecutionTask.State.PENDING), this.numTotalMovements(ExecutionTask.TaskType.LEADER_ACTION), this.maximumConcurrentInterBrokerPartitionMovementsPerBroker, this.maximumConcurrentLeaderMovements, TRIGGERED_USER_TASK_ID, this.uuid, recentlyRemovedBrokers});
            }
        }
        throw new IllegalStateException("This should never happen");
    }

    public static enum State {
        NO_TASK_IN_PROGRESS,
        STARTING_EXECUTION,
        INTER_BROKER_REPLICA_MOVEMENT_TASK_IN_PROGRESS,
        LEADER_MOVEMENT_TASK_IN_PROGRESS,
        STOPPING_EXECUTION;

    }
}

