/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.executor;

import com.linkedin.kafka.cruisecontrol.model.Rack;
import com.linkedin.kafka.cruisecontrol.model.ReplicaId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;

public class PartitionProposal {
    private static final String TOPIC_PARTITION = "topicPartition";
    private static final String OLD_LEADER = "oldLeader";
    private static final String OLD_REPLICAS = "oldReplicas";
    private static final String NEW_REPLICAS = "newReplicas";
    private final TopicPartition tp;
    private final long partitionSize;
    private final ReplicaId oldLeader;
    private final ReplicaId newLeader;
    private final List<ReplicaId> oldReplicas;
    private final List<ReplicaId> newReplicas;
    private final List<ReplicaId> oldObservers;
    private final List<ReplicaId> newObservers;
    private final List<ReplicaId> replicasToAdd;
    private final List<ReplicaId> replicasToRemove;
    private final boolean isLeadershipShuffle;
    private final List<ReplicaId> replicasAdded;
    private final Set<ReplicaId> replicasRemoved;
    private final Map<Integer, Rack> brokerIdToRack;
    private ReplicaId replicaToAdd;
    private ReplicaId replicaToRemove;

    public PartitionProposal(TopicPartition tp, long partitionSize, ReplicaId oldLeader, List<ReplicaId> oldReplicas, List<ReplicaId> newReplicas, List<ReplicaId> oldObservers, List<ReplicaId> newObservers, Map<Integer, Rack> brokerIdToRack) {
        this.tp = tp;
        this.partitionSize = partitionSize;
        this.oldLeader = oldLeader;
        this.newLeader = newReplicas.get(0);
        this.oldReplicas = oldReplicas == null ? Collections.emptyList() : oldReplicas;
        this.newReplicas = newReplicas;
        this.oldObservers = oldObservers;
        this.newObservers = newObservers;
        this.brokerIdToRack = brokerIdToRack;
        this.validate();
        Set newBrokerList = this.newReplicas.stream().mapToInt(ReplicaId::brokerId).boxed().collect(Collectors.toSet());
        Set oldBrokerList = this.oldReplicas.stream().mapToInt(ReplicaId::brokerId).boxed().collect(Collectors.toSet());
        this.replicasToAdd = this.newReplicas.stream().filter(r -> !oldBrokerList.contains(r.brokerId())).collect(Collectors.toList());
        this.replicasToRemove = this.oldReplicas.stream().filter(r -> !newBrokerList.contains(r.brokerId())).collect(Collectors.toList());
        Collections.reverse(this.replicasToRemove);
        this.isLeadershipShuffle = this.replicasToAdd.isEmpty() && this.replicasToRemove.isEmpty() && !this.oldLeader.equals(this.newLeader);
        this.replicasAdded = new ArrayList<ReplicaId>();
        this.replicasRemoved = new HashSet<ReplicaId>();
    }

    public PartitionProposal(TopicPartition tp, long partitionSize, ReplicaId oldLeader, List<ReplicaId> oldReplicas, List<ReplicaId> newReplicas, List<ReplicaId> oldObservers, List<ReplicaId> newObservers) {
        this(tp, partitionSize, oldLeader, oldReplicas, newReplicas, oldObservers, newObservers, new HashMap<Integer, Rack>());
    }

    private boolean brokerOrderMatched(Node[] currentOrderedReplicas, List<ReplicaId> replicas) {
        if (replicas.size() != currentOrderedReplicas.length) {
            return false;
        }
        for (int i = 0; i < replicas.size(); ++i) {
            if (currentOrderedReplicas[i].id() == replicas.get(i).brokerId().intValue()) continue;
            return false;
        }
        return true;
    }

    public boolean isInterBrokerMovementCompleted(Node[] currentOrderedReplicas, Node[] currentOrderedObservers) {
        return this.brokerOrderMatched(currentOrderedReplicas, this.newReplicas) && this.brokerOrderMatched(currentOrderedObservers, this.newObservers);
    }

    public boolean isInterBrokerMovementAborted(Node[] currentOrderedReplicas, Node[] currentOrderedObservers) {
        return this.isInterBrokerMovementCompleted(currentOrderedReplicas, currentOrderedObservers) || this.brokerOrderMatched(currentOrderedReplicas, this.oldReplicas) && this.brokerOrderMatched(currentOrderedObservers, this.oldObservers);
    }

    public String topic() {
        return this.tp.topic();
    }

    public int partitionId() {
        return this.tp.partition();
    }

    public TopicPartition topicPartition() {
        return this.tp;
    }

    public ReplicaId oldLeader() {
        return this.oldLeader;
    }

    public ReplicaId newLeader() {
        return this.newReplicas.get(0);
    }

    public List<ReplicaId> oldReplicas() {
        return this.oldReplicas;
    }

    public List<ReplicaId> newReplicas() {
        return this.newReplicas;
    }

    public List<ReplicaId> newObservers() {
        return this.newObservers;
    }

    public List<ReplicaId> replicasToAdd() {
        return this.replicasToAdd;
    }

    public List<ReplicaId> replicasToRemove() {
        return this.replicasToRemove;
    }

    ReplicaId replicaToRemove() {
        return this.replicaToRemove;
    }

    public boolean hasReplicaAction() {
        return !new HashSet<ReplicaId>(this.oldReplicas).equals(new HashSet<ReplicaId>(this.newReplicas));
    }

    public boolean hasLeaderAction() {
        return this.oldLeader != this.newReplicas.get(0);
    }

    public boolean isLeadershipShuffle() {
        return this.isLeadershipShuffle;
    }

    public ReplicaId replicaToAdd() {
        return this.replicaToAdd;
    }

    public List<ReplicaId> proposedReplicas() {
        if (this.isLeadershipShuffle || this.replicasToAdd.size() == 1) {
            return new ArrayList<ReplicaId>(this.newReplicas);
        }
        ArrayList<ReplicaId> proposedReplicas = new ArrayList<ReplicaId>(this.oldReplicas);
        proposedReplicas.addAll(this.replicasAdded);
        if (this.replicaToAdd != null) {
            proposedReplicas.add(this.replicaToAdd);
        }
        proposedReplicas.removeAll(this.replicasRemoved);
        if (this.replicaToRemove != null) {
            proposedReplicas.remove(this.replicaToRemove);
        }
        return proposedReplicas;
    }

    public boolean isReplicaInSameRackAsOldLeader(ReplicaId replicaId) {
        if (!this.brokerIdToRack.containsKey(replicaId.brokerId()) || !this.brokerIdToRack.containsKey(this.oldLeader.brokerId())) {
            return false;
        }
        return this.brokerIdToRack.get(replicaId.brokerId()).equals(this.brokerIdToRack.get(this.oldLeader.brokerId()));
    }

    public void proposeReplicaToAdd(ReplicaId replicaToAdd) {
        this.replicaToAdd = replicaToAdd;
        this.replicaToRemove = null;
        for (ReplicaId replicaToRemove : this.replicasToRemove) {
            if (this.replicasRemoved.contains(replicaToRemove) || !this.brokerIdToRack.containsKey(replicaToAdd.brokerId()) || !this.brokerIdToRack.containsKey(replicaToRemove.brokerId()) || !this.brokerIdToRack.get(replicaToAdd.brokerId()).equals(this.brokerIdToRack.get(replicaToRemove.brokerId()))) continue;
            this.replicaToRemove = replicaToRemove;
            return;
        }
        for (ReplicaId replicaToRemove : this.replicasToRemove) {
            if (this.replicasRemoved.contains(replicaToRemove)) continue;
            this.replicaToRemove = replicaToRemove;
            return;
        }
    }

    public void finishAddingReplica() {
        this.replicasAdded.add(this.replicaToAdd);
        this.replicasToAdd.remove(this.replicaToAdd);
        this.replicaToAdd = null;
        if (this.replicaToRemove != null) {
            this.replicasRemoved.add(this.replicaToRemove);
            this.replicaToRemove = null;
        }
    }

    public int numReplicasToAddInSameRackAsOldLeader() {
        int ct = 0;
        for (ReplicaId replicaId : this.replicasToAdd) {
            if (!this.brokerIdToRack.containsKey(this.oldLeader.brokerId()) || !this.brokerIdToRack.containsKey(replicaId.brokerId()) || !this.brokerIdToRack.get(this.oldLeader.brokerId()).equals(this.brokerIdToRack.get(replicaId.brokerId()))) continue;
            ++ct;
        }
        return ct;
    }

    public boolean wouldCompleteAfterCurrentReassignment() {
        return this.replicasToAdd.size() == 1;
    }

    public boolean completed() {
        return this.replicasToAdd.isEmpty();
    }

    public long interBrokerDataToMoveInMB() {
        return (long)this.replicasToAdd.size() * this.partitionSize;
    }

    public long singleDestinationBrokerDataToReceiveInMB() {
        return this.partitionSize;
    }

    public long dataToMoveInMB() {
        return (long)this.replicasToAdd.size() * this.partitionSize;
    }

    public int replicaMovementParallelism() {
        return this.replicasToAdd.size();
    }

    private void validate() {
        if (this.oldLeader.brokerId() >= 0 && !this.oldReplicas.contains(this.oldLeader)) {
            throw new IllegalArgumentException(String.format("The old leader %s does not exist in the old replica list %s", this.oldLeader, this.oldReplicas));
        }
        if (this.newReplicas == null || this.newReplicas.isEmpty()) {
            throw new IllegalArgumentException("The new replica list " + String.valueOf(this.newReplicas) + " cannot be empty.");
        }
        HashSet<ReplicaId> replicaSet = new HashSet<ReplicaId>(this.newReplicas);
        if (replicaSet.size() != this.newReplicas.size()) {
            throw new IllegalArgumentException("The new replicas list " + String.valueOf(this.newReplicas) + " has duplicate replica.");
        }
    }

    public Map<String, Object> getJsonStructure() {
        HashMap<String, Object> proposalMap = new HashMap<String, Object>(4);
        proposalMap.put(TOPIC_PARTITION, this.tp);
        proposalMap.put(OLD_LEADER, this.oldLeader.brokerId());
        proposalMap.put(OLD_REPLICAS, this.oldReplicas.stream().mapToInt(ReplicaId::brokerId).boxed().collect(Collectors.toList()));
        proposalMap.put(NEW_REPLICAS, this.newReplicas.stream().mapToInt(ReplicaId::brokerId).boxed().collect(Collectors.toList()));
        return proposalMap;
    }

    public String toString() {
        return String.format("{%s, leader: %d -> %d, replicas: %s -> %s, observers: %s -> %s, proposedReplicas: %s, replicasAdded: %s replicasToAdd: %s %s%s}", this.tp, this.oldLeader.brokerId(), this.newLeader.brokerId(), this.oldReplicas.stream().mapToInt(ReplicaId::brokerId).boxed().collect(Collectors.toList()), this.newReplicas.stream().mapToInt(ReplicaId::brokerId).boxed().collect(Collectors.toList()), this.oldObservers.stream().mapToInt(ReplicaId::brokerId).boxed().collect(Collectors.toList()), this.newObservers.stream().mapToInt(ReplicaId::brokerId).boxed().collect(Collectors.toList()), this.proposedReplicas().stream().mapToInt(ReplicaId::brokerId).boxed().collect(Collectors.toList()), this.replicasAdded.stream().mapToInt(ReplicaId::brokerId).boxed().collect(Collectors.toList()), this.replicasToAdd.stream().mapToInt(ReplicaId::brokerId).boxed().collect(Collectors.toList()), this.replicaToAdd == null ? "" : ", replicaToAdd: " + this.replicaToAdd.brokerId(), this.replicaToRemove == null ? "" : ", replicaToRemove: " + this.replicaToRemove.brokerId());
    }

    public boolean equals(Object other) {
        if (!(other instanceof PartitionProposal)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        PartitionProposal otherProposal = (PartitionProposal)other;
        return this.tp.equals((Object)otherProposal.tp) && this.oldLeader == otherProposal.oldLeader && this.oldReplicas.equals(otherProposal.oldReplicas) && this.newReplicas.equals(otherProposal.newReplicas) && this.oldObservers.equals(otherProposal.oldObservers) && this.newObservers.equals(otherProposal.newObservers);
    }

    public int hashCode() {
        int result = this.tp.hashCode();
        result = 31 * result + this.oldLeader.hashCode();
        for (ReplicaId replica : this.oldReplicas) {
            result = 31 * result + replica.hashCode();
        }
        for (ReplicaId replica : this.newReplicas) {
            result = 31 * result + replica.hashCode();
        }
        for (ReplicaId replica : this.oldObservers) {
            result = 31 * result + replica.hashCode();
        }
        for (ReplicaId replica : this.newObservers) {
            result = 31 * result + replica.hashCode();
        }
        return result;
    }
}

