/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.metricsreporter.metric;

import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.BrokerMetric;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.CruiseControlMetric;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.PartitionMetric;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.RawMetricType;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.TopicMetric;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.YammerMetricWrapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.MetricName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsUtils.class);
    private static final String BYTES_IN_PER_SEC = "BytesInPerSec";
    private static final String BYTES_OUT_PER_SEC = "BytesOutPerSec";
    private static final String FETCH_FROM_FOLLOWER_BYTES_OUT_PER_SEC = "FetchFromFollowerBytesOutPerSec";
    private static final String NON_FFF_BYTES_OUT_PER_SEC = "NonFffBytesOutPerSec";
    private static final String REPLICATION_BYTES_IN_PER_SEC = "ReplicationBytesInPerSec";
    private static final String REPLICATION_BYTES_OUT_PER_SEC = "ReplicationBytesOutPerSec";
    private static final String REQUESTS_PER_SEC = "RequestsPerSec";
    private static final String LOCAL_TIME_MS = "LocalTimeMs";
    private static final String TOTAL_TIME_MS = "TotalTimeMs";
    private static final String TOTAL_FETCH_REQUEST_PER_SEC = "TotalFetchRequestsPerSec";
    private static final String TOTAL_FETCH_FROM_FOLLOWER_REQUEST_PER_SEC = "FetchFromFollowerFetchRequestsPerSec";
    private static final String TOTAL_FOLLOWER_FETCH_REQUEST_PER_SEC = "TotalFollowerFetchRequestsPerSec";
    private static final String TOTAL_PRODUCE_REQUEST_PER_SEC = "TotalProduceRequestsPerSec";
    private static final String MESSAGES_IN_PER_SEC = "MessagesInPerSec";
    private static final String SIZE = "Size";
    private static final String LOG_FLUSH_RATE_AND_TIME_MS = "LogFlushRateAndTimeMs";
    private static final String CPU_USAGE = "CpuUsage";
    private static final String KAFKA_SERVER = "kafka.server";
    private static final String KAFKA_LOG = "kafka.log";
    private static final String KAFKA_NETWORK = "kafka.network";
    private static final String TYPE_KEY = "type";
    private static final String TOPIC_KEY = "topic";
    private static final String PARTITION_KEY = "partition";
    private static final String REQUEST_TYPE_KEY = "request";
    private static final String BROKER_TOPIC_METRICS_GROUP = "BrokerTopicMetrics";
    private static final String LOG_GROUP = "Log";
    private static final String LOG_FLUSH_STATS_GROUP = "LogFlushStats";
    private static final String REQUEST_METRICS_GROUP = "RequestMetrics";
    private static final String REQUEST_CHANNEL_GROUP = "RequestChannel";
    private static final String REQUEST_KAFKA_HANDLER_POOL_GROUP = "KafkaRequestHandlerPool";
    private static final String CONSUMER_FETCH_REQUEST_TYPE = "FetchConsumer";
    private static final String FOLLOWER_FETCH_REQUEST_TYPE = "FetchFollower";
    private static final String PRODUCE_REQUEST_TYPE = "Produce";
    public static final String ATTRIBUTE_MEAN = "Mean";
    public static final String ATTRIBUTE_MAX = "Max";
    static final String ATTRIBUTE_50TH_PERCENTILE = "50thPercentile";
    static final String ATTRIBUTE_999TH_PERCENTILE = "999thPercentile";
    private static final Set<String> INTERESTED_NETWORK_METRIC_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("RequestsPerSec", "LocalTimeMs", "TotalTimeMs")));
    private static final Set<String> INTERESTED_TOPIC_METRIC_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("BytesInPerSec", "BytesOutPerSec", "ReplicationBytesInPerSec", "ReplicationBytesOutPerSec", "TotalFetchRequestsPerSec", "TotalProduceRequestsPerSec", "MessagesInPerSec")));
    private static final Set<String> INTERESTED_LOG_METRIC_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("Size", "LogFlushRateAndTimeMs")));
    private static final Set<String> INTERESTED_REQUEST_TYPE = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("FetchConsumer", "FetchFollower", "Produce")));

    private MetricsUtils() {
    }

    public static CruiseControlMetric toCruiseControlMetric(long now, int brokerId, YammerMetricWrapper metricWrapper, double value) {
        return MetricsUtils.toCruiseControlMetric(now, brokerId, metricWrapper, value, null);
    }

    public static CruiseControlMetric toCruiseControlMetric(long now, int brokerId, YammerMetricWrapper metricWrapper, double value, String attribute) {
        CruiseControlMetric ccm = MetricsUtils.toCruiseControlMetric(now, brokerId, metricWrapper.metricName().getName(), metricWrapper.tags(), value, attribute);
        if (ccm == null) {
            throw new IllegalArgumentException(String.format("Cannot convert yammer metric %s to a Cruise Control metric for broker %d at time %d for tag %s", metricWrapper.metricName(), brokerId, now, attribute));
        }
        return ccm;
    }

    public static boolean isInterested(MetricName metricName) {
        String type;
        String name;
        String group = metricName.group();
        return MetricsUtils.isInterestedServerMetric(group, name = metricName.name(), type = (String)metricName.tags().get(TYPE_KEY)) || MetricsUtils.isInterestedLogMetric(group, name, type) || MetricsUtils.isInterestedNetworkMetric(group, name, type, metricName.tags());
    }

    public static boolean isInterested(YammerMetricWrapper metricWrapper) {
        String type;
        String name;
        String group = metricWrapper.metricName().getGroup();
        return MetricsUtils.isInterestedServerMetric(group, name = metricWrapper.metricName().getName(), type = metricWrapper.metricName().getType()) || MetricsUtils.isInterestedLogMetric(group, name, type) || MetricsUtils.isInterestedNetworkMetric(metricWrapper);
    }

    public static Map<String, String> yammerMetricScopeToTags(String scope) {
        if (scope != null) {
            String[] kv = scope.split("\\.");
            assert (kv.length % 2 == 0);
            HashMap<String, String> tags = new HashMap<String, String>();
            for (int i = 0; i < kv.length; i += 2) {
                tags.put(kv[i], kv[i + 1]);
            }
            return tags;
        }
        return Collections.emptyMap();
    }

    private static boolean isInterestedServerMetric(String group, String name, String type) {
        return group.equals(KAFKA_SERVER) && (INTERESTED_TOPIC_METRIC_NAMES.contains(name) && BROKER_TOPIC_METRICS_GROUP.equals(type) || REQUEST_KAFKA_HANDLER_POOL_GROUP.equals(type));
    }

    private static boolean isInterestedLogMetric(String group, String name, String type) {
        return group.equals(KAFKA_LOG) && INTERESTED_LOG_METRIC_NAMES.contains(name) && (LOG_GROUP.equals(type) || LOG_FLUSH_STATS_GROUP.equals(type));
    }

    private static boolean isInterestedNetworkMetric(String group, String name, String type, Map<String, String> tags) {
        return group.equals(KAFKA_NETWORK) && INTERESTED_NETWORK_METRIC_NAMES.contains(name) && (REQUEST_CHANNEL_GROUP.equals(type) || REQUEST_METRICS_GROUP.equals(type) && INTERESTED_REQUEST_TYPE.contains(tags.get(REQUEST_TYPE_KEY)));
    }

    private static boolean isInterestedNetworkMetric(YammerMetricWrapper metricWrapper) {
        String group = metricWrapper.metricName().getGroup();
        String name = metricWrapper.metricName().getName();
        String type = metricWrapper.metricName().getType();
        return group.equals(KAFKA_NETWORK) && INTERESTED_NETWORK_METRIC_NAMES.contains(name) && (REQUEST_CHANNEL_GROUP.equals(type) || REQUEST_METRICS_GROUP.equals(type) && INTERESTED_REQUEST_TYPE.contains(metricWrapper.tags().get(REQUEST_TYPE_KEY)));
    }

    public static CruiseControlMetric toCruiseControlMetric(long now, int brokerId, String name, Map<String, String> tags, double value) {
        return MetricsUtils.toCruiseControlMetric(now, brokerId, name, tags, value, null);
    }

    private static CruiseControlMetric toCruiseControlMetric(long now, int brokerId, String name, Map<String, String> tags, double value, String attribute) {
        String topic = tags.get(TOPIC_KEY);
        switch (name) {
            case "BytesInPerSec": {
                if (topic != null) {
                    return new TopicMetric(RawMetricType.TOPIC_BYTES_IN, now, brokerId, topic, value);
                }
                return new BrokerMetric(RawMetricType.ALL_TOPIC_BYTES_IN, now, brokerId, value);
            }
            case "BytesOutPerSec": {
                if (topic != null) {
                    return new TopicMetric(RawMetricType.TOPIC_BYTES_OUT, now, brokerId, topic, value);
                }
                return new BrokerMetric(RawMetricType.ALL_TOPIC_BYTES_OUT, now, brokerId, value);
            }
            case "FetchFromFollowerBytesOutPerSec": {
                if (topic != null) {
                    return new TopicMetric(RawMetricType.TOPIC_FETCH_FROM_FOLLOWER_BYTES_OUT, now, brokerId, topic, value);
                }
                return new BrokerMetric(RawMetricType.ALL_TOPIC_FETCH_FROM_FOLLOWER_BYTES_OUT, now, brokerId, value);
            }
            case "NonFffBytesOutPerSec": {
                if (topic != null) {
                    return new TopicMetric(RawMetricType.TOPIC_NON_FFF_BYTES_OUT, now, brokerId, topic, value);
                }
                return new BrokerMetric(RawMetricType.ALL_TOPIC_NON_FFF_BYTES_OUT, now, brokerId, value);
            }
            case "ReplicationBytesInPerSec": {
                if (topic != null) {
                    return new TopicMetric(RawMetricType.TOPIC_REPLICATION_BYTES_IN, now, brokerId, topic, value);
                }
                return new BrokerMetric(RawMetricType.ALL_TOPIC_REPLICATION_BYTES_IN, now, brokerId, value);
            }
            case "ReplicationBytesOutPerSec": {
                if (topic != null) {
                    return new TopicMetric(RawMetricType.TOPIC_REPLICATION_BYTES_OUT, now, brokerId, topic, value);
                }
                return new BrokerMetric(RawMetricType.ALL_TOPIC_REPLICATION_BYTES_OUT, now, brokerId, value);
            }
            case "TotalFetchRequestsPerSec": {
                if (topic != null) {
                    return new TopicMetric(RawMetricType.TOPIC_FETCH_REQUEST_RATE, now, brokerId, topic, value);
                }
                return new BrokerMetric(RawMetricType.ALL_TOPIC_FETCH_REQUEST_RATE, now, brokerId, value);
            }
            case "FetchFromFollowerFetchRequestsPerSec": {
                if (topic != null) {
                    return new TopicMetric(RawMetricType.TOPIC_FETCH_FROM_FOLLOWER_REQUEST_RATE, now, brokerId, topic, value);
                }
                return new BrokerMetric(RawMetricType.ALL_TOPIC_FETCH_FROM_FOLLOWER_REQUEST_RATE, now, brokerId, value);
            }
            case "TotalFollowerFetchRequestsPerSec": {
                if (topic != null) {
                    return new TopicMetric(RawMetricType.TOPIC_FOLLOWER_FETCH_REQUEST_RATE, now, brokerId, topic, value);
                }
                return new BrokerMetric(RawMetricType.ALL_TOPIC_FOLLOWER_FETCH_REQUEST_RATE, now, brokerId, value);
            }
            case "TotalProduceRequestsPerSec": {
                if (topic != null) {
                    return new TopicMetric(RawMetricType.TOPIC_PRODUCE_REQUEST_RATE, now, brokerId, topic, value);
                }
                return new BrokerMetric(RawMetricType.ALL_TOPIC_PRODUCE_REQUEST_RATE, now, brokerId, value);
            }
            case "MessagesInPerSec": {
                if (topic != null) {
                    return new TopicMetric(RawMetricType.TOPIC_MESSAGES_IN_PER_SEC, now, brokerId, topic, value);
                }
                return new BrokerMetric(RawMetricType.ALL_TOPIC_MESSAGES_IN_PER_SEC, now, brokerId, value);
            }
            case "RequestsPerSec": {
                switch (tags.get(REQUEST_TYPE_KEY)) {
                    case "Produce": {
                        return new BrokerMetric(RawMetricType.BROKER_PRODUCE_REQUEST_RATE, now, brokerId, value);
                    }
                    case "FetchConsumer": {
                        return new BrokerMetric(RawMetricType.BROKER_CONSUMER_FETCH_REQUEST_RATE, now, brokerId, value);
                    }
                    case "FetchFollower": {
                        return new BrokerMetric(RawMetricType.BROKER_FOLLOWER_FETCH_REQUEST_RATE, now, brokerId, value);
                    }
                }
                return null;
            }
            case "Size": {
                int partition = Integer.parseInt(tags.get(PARTITION_KEY));
                return new PartitionMetric(RawMetricType.PARTITION_SIZE, now, brokerId, topic, partition, value);
            }
            case "CpuUsage": {
                return new BrokerMetric(RawMetricType.BROKER_CPU_UTIL, now, brokerId, value);
            }
        }
        return null;
    }
}

