/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.kafka.cruisecontrol.common.CellResource;
import java.util.Objects;

public class CellResourceLoad
implements Comparable<CellResourceLoad> {
    private final CellResource cellResource;
    private final double ratio;

    public CellResourceLoad(CellResource cellResource, double ratio) {
        this.cellResource = Objects.requireNonNull(cellResource, "CellResource cannot be null.");
        this.ratio = ratio;
    }

    public CellResource cellResource() {
        return this.cellResource;
    }

    public CellResourceLoad(CellResourceLoad other) {
        this.cellResource = other.cellResource;
        this.ratio = other.ratio;
    }

    public double ratio() {
        return this.ratio;
    }

    @Override
    public int compareTo(CellResourceLoad that) {
        double result = this.ratio - that.ratio;
        if (result < 0.0) {
            return -1;
        }
        if (result == 0.0) {
            return this.cellResource.id() - that.cellResource.id();
        }
        return 1;
    }

    public String toString() {
        return "CellResourceLoad{cellResource=" + String.valueOf((Object)this.cellResource) + ", ratio=" + this.ratio + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CellResourceLoad that = (CellResourceLoad)o;
        if (Double.compare(this.ratio, that.ratio) != 0) {
            return false;
        }
        return this.cellResource == that.cellResource;
    }

    public int hashCode() {
        int result = this.cellResource.hashCode();
        long temp = Double.doubleToLongBits(this.ratio);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

