/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregatedMetricValues;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import org.apache.kafka.common.TopicPartition;

public final class LeadershipLoadDeltaCalculator {
    private static final Resource[] LEADERSHIP_DELTA_CONTRIBUTORS = new Resource[]{Resource.CPU, Resource.NW_OUT, Resource.PRODUCE_IN, Resource.CONSUME_OUT, Resource.MIRROR_IN, Resource.REPLICATION_IN, Resource.RACK_LESS_CONSUME_OUT};
    private final TopicPartition tp;
    private final Broker sourceBroker;
    private final Broker destinationBroker;

    LeadershipLoadDeltaCalculator(TopicPartition tp, Broker sourceBroker, Broker destinationBroker) {
        this.tp = tp;
        this.sourceBroker = sourceBroker;
        this.destinationBroker = destinationBroker;
    }

    AggregatedMetricValues calculateLeadershipLoadDelta() {
        AggregatedMetricValues leadershipLoadDelta = new AggregatedMetricValues();
        Replica sourceReplica = this.sourceBroker.replica(this.tp);
        Replica destinationReplica = this.destinationBroker.replica(this.tp);
        for (Resource resource : LEADERSHIP_DELTA_CONTRIBUTORS) {
            AggregatedMetricValues sourceReplicaMetricValues = sourceReplica.load().loadFor(resource, true);
            leadershipLoadDelta.add(sourceReplicaMetricValues);
            AggregatedMetricValues destinationReplicaMetricValues = destinationReplica.load().loadFor(resource, true);
            leadershipLoadDelta.subtract(destinationReplicaMetricValues);
        }
        return leadershipLoadDelta;
    }
}

