/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregatedMetricValues;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaRelocationContext {
    private final Map<Integer, AggregatedMetricValues> brokerIdToReplicaLoadMap = new HashMap<Integer, AggregatedMetricValues>();
    private static final Logger LOG = LoggerFactory.getLogger(ReplicaRelocationContext.class);

    private ReplicaRelocationContext() {
    }

    public static ReplicaRelocationContext forReplicaSwapAction(Replica sourceReplica, Replica destinationReplica) {
        ReplicaRelocationContext replicaRelocationContext = new ReplicaRelocationContext();
        if (sourceReplica.topicPartition().equals((Object)destinationReplica.topicPartition())) {
            replicaRelocationContext.brokerIdToReplicaLoadMap.put(destinationReplica.broker().id(), ReplicaRelocationContext.getDestinationBrokerLoadForSamePartitionReplicaSwap(sourceReplica, destinationReplica));
            replicaRelocationContext.brokerIdToReplicaLoadMap.put(sourceReplica.broker().id(), ReplicaRelocationContext.getDestinationBrokerLoadForSamePartitionReplicaSwap(destinationReplica, sourceReplica));
        } else {
            replicaRelocationContext.brokerIdToReplicaLoadMap.put(destinationReplica.broker().id(), new AggregatedMetricValues(sourceReplica.load().loadByWindows()));
            replicaRelocationContext.brokerIdToReplicaLoadMap.put(sourceReplica.broker().id(), new AggregatedMetricValues(destinationReplica.load().loadByWindows()));
        }
        return replicaRelocationContext;
    }

    private static AggregatedMetricValues getDestinationBrokerLoadForSamePartitionReplicaSwap(Replica sourceReplica, Replica destinationReplica) {
        AggregatedMetricValues metricValues = new AggregatedMetricValues();
        metricValues.add(sourceReplica.load().loadForRackLessResources());
        metricValues.add(destinationReplica.load().loadForRackBasedResources());
        return metricValues;
    }

    public static ReplicaRelocationContext forReplicaMovementAction(Replica sourceReplica, int destinationBrokerId) {
        ReplicaRelocationContext replicaRelocationContext = new ReplicaRelocationContext();
        replicaRelocationContext.brokerIdToReplicaLoadMap.put(destinationBrokerId, new AggregatedMetricValues(sourceReplica.load().loadByWindows()));
        return replicaRelocationContext;
    }

    public static ReplicaRelocationContext forPartitionMovementAction(Map<Replica, Broker> replicaMoves) {
        ReplicaRelocationContext replicaRelocationContext = new ReplicaRelocationContext();
        replicaMoves.forEach((sourceReplica, destinationBroker) -> replicaRelocationContext.brokerIdToReplicaLoadMap.put(destinationBroker.id(), new AggregatedMetricValues(sourceReplica.load().loadByWindows())));
        return replicaRelocationContext;
    }

    public AggregatedMetricValues getLoadForBroker(int brokerId) {
        if (!this.brokerIdToReplicaLoadMap.containsKey(brokerId)) {
            throw new IllegalArgumentException("BrokerId not found in the replica relocation context");
        }
        return this.brokerIdToReplicaLoadMap.get(brokerId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ReplicaRelocationContext replicaRelocationContext = (ReplicaRelocationContext)obj;
        return this.brokerIdToReplicaLoadMap.equals(replicaRelocationContext.brokerIdToReplicaLoadMap);
    }

    public int hashCode() {
        return !this.brokerIdToReplicaLoadMap.isEmpty() ? this.brokerIdToReplicaLoadMap.hashCode() : 0;
    }
}

