/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.kafka.cruisecontrol.common.Resource;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;

public enum TenantResource {
    CPU(0, Resource.CPU),
    NW_IN(1, Resource.NW_IN),
    NW_OUT(2, Resource.NW_OUT),
    PRODUCE_IN(3, Resource.PRODUCE_IN),
    CONSUME_OUT(4, Resource.CONSUME_OUT),
    REPLICA_COUNT(5, null);

    private static final Collection<TenantResource> CACHED_VALUES;
    private final int id;
    private final Resource resource;

    private TenantResource(int id, Resource resource) {
        this.id = id;
        this.resource = resource;
    }

    public static Collection<TenantResource> cachedValues() {
        return CACHED_VALUES;
    }

    public int id() {
        return this.id;
    }

    public Resource resource() {
        return this.resource;
    }

    static {
        CACHED_VALUES = Collections.unmodifiableSet(EnumSet.allOf(TenantResource.class));
    }
}

