/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.kafka.cruisecontrol.model.TopicImbalanceScoreType;
import java.util.HashMap;
import java.util.Map;

public class TopicImbalanceScore {
    private double replicaDistributionBased = Double.MAX_VALUE;
    private Map<Integer, Double> replicaDistributionBasedPerCell;
    private double partitionDistributionBased = Double.MAX_VALUE;

    public TopicImbalanceScore() {
        this.replicaDistributionBasedPerCell = new HashMap<Integer, Double>();
    }

    public Double getImbalanceScore(TopicImbalanceScoreType imbalanceScoreType) {
        switch (imbalanceScoreType) {
            case REPLICA_DISTRIBUTION_BASED: {
                return this.replicaDistributionBased;
            }
            case PARTITION_DISTRIBUTION_BASED: {
                return this.partitionDistributionBased;
            }
        }
        throw new IllegalArgumentException("UnSupported imbalance score type " + String.valueOf((Object)imbalanceScoreType) + " provided.");
    }

    public Double getImbalanceScore(TopicImbalanceScoreType imbalanceScoreType, int cellId) {
        switch (imbalanceScoreType) {
            case REPLICA_DISTRIBUTION_BASED: {
                return this.replicaDistributionBasedPerCell.getOrDefault(cellId, (Double)Double.MAX_VALUE);
            }
            case PARTITION_DISTRIBUTION_BASED: {
                throw new IllegalArgumentException("PARTITION_DISTRIBUTION_BASED imbalance score is currently not supported at cell level");
            }
        }
        throw new IllegalArgumentException("Unsupported imbalance score type " + String.valueOf((Object)imbalanceScoreType) + " provided.");
    }

    public void setImbalanceScore(Double score, TopicImbalanceScoreType imbalanceScoreType) {
        switch (imbalanceScoreType) {
            case REPLICA_DISTRIBUTION_BASED: {
                this.replicaDistributionBased = score;
                return;
            }
            case PARTITION_DISTRIBUTION_BASED: {
                this.partitionDistributionBased = score;
                return;
            }
        }
        throw new IllegalArgumentException("UnSupported imbalance score type " + String.valueOf((Object)imbalanceScoreType) + " provided.");
    }

    public void setImbalanceScore(Double score, TopicImbalanceScoreType imbalanceScoreType, int cellId) {
        switch (imbalanceScoreType) {
            case REPLICA_DISTRIBUTION_BASED: {
                this.replicaDistributionBasedPerCell.put(cellId, score);
                return;
            }
            case PARTITION_DISTRIBUTION_BASED: {
                throw new IllegalArgumentException("PARTITION_DISTRIBUTION_BASED imbalance score is currently not supported at cell level");
            }
        }
        throw new IllegalArgumentException("UnSupported imbalance score type " + String.valueOf((Object)imbalanceScoreType) + " provided.");
    }

    public Double getMaxPerCellImbalanceScore(TopicImbalanceScoreType imbalanceScoreType) {
        switch (imbalanceScoreType) {
            case REPLICA_DISTRIBUTION_BASED: {
                return this.replicaDistributionBasedPerCell.values().stream().max(Double::compareTo).orElse((Double)Double.MAX_VALUE);
            }
            case PARTITION_DISTRIBUTION_BASED: {
                throw new IllegalArgumentException("PARTITION_DISTRIBUTION_BASED imbalance score is currently not supported at cell level");
            }
        }
        throw new IllegalArgumentException("UnSupported imbalance score type " + String.valueOf((Object)imbalanceScoreType) + " provided.");
    }
}

