/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor;

import java.io.Serializable;

public class ModelGeneration
implements Serializable {
    private static final long serialVersionUID = 1494955635123L;
    public static final int CLUSTER_GENERATION_ACCEPTABLE_STALENESS_LAG = 1;
    public static final int LOAD_GENERATION_ACCEPTABLE_STALENESS_LAG = 4;
    private final int clusterGeneration;
    private final long loadGeneration;
    private int hash = 0;

    public ModelGeneration(int clusterGeneration, long loadGeneration) {
        this.clusterGeneration = clusterGeneration;
        this.loadGeneration = loadGeneration;
    }

    public int clusterGeneration() {
        return this.clusterGeneration;
    }

    public long loadGeneration() {
        return this.loadGeneration;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ModelGeneration)) {
            return false;
        }
        ModelGeneration other = (ModelGeneration)o;
        return this.clusterGeneration == other.clusterGeneration() && this.loadGeneration == other.loadGeneration();
    }

    public boolean isStale(ModelGeneration latestModelGeneration) {
        return latestModelGeneration.clusterGeneration() - this.clusterGeneration > 1 || latestModelGeneration.loadGeneration() - this.loadGeneration > 4L;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + this.clusterGeneration;
        this.hash = result = 31 * result + (int)this.loadGeneration;
        return result;
    }

    public String toString() {
        return String.format("[ClusterGeneration=%d,LoadGeneration=%d]", this.clusterGeneration, this.loadGeneration);
    }
}

