/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.metricdefinition;

import com.linkedin.cruisecontrol.metricdef.MetricDef;
import com.linkedin.cruisecontrol.metricdef.MetricInfo;
import com.linkedin.cruisecontrol.metricdef.ValueComputingStrategy;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.RawMetricType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public enum KafkaMetricDef {
    CPU_USAGE(ValueComputingStrategy.AVG, DefScope.COMMON_REPLICA, Resource.CPU),
    DISK_USAGE(ValueComputingStrategy.LATEST, DefScope.COMMON_PARTITION, Resource.DISK),
    LEADER_BYTES_IN(ValueComputingStrategy.AVG, DefScope.COMMON_PARTITION, Resource.NW_IN),
    PRODUCER_BYTES_IN(ValueComputingStrategy.AVG, DefScope.COMMON_PARTITION, Resource.PRODUCE_IN),
    LEADER_BYTES_OUT(ValueComputingStrategy.AVG, DefScope.COMMON_PARTITION, Resource.NW_OUT),
    CONSUME_BYTES_OUT(ValueComputingStrategy.AVG, DefScope.COMMON_PARTITION, Resource.CONSUME_OUT),
    MIRROR_BYTES_IN(ValueComputingStrategy.AVG, DefScope.COMMON_PARTITION, Resource.MIRROR_IN),
    PRODUCE_RATE(ValueComputingStrategy.AVG, DefScope.COMMON_PARTITION, null),
    FETCH_RATE(ValueComputingStrategy.AVG, DefScope.COMMON_PARTITION, null),
    MESSAGE_IN_RATE(ValueComputingStrategy.AVG, DefScope.COMMON_PARTITION, null),
    REPLICATION_BYTES_IN_RATE(ValueComputingStrategy.AVG, DefScope.COMMON_REPLICA, Resource.REPLICATION_IN),
    REPLICATION_BYTES_OUT_RATE(ValueComputingStrategy.AVG, DefScope.COMMON_PARTITION, Resource.NW_OUT),
    FOLLOWER_FETCH_REQUEST_RATE(ValueComputingStrategy.AVG, DefScope.COMMON_PARTITION, null),
    FETCH_FROM_FOLLOWER_BYTES_OUT_RATE(ValueComputingStrategy.AVG, DefScope.COMMON_REPLICA, Resource.NW_OUT),
    FETCH_FROM_FOLLOWER_REQUEST_RATE(ValueComputingStrategy.AVG, DefScope.COMMON_REPLICA, null),
    BROKER_PRODUCE_REQUEST_RATE(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null),
    BROKER_CONSUMER_FETCH_REQUEST_RATE(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null),
    BROKER_FOLLOWER_FETCH_REQUEST_RATE(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null),
    BROKER_DISK_CAPACITY(ValueComputingStrategy.LATEST, DefScope.BROKER_ONLY, null),
    BROKER_PRODUCE_MIRROR_CAPACITY(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null),
    BROKER_CONSUME_CAPACITY(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null),
    RACK_BASED_CONSUME_BYTES_OUT(ValueComputingStrategy.AVG, DefScope.COMMON_REPLICA, Resource.RACK_BASED_CONSUME_OUT),
    RACK_LESS_CONSUME_BYTES_OUT(ValueComputingStrategy.AVG, DefScope.COMMON_PARTITION, Resource.RACK_LESS_CONSUME_OUT);

    private final ValueComputingStrategy valueComputingStrategy;
    private final Resource resource;
    private final DefScope defScope;
    private static final MetricDef PARTITION_METRIC_DEF;
    private static final MetricDef REPLICA_METRIC_DEF;
    private static final MetricDef COMMON_METRIC_DEF;
    private static final RawMetricTypeMapper TYPE_TO_DEF_MAPPER;

    private KafkaMetricDef(ValueComputingStrategy strategy, DefScope defScope, Resource resource) {
        this.valueComputingStrategy = strategy;
        this.defScope = defScope;
        this.resource = resource;
    }

    public ValueComputingStrategy valueComputingStrategy() {
        return this.valueComputingStrategy;
    }

    public Resource resource() {
        return this.resource;
    }

    public static List<KafkaMetricDef> kafkaMetricDefsForRawMetricType(RawMetricType type) {
        return TYPE_TO_DEF_MAPPER.get(type);
    }

    public static ValueComputingStrategy valueComputingStrategyForRawMetricType(RawMetricType type) {
        return TYPE_TO_DEF_MAPPER.valueComputingStrategy(type);
    }

    public static short commonMetricDefId(KafkaMetricDef def) {
        return KafkaMetricDef.metricDefId(COMMON_METRIC_DEF, def);
    }

    public static short partitionMetricDefId(KafkaMetricDef def) {
        return KafkaMetricDef.metricDefId(PARTITION_METRIC_DEF, def);
    }

    public static short replicaMetricDefId(KafkaMetricDef def) {
        return KafkaMetricDef.metricDefId(REPLICA_METRIC_DEF, def);
    }

    private static short metricDefId(MetricDef metricDef, KafkaMetricDef def) {
        return metricDef.metricInfo(def).id();
    }

    public static MetricDef commonMetricDef() {
        return COMMON_METRIC_DEF;
    }

    public static MetricDef partitionMetricDef() {
        return PARTITION_METRIC_DEF;
    }

    public static MetricDef replicaMetricDef() {
        return REPLICA_METRIC_DEF;
    }

    public static List<MetricInfo> resourceToMetricInfo(Resource resource) {
        return KafkaMetricDef.commonMetricDef().metricInfoForResource(resource);
    }

    public static List<MetricInfo> resourceToPartitionMetricInfo(Resource resource) {
        return KafkaMetricDef.partitionMetricDef().metricInfoForResource(resource);
    }

    public static List<Short> resourceToMetricIds(Resource resource) {
        return KafkaMetricDef.resourceToMetricInfo(resource).stream().map(MetricInfo::id).collect(Collectors.toList());
    }

    public static List<Short> resourceToPartitionMetricIds(Resource resource) {
        return KafkaMetricDef.resourceToPartitionMetricInfo(resource).stream().map(MetricInfo::id).collect(Collectors.toList());
    }

    private static MetricDef buildCommonMetricDef() {
        MetricDef metricDef = new MetricDef();
        REPLICA_METRIC_DEF.all().forEach(metricInfo -> metricDef.define(metricInfo.kafkaMetricDef()));
        PARTITION_METRIC_DEF.all().forEach(metricInfo -> metricDef.define(metricInfo.kafkaMetricDef()));
        return metricDef;
    }

    private static MetricDef buildPartitionMetricDef() {
        MetricDef metricDef = new MetricDef();
        Arrays.stream(KafkaMetricDef.values()).filter(def -> def.defScope.isCommonPartitionMetricDef()).forEach(metricDef::define);
        return metricDef;
    }

    private static MetricDef buildReplicaMetricDef() {
        MetricDef metricDef = new MetricDef();
        Arrays.stream(KafkaMetricDef.values()).filter(def -> def.defScope.isCommonReplicaMetricDef()).forEach(metricDef::define);
        return metricDef;
    }

    static {
        PARTITION_METRIC_DEF = KafkaMetricDef.buildPartitionMetricDef();
        REPLICA_METRIC_DEF = KafkaMetricDef.buildReplicaMetricDef();
        COMMON_METRIC_DEF = KafkaMetricDef.buildCommonMetricDef();
        TYPE_TO_DEF_MAPPER = new RawMetricTypeMapper.Builder().set(RawMetricType.TOPIC_BYTES_IN, LEADER_BYTES_IN, PRODUCER_BYTES_IN).set(RawMetricType.TOPIC_BYTES_OUT, LEADER_BYTES_OUT, CONSUME_BYTES_OUT).set(RawMetricType.MIRROR_TOPIC_BYTES_IN, MIRROR_BYTES_IN).set(RawMetricType.TOPIC_REPLICATION_BYTES_IN, REPLICATION_BYTES_IN_RATE).set(RawMetricType.TOPIC_REPLICATION_BYTES_OUT, REPLICATION_BYTES_OUT_RATE).set(RawMetricType.TOPIC_PRODUCE_REQUEST_RATE, PRODUCE_RATE).set(RawMetricType.TOPIC_FETCH_REQUEST_RATE, FETCH_RATE).set(RawMetricType.TOPIC_FOLLOWER_FETCH_REQUEST_RATE, FOLLOWER_FETCH_REQUEST_RATE).set(RawMetricType.TOPIC_FETCH_FROM_FOLLOWER_BYTES_OUT, FETCH_FROM_FOLLOWER_BYTES_OUT_RATE, RACK_BASED_CONSUME_BYTES_OUT).set(RawMetricType.TOPIC_NON_FFF_BYTES_OUT, RACK_LESS_CONSUME_BYTES_OUT).set(RawMetricType.TOPIC_FETCH_FROM_FOLLOWER_REQUEST_RATE, FETCH_FROM_FOLLOWER_REQUEST_RATE).set(RawMetricType.TOPIC_MESSAGES_IN_PER_SEC, MESSAGE_IN_RATE).set(RawMetricType.PARTITION_SIZE, DISK_USAGE).set(RawMetricType.ALL_TOPIC_FETCH_FROM_FOLLOWER_BYTES_OUT, FETCH_FROM_FOLLOWER_BYTES_OUT_RATE).set(RawMetricType.ALL_TOPIC_NON_FFF_BYTES_OUT, RACK_LESS_CONSUME_BYTES_OUT).set(RawMetricType.ALL_TOPIC_FETCH_FROM_FOLLOWER_REQUEST_RATE, FETCH_FROM_FOLLOWER_REQUEST_RATE).set(RawMetricType.ALL_TOPIC_BYTES_IN, LEADER_BYTES_IN).set(RawMetricType.ALL_MIRROR_TOPIC_BYTES_IN, MIRROR_BYTES_IN).set(RawMetricType.ALL_TOPIC_BYTES_OUT, LEADER_BYTES_OUT).set(RawMetricType.ALL_TOPIC_REPLICATION_BYTES_IN, REPLICATION_BYTES_IN_RATE).set(RawMetricType.ALL_TOPIC_REPLICATION_BYTES_OUT, REPLICATION_BYTES_OUT_RATE).set(RawMetricType.ALL_TOPIC_PRODUCE_REQUEST_RATE, PRODUCE_RATE).set(RawMetricType.ALL_TOPIC_FETCH_REQUEST_RATE, FETCH_RATE).set(RawMetricType.ALL_TOPIC_FOLLOWER_FETCH_REQUEST_RATE, FOLLOWER_FETCH_REQUEST_RATE).set(RawMetricType.ALL_TOPIC_MESSAGES_IN_PER_SEC, MESSAGE_IN_RATE).set(RawMetricType.BROKER_CPU_UTIL, CPU_USAGE).set(RawMetricType.BROKER_PRODUCE_REQUEST_RATE, BROKER_PRODUCE_REQUEST_RATE).set(RawMetricType.BROKER_CONSUMER_FETCH_REQUEST_RATE, BROKER_CONSUMER_FETCH_REQUEST_RATE).set(RawMetricType.BROKER_FOLLOWER_FETCH_REQUEST_RATE, BROKER_FOLLOWER_FETCH_REQUEST_RATE).set(RawMetricType.BROKER_DISK_CAPACITY, BROKER_DISK_CAPACITY).set(RawMetricType.BROKER_PRODUCE_MIRROR_CAPACITY, BROKER_PRODUCE_MIRROR_CAPACITY).set(RawMetricType.BROKER_CONSUME_CAPACITY, BROKER_CONSUME_CAPACITY).build();
    }

    public static enum DefScope {
        BROKER_ONLY,
        COMMON_REPLICA,
        COMMON_PARTITION;


        boolean isCommonMetricDef() {
            return this == COMMON_PARTITION || this == COMMON_REPLICA;
        }

        boolean isCommonPartitionMetricDef() {
            return this == COMMON_PARTITION;
        }

        boolean isCommonReplicaMetricDef() {
            return this == COMMON_REPLICA;
        }
    }

    static class RawMetricTypeMapper {
        private final Map<RawMetricType, List<KafkaMetricDef>> typeToDef;

        private RawMetricTypeMapper(Map<RawMetricType, List<KafkaMetricDef>> typeToDef) {
            this.typeToDef = typeToDef;
        }

        public ValueComputingStrategy valueComputingStrategy(RawMetricType type) {
            return this.get((RawMetricType)type).get((int)0).valueComputingStrategy;
        }

        public List<KafkaMetricDef> get(RawMetricType type) {
            List<KafkaMetricDef> kafkaMetricDefs = this.typeToDef.get((Object)type);
            if (kafkaMetricDefs == null) {
                throw new IllegalArgumentException(String.format("The metric type %s is not supported.", new Object[]{type}));
            }
            return kafkaMetricDefs;
        }

        public static class Builder {
            private final Map<RawMetricType, List<KafkaMetricDef>> typeToDef = new HashMap<RawMetricType, List<KafkaMetricDef>>();

            public Builder set(RawMetricType type, KafkaMetricDef ... defs) {
                if (this.typeToDef.containsKey((Object)type)) {
                    throw new IllegalArgumentException(String.format("The type %s has already been set.", new Object[]{type}));
                }
                if (defs == null || defs.length == 0) {
                    throw new IllegalArgumentException("The metric definitions cannot be null or empty.");
                }
                List<KafkaMetricDef> metricDefs = Arrays.asList(defs);
                if (metricDefs.stream().anyMatch(Objects::isNull)) {
                    throw new IllegalArgumentException("The metric definitions cannot be null.");
                }
                if (metricDefs.size() > 1 && metricDefs.stream().map(d -> d.valueComputingStrategy.name()).collect(Collectors.toSet()).size() > 1) {
                    throw new IllegalArgumentException(String.format("Detected varying computing strategies (%s) for the same metric %s", new Object[]{metricDefs.stream().map(d -> d.valueComputingStrategy.name()).collect(Collectors.toSet()), type}));
                }
                this.typeToDef.put(type, metricDefs);
                return this;
            }

            public RawMetricTypeMapper build() {
                return new RawMetricTypeMapper(this.typeToDef);
            }
        }
    }
}

