/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;

public class SamplingOptions {
    public final long startMs;
    public final long endMs;
    public final Cluster cluster;
    public final Set<PartitionInfo> partitionAssignment;
    public final Set<TopicPartition> assignedTopicPartitions;

    public SamplingOptions(long startMs, long endMs, Cluster cluster) {
        this.startMs = startMs;
        this.endMs = endMs;
        HashSet<PartitionInfo> partitionAssignment = new HashSet<PartitionInfo>();
        HashSet<TopicPartition> assignedTopicPartitions = new HashSet<TopicPartition>();
        for (String topic : cluster.topics()) {
            for (PartitionInfo pi : cluster.partitionsForTopic(topic)) {
                partitionAssignment.add(pi);
                assignedTopicPartitions.add(new TopicPartition(pi.topic(), pi.partition()));
            }
        }
        this.partitionAssignment = Collections.unmodifiableSet(partitionAssignment);
        this.assignedTopicPartitions = Collections.unmodifiableSet(assignedTopicPartitions);
        this.cluster = cluster;
    }

    public String toString() {
        return "SamplingOptions{startMs=" + this.startMs + ", endMs=" + this.endMs + ", partitionAssignment=" + String.valueOf(this.partitionAssignment) + "}";
    }
}

