/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling.holder;

import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.RawMetricType;
import java.util.HashMap;
import java.util.Map;

class HolderUtils {
    static final double MISSING_BROKER_METRIC_VALUE = 0.0;
    static final Map<RawMetricType, RawMetricType> METRIC_TYPES_TO_SUM = new HashMap<RawMetricType, RawMetricType>();

    private HolderUtils() {
    }

    static void sanityCheckMetricScope(RawMetricType rawMetricType, RawMetricType.MetricScope expectedMetricScope) {
        if (rawMetricType.metricScope() != expectedMetricScope) {
            throw new IllegalArgumentException(String.format("Metric scope %s of raw metric type with id %d does not match the expected metric scope %s.", new Object[]{rawMetricType.metricScope(), rawMetricType.id(), expectedMetricScope}));
        }
    }

    static {
        METRIC_TYPES_TO_SUM.put(RawMetricType.TOPIC_PRODUCE_REQUEST_RATE, RawMetricType.ALL_TOPIC_PRODUCE_REQUEST_RATE);
        METRIC_TYPES_TO_SUM.put(RawMetricType.TOPIC_FETCH_REQUEST_RATE, RawMetricType.ALL_TOPIC_FETCH_REQUEST_RATE);
        METRIC_TYPES_TO_SUM.put(RawMetricType.TOPIC_FOLLOWER_FETCH_REQUEST_RATE, RawMetricType.ALL_TOPIC_FOLLOWER_FETCH_REQUEST_RATE);
        METRIC_TYPES_TO_SUM.put(RawMetricType.TOPIC_FETCH_FROM_FOLLOWER_BYTES_OUT, RawMetricType.ALL_TOPIC_FETCH_FROM_FOLLOWER_BYTES_OUT);
        METRIC_TYPES_TO_SUM.put(RawMetricType.TOPIC_NON_FFF_BYTES_OUT, RawMetricType.ALL_TOPIC_NON_FFF_BYTES_OUT);
        METRIC_TYPES_TO_SUM.put(RawMetricType.TOPIC_FETCH_FROM_FOLLOWER_REQUEST_RATE, RawMetricType.ALL_TOPIC_FETCH_FROM_FOLLOWER_REQUEST_RATE);
        METRIC_TYPES_TO_SUM.put(RawMetricType.TOPIC_BYTES_IN, RawMetricType.ALL_TOPIC_BYTES_IN);
        METRIC_TYPES_TO_SUM.put(RawMetricType.TOPIC_BYTES_OUT, RawMetricType.ALL_TOPIC_BYTES_OUT);
        METRIC_TYPES_TO_SUM.put(RawMetricType.TOPIC_REPLICATION_BYTES_IN, RawMetricType.ALL_TOPIC_REPLICATION_BYTES_IN);
        METRIC_TYPES_TO_SUM.put(RawMetricType.TOPIC_REPLICATION_BYTES_OUT, RawMetricType.ALL_TOPIC_REPLICATION_BYTES_OUT);
        METRIC_TYPES_TO_SUM.put(RawMetricType.TOPIC_MESSAGES_IN_PER_SEC, RawMetricType.ALL_TOPIC_MESSAGES_IN_PER_SEC);
    }
}

