/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.operation;

import com.linkedin.kafka.cruisecontrol.executor.ExecutorReservationHandle;
import com.linkedin.kafka.cruisecontrol.operation.BrokerRemovalContext;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerRemovalFuture {
    private static final Logger LOG = LoggerFactory.getLogger(BrokerRemovalFuture.class);
    private final BrokerRemovalContext removalContext;
    private final CompletableFuture<Void> initialFuture;
    private final CompletableFuture<Void> chainedFutures;

    public BrokerRemovalFuture(BrokerRemovalContext removalContext, CompletableFuture<Void> initialFuture, CompletableFuture<Void> chainedFutures) {
        this.removalContext = removalContext;
        this.initialFuture = initialFuture;
        this.chainedFutures = chainedFutures;
    }

    public void execute(Duration duration) throws Throwable {
        try {
            this.initialFuture.complete(null);
            this.chainedFutures.get(duration.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
        finally {
            ExecutorReservationHandle handle = this.removalContext.reservationHandle().get();
            if (handle != null) {
                handle.close();
            }
        }
    }

    public boolean cancel(String reason) {
        boolean planExecutionOngoing;
        boolean wasCanceled = this.chainedFutures.cancel(true);
        if (wasCanceled) {
            LOG.info("Successfully canceled the broker removal task.");
        } else if (!this.chainedFutures.isDone()) {
            LOG.error("Did not manage to cancel the broker removal task. Proceeding to cancel plan execution if it's ongoing.");
        }
        LOG.debug("Cancelling the proposal execution task.");
        ExecutorReservationHandle reservationHandle = this.removalContext.reservationHandle().get();
        if (reservationHandle != null) {
            reservationHandle.stopExecution(reason);
        }
        LOG.info("Signalled Executor stop execution.");
        boolean planExecutionDoneOrNotStarted = this.removalContext.executorFuture().map(Future::isDone).orElse(true);
        boolean bl = planExecutionOngoing = !planExecutionDoneOrNotStarted;
        if (planExecutionOngoing) {
            Optional<Future<?>> executorFuture = this.removalContext.executorFuture();
            boolean executorFutureWasCanceled = executorFuture.get().cancel(true);
            if (executorFutureWasCanceled) {
                LOG.info("Successfully canceled the execution proposal task.");
            } else {
                LOG.warn("Could not cancel the execution proposal task.");
            }
        }
        return wasCanceled || this.chainedFutures.isDone();
    }
}

