/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.statemachine;

import com.linkedin.kafka.cruisecontrol.common.KafkaCruiseControlThreadFactory;
import com.linkedin.kafka.cruisecontrol.statemachine.Task;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateMachineProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(StateMachineProcessor.class);
    private final ExecutorService executor;
    private final BlockingQueue<Task> taskQueue = new LinkedBlockingQueue<Task>();
    private volatile boolean shutdownRequested = false;

    public StateMachineProcessor() {
        KafkaCruiseControlThreadFactory threadFactory = new KafkaCruiseControlThreadFactory("StateMachineProcessor", true, LOG);
        this.executor = Executors.newFixedThreadPool(2, threadFactory);
        this.executor.submit(this::processTasks);
    }

    public void shutdown() {
        if (this.shutdownRequested) {
            throw new RuntimeException("StateMachineProcessor getting shut down or is already shut down.");
        }
        this.shutdownRequested = true;
        try {
            this.executor.shutdownNow();
        }
        catch (Exception ex) {
            LOG.error(String.format("Couldn't shutdown the StateMachineProcessor's thread cleanly while it had %s pending tasks", this.taskQueue.size()), (Throwable)ex);
        }
        finally {
            LOG.info("Shut down the StateMachineProcessor while it had {} pending tasks.", (Object)this.taskQueue.size());
        }
    }

    public void scheduleTaskForExecution(Task task) {
        if (this.shutdownRequested) {
            throw new RuntimeException("StateMachineProcessor already shutdown. Can't execute task: " + String.valueOf(task));
        }
        this.taskQueue.add(task);
    }

    private void processTasks() {
        do {
            Task task = null;
            try {
                task = this.taskQueue.take();
                LOG.info("Starting to process task ({}) with id: {}", (Object)task.getClass().getSimpleName(), (Object)task.taskId());
                task.run();
            }
            catch (InterruptedException e) {
                LOG.info("State machine processing thread was interrupted. Shutting down.");
                LOG.debug("State machine thread interrupted.", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOG.info("State machine processing task ({}) threw exception.", (Object)task, (Object)e);
                LOG.info("Proceeding to process next task.");
            }
        } while (!this.shutdownRequested && !Thread.currentThread().isInterrupted());
    }
}

